implementation module Life;

import	StdClass;
import StdInt, StdBool;


    

::	Generation	:== [[LifeCell]];
::	LifeCell	:== (!Int, !Int);


    
//	LifeGame gen_n -> (gen_n+1, newborns_n+1, died_n+1);

LifeGame	:: !Generation -> (!Generation, !Generation, !Generation);
LifeGame gen =  NextGen gen gen;

NextGen	:: !Generation !Generation -> (!Generation, !Generation, !Generation);
NextGen [[c=:(x,y) : cs_x] : cs_xs] gen_n
		| Neighbours34 (Neighbours c gen_n)= 	(InsertCell c gen_n_div_1`, new, died_n_div_1);
	= 	(gen_n_div_1`, new, InsertCell c died_n_div_1);
		where {
		(gen_n_div_1, newborns_n_div_1, died_n_div_1)=: NextGen [cs_x : cs_xs] gen_n`;
		(gen_n_div_1`, new)	=: NewBorns c newborns_n_div_1 gen_n_div_1 gen_n;
		gen_n`			=: ShiftGeneration [cs_x : cs_xs] gen_n;
		};
NextGen [[] : cs_xs] gen_n
	= 	NextGen cs_xs gen_n;
NextGen [] gen_n
	= 	([], [], []);
	
NewBorns	:: !LifeCell !Generation !Generation !Generation -> (!Generation, !Generation);
NewBorns c=:(x1, y1) newborns_n_div_1 gen_n_div_1 gen_n
	= 	NewBorns` (NewBornNeighbours c gen_n) newborns_n_div_1 gen_n_div_1 gen_n;

NewBorns`	:: ![LifeCell] !Generation !Generation !Generation -> (!Generation, !Generation);
NewBorns` [] newborns_n_div_1 gen_n_div_1 gen_n =  (gen_n_div_1, newborns_n_div_1);
NewBorns` [c=:(x1, y1) : cs] newborns_n_div_1 gen_n_div_1 gen_n
		| Neighbours3 (Neighbours c gen_n)= 	(InsertCell c gen_n_div_1`, InsertCell c newborns_n_div_1`);
	= 	next_gen_and_newborns;
		where {
		(gen_n_div_1`, newborns_n_div_1`)=: next_gen_and_newborns;
		next_gen_and_newborns		 =: NewBorns` cs newborns_n_div_1 gen_n_div_1 gen_n;
		};

ShiftGeneration	:: !Generation !Generation -> Generation;
ShiftGeneration [[(x,y) : cs_x] : cs_xs] gen_n
	= 	ShiftGeneration` (x - 2, y - 2) gen_n;
ShiftGeneration [[], [(x,y) : cs_x] : cs_xs] gen_n
	= 	ShiftGeneration` (x - 2, y - 2) gen_n;
ShiftGeneration partial_gen_n gen_n
	= 	gen_n;
	
ShiftGeneration`	:: !LifeCell !Generation -> Generation;
ShiftGeneration` c=:(x1, y1) gen=:[[c2=:(x2, y2) : cs_x] : cs_xs]
				| x2 < x1= 	ShiftGeneration` c cs_xs;
		| x2 == x1 && y2 < y1= 	ShiftGeneration` c [cs_x : cs_xs];
	= 	gen;
ShiftGeneration` c [[] : cs_xs]
	= 	ShiftGeneration` c cs_xs;
ShiftGeneration` c []
	= 	[];

Neighbours34	:: [LifeCell] -> Bool;
Neighbours34 [c1, c2, c3]	  =  True;
Neighbours34 [c1, c2, c3, c4] =  True;
Neighbours34 cs			  	  =  False;	

Neighbours3	:: [LifeCell] -> Bool;
Neighbours3 [c1, c2, c3] =  True;
Neighbours3 cs =  False;	

/*	Neighbours c gen_n -> neighbours of c in gen_n in decreasing order.
	Lazy evaluation for Neighbours23 and Neighbours3!!
*/
Neighbours	:: !LifeCell !Generation -> [LifeCell];
Neighbours (x,y) gen_n
	= 	Neighbours` (dec x) (inc x) (dec y) gen_n [];

Neighbours`	:: !Int !Int !Int !Generation ![LifeCell] -> [LifeCell];
Neighbours` x xn y [cs=:[(x2, y2) : cs_x2] : cs_xs] neighbours
											| x2  < x= 	Neighbours` x xn y cs_xs neighbours;
		| x2 <= xn= 	Neighbours`` y (y + 2) cs (Neighbours` (inc x) xn y cs_xs neighbours);
	= 	neighbours;
Neighbours` x xn y [] neighbours
	= 	neighbours;

Neighbours``	:: !Int !Int ![LifeCell] ![LifeCell] -> [LifeCell];
Neighbours`` y yn [c=:(x2, y2) : cs] cs_xs
					| y2  < y= 	Neighbours`` y yn cs cs_xs;
		| y2 <= yn= 	let! {
		strict1;
		} in
		[c : strict1];
	= 	cs_xs;
	where {
	strict1=Neighbours`` (inc y) yn cs cs_xs;
		
	};
Neighbours`` y yn [] cs_xs
	= 	cs_xs;

/*	NewBornNeighbours c gen_n -> dead neighbours of c in gen_n in decreasing order.
	Lazy evaluation for Neighbours34 and Neighbours4!!
*/
NewBornNeighbours	:: !LifeCell !Generation -> [LifeCell];
NewBornNeighbours (x,y) gen_n
	= 	NewBornNeighbours` (dec x) (inc x) (dec y) gen_n [];

NewBornNeighbours`	:: !Int !Int !Int !Generation ![LifeCell] -> [LifeCell];
NewBornNeighbours` x xn y [cs=:[(x2, y2) : cs_x2] : cs_xs] newborns
													| x >  xn= 	newborns;
					| x2 < x= 	NewBornNeighbours` x xn y cs_xs newborns;
			| x2 == x= 	NewBornNeighbours`` x y (y + 2) cs 
			(NewBornNeighbours` (inc x) xn y cs_xs newborns);
	= 	let! {
		strict1;
		} in
		[(x,y),(x,inc y),(x,y + 2) : strict1];
	where {
	strict1=NewBornNeighbours` (inc x) xn y cs_xs newborns;
		
	};
NewBornNeighbours` x xn y [] newborns
			| x > xn= 	newborns;
	= 	let! {
		strict1;
		} in
		[(x,y),(x,inc y),(x,y + 2) : strict1];
	where {
	strict1=NewBornNeighbours` (inc x) xn y [] newborns;
		
	};

NewBornNeighbours``	:: !Int !Int !Int ![LifeCell] ![LifeCell] -> [LifeCell];
NewBornNeighbours`` x y yn [c=:(x2, y2) : cs] cs_xs
													| y  >  yn= 	cs_xs;
						| y2  < y= 	NewBornNeighbours`` x y yn cs cs_xs;
				| y2  == y= 	NewBornNeighbours`` x (inc y) yn cs cs_xs;
	= 	let! {
		strict1;
		} in
		[(x,y) : strict1];
	where {
	strict1=NewBornNeighbours`` x (inc y) yn cs cs_xs;
		
	};
NewBornNeighbours`` x y yn [] cs_xs
			| y > yn= 	cs_xs;
	= 	let! {
		strict1;
		} in
		[(x,y) : strict1];
	where {
	strict1=NewBornNeighbours`` x (inc y) yn [] cs_xs;
		
	};

InsertCell	:: !LifeCell !Generation -> Generation;
InsertCell c=:(x1, y1) gen=:[cs=:[(x2, y2) : cs_x2] : cs_xs]
		| x2 < x1= 	let! {
		strict1;
		} in
		[cs : strict1];
		| x2 == x1= 	let! {
		strict2;
		} in
		[strict2 : cs_xs];
	= 	[[c], cs : cs_xs];
	where {
	strict2=InsertCell` c cs;
		
	strict1=InsertCell c cs_xs;
		};
InsertCell c []
	= 	[[c]];

InsertCell`	:: !LifeCell ![LifeCell] -> [LifeCell];
InsertCell` c [] =  [c];
InsertCell` c=:(x1, y1) l=:[c2=:(x2, y2) : cs]
		| y2 < y1= 	let! {
		strict1;
		} in
		[c2 : strict1];
								| y2 == y1= 	l;
	= 	[c, c2 : cs];
	where {
	strict1=InsertCell` c cs;
		
	};
	
RemoveCell	:: !LifeCell !Generation -> Generation;
RemoveCell c1=:(x1, y1) gen=:[cs=:[(x2, y2) : cs_x2] : cs_xs]
			| x2 < x1= 	let! {
		strict1;
		} in
		[cs : strict1];
									| x2 > x1= 	gen;
								| IsEmptyList removecell= 	cs_xs;
	= 	[removecell : cs_xs];
		where {
		removecell=: RemoveCell` y1 cs;
		strict1=RemoveCell c1 cs_xs;
		};
RemoveCell c [[] : cs_xs]
	= 	RemoveCell c cs_xs;
RemoveCell c []
	= 	[];

RemoveCell`	:: !Int ![LifeCell] -> [LifeCell];
RemoveCell` y1 [] =  [];
RemoveCell` y1 l=:[c2=:(x2, y2) : cs]
		| y2 < y1= 	let! {
		strict1;
		} in
		[c2 : strict1];
								| y2 == y1= 	cs;
	= 	l;
	where {
	strict1=RemoveCell` y1 cs;
		
	};

IsEmptyList	:: [x] -> Bool;
IsEmptyList []  =  True;
IsEmptyList xs  =  False;

//	Apply a function to all cells of a generation.

Map	:: !(LifeCell -> x) !Generation -> [x];
Map f [row : rows] =  MapRow f row rows;
Map f [] =  [];

MapRow	:: !(LifeCell -> x) ![LifeCell] !Generation -> [x];
MapRow f [cell : cells] rows =  let! {
		strict1;
		strict2;
		} in
		[strict1 : strict2];
	where {
	strict1=f cell;
		strict2=MapRow f cells rows;
		
	};
MapRow f [] rows =  Map f rows;
