(********************************************************************************************
** PROGRAM     : LowName
** VERSION     : 1.0.0
** DESCRIPTION : Converts filenames to lowercase.
** AUTHOR      : Stuart King
** COPYRIGHT   : Copyright (c) Irie Tools, 2002. All Rights Reserved.
** NOTES       :
**    This sample program is distributed with Irie Pascal, and was written to provide
** an example of how to manipulates files and directories. I find this program useful
** when transferring files between operating systems, because sometimes the case of
** the filenames is changed. To make best use of this sample you should have a basic
** understanding of Pascal.
**********************************************************************************************)
program lowname;
var
   param : integer;

   procedure syntax;
   begin
      writeln('lowname');
      writeln('SYNTAX: lowname file(s) ...');
      halt
   end;

   procedure ConvertFile(fname : filename);
   var
      f : text;
   begin
      writeln(fname, ' -> ', lowercase(fname));

   	//Associate the name of the file to be renamed so that 'rename' knows which
   	//file to rename. NOTE: 'rename' takes a file variable and a string as parameters,
   	//and expects the name of the file to be renamed to be associated with the
   	//file variable, and the string to contain the name the file should be renamed to.
      assign(f, fname);
      rename(f, lowercase(fname))
   end;

   procedure ConvertTextFiles(f : filename);
   var
      DirPart, NamePart, ExtPart : filename;
      fname : filename;
      d : Dir;

   begin (* ConvertTextFiles *)
      f := fexpand(f);
      writeln(f);
      fsplit(f, DirPart, NamePart, ExtPart);
      NamePart := NamePart + ExtPart;
      OpenDir(d, DirPart);
      repeat
         ReadDir(d, fname);
         if fname <> '' then    (* if there are more files in directory *)
            begin
               if FileMatch(NamePart, fname) then
                  begin
                     if fname <> lowercase(fname) then
                        ConvertFile(DirPart+fname)
                  end
            end
      until fname = '';
      CloseDir(d)
   end; (* ConvertTextFiles *)

begin
   if paramcount = 0 then
      syntax;
   for param := 1 to paramcount do
      ConvertTextFiles(paramstr(param));
end.
