(********************************************************************************************
** PROGRAM     : type2
** VERSION     : 1.0.0
** DESCRIPTION : Copies characters from an input file to the standard output.
** AUTHOR      : Stuart King
** COPYRIGHT   : Copyright (c) Irie Tools, 1998-2002. All Rights Reserved.
** NOTES       :
**    This sample program is distributed with Irie Pascal, and was written as an example
** of how to read and write files using Irie Pascal. To make best use of this sample you
** should have a basic understanding of Pascal.
**
** Syntax: ivm type2 in
**    where 'in' is the name of the input file.
**********************************************************************************************)
program type2(output);
var
   f : text;
   c : char;
begin
   if paramcount <> 1 then
      begin
         writeln('Types the contents of the input file to the standard output');
         writeln('Syntax:     ivm type2 in');
         writeln('where ''in'' is the input file');
         halt
      end;
   assign(f, paramstr(1));
   reset(f);            (* Open 'in' *)
   while not eof(f) do
      if eoln(f) then
         begin
            readln(f);
            writeln
         end
      else
         begin
            read(f, c);
            write(c)
         end
end.
