#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/parser/RCS/Prefix.py,v $
# Version:      @(#)$RCSfile: Prefix.py,v $ $Revision: 1.4 $
#
#############################################################################
""" A class to represent IDL prefixes! """


class Prefix:

    def __init__(self, pragma="", prefix=""):
	""" Constructor. """

	self.__pragma = pragma
	self.__prefix = prefix

	return

    def __str__(self):

	if len(self.__pragma) > 0:
	    result = "%s/%s" % (self.__pragma, self.__prefix)

	else:
	    result = self.__prefix

	return result

    __repr__ = __str__

    def get_prefix(self):
	return self.__prefix

    def set_prefix(self, prefix):
	self.__prefix = prefix
	return

    def get_pragma(self):
	return self.__pragma

    def set_pragma(self, pragma):
	self.__pragma = pragma
	return

#############################################################################
