/* (c) Copyright IBM Corporation 1993 */

/* Install DrDialog's Workplace Shell objects */
CALL RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
Call SysLoadFuncs
dir = Directory()

/* Remove old associations, if any */
Call SysIni 'USER', 'PMWP_ASSOC_TYPE', 'DrDialog.RES', 'DELETE:'
Call SysIni 'USER', 'PMWP_ASSOC_TYPE', 'DrRexx.RES',   'DELETE:'

/* Create the 'DrDialog' folder (if necessary): */
msg = "create the DrDialog folder"
rc  = SysCreateObject( "WPFolder", "DrDialog", "<WP_DESKTOP>", "OBJECTID=<DRDIALOG>;", "U" )
If \rc Then rc = SysCreateObject( "WPFolder", "DrDialog", "<WP_DESKTOP>", "OBJECTID=<DRDIALOG>;", "R" )
If \rc Then Call FAILED

msg = "find DrRexx.EXE"
rc  = SysFileTree( "DRREXX.EXE", "FILE", "FO" )
IF rc \= 0 THEN Signal ABORT
msg = "create DrRexx program object"
rc  = SysCreateObject( "WPProgram", "DrRexx", "<DRDIALOG>", "PROGTYPE=PM;EXENAME="file.1";ASSOCTYPE=DrRexx.RES;STARTUPDIR="dir";", "R" )
If \rc Then Call FAILED

/* Create program objects: */
objects = "REStoPGM REStoEXE REStoRXX REView REVise RexxLib DrsAide"
rc = SysFileTree( "DREXAM.RAM", "TEMP", "FO" )
IF temp.0 = 1 THEN objects = objects "DrExam"
DO i = 1 TO words( objects )
   CALL MakeProgramObject word( objects, i )
END

/* Create shadows of any necessary data files and directories: */
objects = "DrDialog.RES DrRexx.RES DrsAideT.RES DrsAide.RXL"
DO i = 1 TO words( objects )
   CALL MakeShadowObject word( objects, i )
END

msg = "find DrDialog.EXE"
rc  = SysFileTree( "DRDIALOG.EXE", "FILE", "FO" )
IF rc \= 0 THEN Signal ABORT
msg = "create DrDialog program object"
rc  = SysCreateObject( "WPProgram", "DrDialog", "<DRDIALOG>", "PROGTYPE=PM;EXENAME="file.1";ASSOCTYPE=DrDialog.RES,DrRexx.RES;STARTUPDIR="dir";", "R" )
If \rc Then Call FAILED

msg  = "find OS/2 system VIEW.EXE program"
view = SysSearchPath( "PATH", "VIEW.EXE" )
IF view = "" THEN Signal ABORT
msg = "find DrDialog on-line reference file"
rc  = SysFileTree( "DRDIALOG.INF", "FILE", "FO" )
IF rc \= 0 THEN Signal ABORT
msg = "create on-line reference object"
rc = SysCreateObject( "WPProgram", "DrDialog reference", "<DRDIALOG>", "PROGTYPE=PM;EXENAME="view";PARAMETERS="file.1";", "R"  )
If \rc Then Call FAILED

/* Now make sure that the templates have the correct "Type" EA: */
/* Set the "TEMPLATE=" setup option */
Call SysSetObjectData dir'\DRDIALOG.RES', 'TEMPLATE=YES;'
Call SysSetObjectData dir'\DRREXX.RES',   'TEMPLATE=YES;'
Call SysSetObjectData dir'\DRSAIDET.RES', 'TEMPLATE=YES;'
Call SysPutEA 'DRREXX.RES', ".TYPE", 'DFFF00000100FDFF'x||D2C(Length('DrRexx.RES'))||'00'x||'DrRexx.RES'
Call SysPutEA 'DRDIALOG.RES', ".TYPE", 'DFFF00000100FDFF'x||D2C(Length('DrDialog.RES'))||'00'x||'DrDialog.RES'

SAY "DrDialog installation complete..."
SAY "You may now open the 'DrDialog' folder on your desktop"
say "Enter to exit.."
pull ans
EXIT

FAILED:
  SAY "Failed trying to" msg
  RETURN

ABORT:
  SAY "Failed trying to" msg
  EXIT 100

MakeProgramObject:
  PARSE ARG object
  msg = "create" object "program object"
  rc  = SysCreateObject( "WPProgram", object, "<DRDIALOG>", "PROGTYPE=PM;EXENAME="file.1";STARTUPDIR="dir";PARAMETERS="dir"\"object "%*", "R" )
  If \rc Then Call FAILED
  RETURN

MakeShadowObject:
  PARSE ARG object
  msg = "create shadow of" object
  rc  = SysCreateObject( "WPShadow", object, "<DRDIALOG>", "SHADOWID="dir"\"object";", "R" )
  If \rc Then Call FAILED
  RETURN
