/* REXX **********************************************/
/*                                                   */
/* Program name: ApplSet                             */
/*                                                   */
/* Function....:                                     */
/* Author......: Janosch R. Kowalczyk                */
/* Create date.:                                     */
/* Version.....:                                     */
/*                                                   */
/* Changes:                                          */
/*                                                   */
/* (C) Copyright Janosch R. Kowalczyk, 1996.         */
/* All rights reserved.                              */
/*                                                   */
/*****************************************************/
/* trace r */
Parse Source envir calledAs procName .
Parse Arg destPath 

/*===============(Exception handling)================*/
Signal On Failure Name CLEANUP
Signal On Halt    Name CLEANUP
Signal On Syntax  Name CLEANUP

Call On NOTREADY

/*============(Initialize RexxUtil support)===========*/
If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

currDir = Directory( destPath ) 

/*------------(Get data value for a key)------------*/
inifile = destPath'\GreedX.fnc'  /* USER SYSTEM BOTH Pathname */
appl    = 'Constructs' /* Application name          */
key     = 'Rexx frame' /* Key name                  */
value = SysIni( inifile, appl, key )
If value = 'ERROR:' Then Do
  /* Say 'File' inifile 'will be restructured' */
  Call CopyAppl inifile, inifile
  /* Say Copies( '=', 60 ) */
End
Else delFlag = 1

/*------------(Get data value for a key)------------*/
inifile = 'Greed.fnc'  /* USER SYSTEM BOTH Pathname */
appl    = 'Constructs' /* Application name          */
key     = 'Rexx frame' /* Key name                  */
value = SysIni( inifile, appl, key )
If value = 'ERROR:' Then Do
  /* Say 'Now the file' inifile */
  Call CopyAppl inifile, inifile
End
Else If delFlag = 1 Then Do
  delRC = SysFileDelete( 'CAPPLOG.grd' )
End

/*=================(End this program)=================*/
Exit

CLEANUP:
  Say 'GREED001E - Break, Failure or Syntax Error'
  Say 'GREED002E - in the procedure' pgmName'.' 
Exit

NOTREADY:
  Parse Var response . ':' errcode
  If DataType( errcode ) = 'NUM' Then
    Say SysGetMessage(errcode)
  Say
  Call LineOut ,"Retry (Y/N)? "
  Pull response
  If response = 'N' Then Exit

Return


/*=================(P R O C E D U R E S)=================*/

CopyAppl: Procedure Expose pgmName
Arg iniFile, iniDest  

fileName = 'CAPPLOG.grd'
/*-----------(Get names of all applications)----------*/
result = SysIni( iniFile, 'ALL:', 'appl' )
If result = 'ERROR:' | appl.0 = 0 Then 
  /* Say result 'No application(s) found' */
Else Do
  Do i = 1 To appl.0
    Say appl.i
    outLine = 'inAppl.'i '= "'appl.i'"'
    rc = LineOut( fileName, outLine )
    appl = appl.i                /* Application name */
    result = SysIni( iniFile, appl, 'ALL:', 'key' )
    If result = 'ERROR:' | key.0 = 0 Then
      Say result 'No key(s) found for application' appl.i
    Else Do
      If appl = 'Rexx Constructs' | appl = 'Constructs' Then
        destAppl = 'Constructs'
      Else If appl = 'Rexx API' | appl = 'API' Then
        destAppl = 'API'
      Else If appl = 'Rexx Built-in Functions' | appl = 'Rexx built-in functions' Then 
        destAppl = 'Rexx built-in functions'
      Else If appl = 'RexxUtil' Then destAppl = appl
      Else destAppl = ''
      If destAppl > '' Then Do
        Do j = 1 To key.0
          outLine = destAppl key.j
          Say outLine
          rc = LineOut( fileName, outLine )
          value = SysIni( iniFile, appl, key.j )
          /* rc = LineOut( fileName, value ) */
          If key.j = 'SysIni: Delete Application' Then Do
            key = 'SysIni: Delete application'
            retVal = SysIni( iniDest, destAppl, key, value )
          End
          Else If key.j = 'SysIni: Delete Key' Then Do
            key = 'SysIni: Delete key'
            retVal = SysIni( iniDest, destAppl, key, value )
          End
          Else If key.j = 'SysIni: Get Data Value' Then Do
            key = 'SysIni: Read value'
            retVal = SysIni( iniDest, destAppl, key, value )
          End
          Else If key.j = 'SysIni: Get Names of all Applications' Then Do
            key = 'SysIni: Read all applications'
            retVal = SysIni( iniDest, destAppl, key, value )
          End
          Else If key.j = 'SysIni: Get Names of all Keys' Then Do
            key = 'SysIni: Read all keys'
            retVal = SysIni( iniDest, destAppl, key, value )
          End
          Else If key.j = 'SysIni: Write Data Value' Then Do
            key = 'SysIni: Write value'
            retVal = SysIni( iniDest, destAppl, key, value )
          End
          Else If key.j = 'Center/Centre' Then Do
            key = 'Center'
            retVal = SysIni( iniDest, destAppl, key, value )
          End
          Else If key.j = 'BitXOr' Then Do
            key = 'BitXor'
            retVal = SysIni( iniDest, destAppl, key, value )
          End
          Else
            retVal = SysIni( iniDest, destAppl, key.j, value )
 
          If retVal > '' Then
            Say 'Error writting/deleting' destAppl',' key
        End
        /* CAUTION: The next code line deletes all moved applications. Don't use */
        /* it if you want to use still Greed Version 2.11 or previous            */ 
        /* If appl \= destAppl Then retVal = SysIni( iniDest, appl, 'DELETE:' )  */
      End
    End
  End
  value = SysIni( iniFile, 'Rexx Frames', 'RexxUtil' )
  if value \= 'ERROR:' Then Do
    retVal = SysIni( iniDest, 'Constructs', 'Rexx frame', value )
    outLine = 'Constructs' 'Rexx frame'
  End 
  Else
    outLine = Value
  Say outLine
  rc = LineOut( fileName, outLine )
  status = Stream( fileName, 'C', 'Close' )
End

return 0