/* REXX *********************************************/
/*                                                  */
/* Program name: DELSAVES                           */
/* Function    : Delete Backup after successfully   */
/*               installation                       */
/*               example for the post-install-      */
/*               successful exit                    */
/*                                                  */
/* Syntax      : Call from the INSTALL.DAT via:     */
/*    START_REXX_BY_SUCCESSFUL=DELSAVES dest_path   */
/*                                                  */
/* Changes     :                                    */
/*                                                  */
/* Made use of GREED.  21 May 1996 / 21:22:36   JRK */
/****************************************************/
Parse Arg destPath
/*-------------(Write lines into file)--------------*/
myLog = destPath'\install.log'
rc = LineOut( myLog, 'Destination Directory:' destPath)

/*==============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

/*==========(Initialize RexxUtil support)===========*/
If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

/*--------------(Save directory)---------------*/
directory = destPath||'\SAVEPREV'

/* Call HandleFNC(directory, destPath, myLog) */

/*-----------(Find file/Set attributes)-------------*/
rc = SysFileTree( directory||'\*.*', fileList, 'FO' )
Do i = 1 To fileList.0
  /*------------------(Delete file)-------------------*/
  delRC = SysFileDelete( fileList.i )
End /* If ... */

/*-------------(Remove directory)--------------*/
rc = SysRmDir( directory )

/*================(End this program)================*/
Return

CLEARUP:
Return

/*================(Search FNC files)================*/
CheckFNC: Procedure
Arg destPath, filename

/*----------------(Split path name)-----------------*/
name = FileSpec( "Name", filename )  /* FILENAME.EXT */
newFNC = destPath||'\'||name
rc = SysFileTree( newFNC, List )
If List.0 > 0 Then Return newFNC
Else rc = LineOut( myLog, 'No FNC' name 'found' )

Return ''


/*================(Copy FNC files)=================*/
CopyFNC: Procedure
Arg oldFNC, newFNC

appl.0 = 0
key.0 = 0
result = SysIni( oldFNC, 'ALL:', 'appl' )
Do i = 1 To appl.0
  result = SysIni( oldFNC, appl.i, 'ALL:', 'key' )
  Do j = 1 To key.0
    value = SysIni( oldFNC, appl.i, key.j )
    /*---------------(Set key value data)---------------*/
    result = SysIni( newFNC, appl.i, key.j, value )
    If result = 'ERROR:' Then Do
      Queue 'APPL' i appl.i 'KEY' j key.j result
      Parse Var newFNC name '.' ext
      renFNC = name || '.' || 'FUN'
      "ren" newFNC renFNC ">>NUL"
      Return result
    End
  End
End

Return 'OK:'


/*===============(Handle FNC files)=================*/
HandleFNC: Procedure
Arg directory, destPath, myLog

/*-----------(Find previous *.FNC files)------------*/
appl.0 = 0
rc = SysFileTree( directory||'\*.FNC', fileList, 'FO' )
rc = LineOut( myLog, 'FNC files:' fileList.0 )

Do i = 1 To fileList.0
  newFNC = CheckFNC(destPath, fileList.i)
  rc = LineOut( myLog, 'From:' fileList.i 'to:' newFNC)
  If newFNC > '' Then Do
    Call CopyFNC fileList.i, newFNC
    If result = 'ERROR:' Then Do
      Pull erRecord
      rc = LineOut( myLog, erRecord )
    End
  End
End
status = Stream( myLog, 'C', 'Close' )

Return