"Initialization code"
 !



!Collection methods !
  
collect: aBlock
        "For each element in the receiver, evaluate aBlock with
         that element as the argument.  Answer a new collection
         containing the results as its elements from the aBlock
         evaluations."
		"@25.02.94 ch: bug fix: use OrderedCollection instead of 
		self species as the class of the new collection."
    | answer |
    answer := OrderedCollection new.
    self do: [ :element |
        answer add: (aBlock value: element)].
    ^answer! !



!Collection class methods ! !



!Directory methods !
   
existingFileNamed: fileName
ifAbsent: exceptionBlock
		"Answer the file named <fileName> contained within the receiver. If the name does not define an existing file within the receiver, answer the result of evaluating the <exceptionBlock>."
		"@04.05.95 ch: bug fix: didn't allow absolute pathNames" 
	| file |
    file := (self asFileSystemPath , fileName) asFile.
    file exists ifFalse: [^exceptionBlock value].
    ^file
! !



!Directory class methods ! !



!SubPane methods !
 
helpRequest
		"Private - Notify a help event to any window
        which can handle it following the window chain."
		"@30.04.95 ch: bug fix: didn't set the helpContext" 
	self mainWindow helpContext isNil ifTrue: [
        self mainWindow helpContext: ( Association key: self name value: self ) ].
    ( self handlesEvent: #help )
        ifTrue: [ ^self event: #help ].
    ( self hasActionForEvent: #help )
        ifTrue: [ ^self triggerEvent: #help ].
    ^parent helpRequest
! !



!SubPane class methods ! !



!ListBox methods !
 
button1Down: aPoint
		"Private - Save this event for processing in #notifySelected: and #button1Up:."
	self propertyAt: #saveButton1Down put: true.
	^super button1Down: aPoint!
 
button1Up: aPoint
        "Private - the left mouse button was released, trigger
        selected notification."
		"24.3.95 ch : bug fix."
	(self propertyAt: #saveButton1Down) notNil ifTrue: [
	    self isOkToChange ifTrue: [
			self triggerEvent: #clicked: with: self selectedItem]
		].
	^super button1Up: aPoint!
  
clearSelection
        "Make no list items selected"
		"@23.03.95 ch: bug fix."
    value := nil.
    self isHandleOk ifFalse: [ ^self ].
	self propertyAt: #settingSelection put: true.
    PMWindowLibrary
        sendMsg: handle
        msg: LmSelectitem
        mp1: LitNone
        mp2: 0.
	self propertyAt: #settingSelection put: nil.!
   
contents: aCollection
        "Set the receiver's contents to aCollection."
		"26.3.95 ch: bug fix: value must be set to nil."
    list := aCollection.
	value := nil.
    self isHandleOk ifTrue: [
        self disableRedraw;
            deleteAllFromControl;
            insertArray: list;
            updateHorizontalExtent;
            enableRedraw ].
     ^list!

forceSelectionOntoDisplay
		"Private - Scroll the receiver to ensure that the selected item is visible."
		"@28.03.95 ch: Creation"
	| topIndex lines |
	value isNil ifTrue: [^self].
	topIndex := self getTopIndex.
	lines := self drawingRectangle height // self itemHeight.
	(value between: topIndex and: topIndex + lines) ifTrue: [^self].
	self setTopIndex: (value - (lines // 2) max: 1)


!
   
notifySelected: aParameter
		"Private - the host signaled that an item was selected."
		"23.3.95 ch: bug fixes."
    | oldSelection |
    self selectMessageQueued ifTrue: [ ^nil ].   "do nothing if another select message is queued"
    oldSelection := value.
    self isOkToChange
        ifTrue: [
			self getSelection.
            self event: #select.
			self propertyAt: #saveButton1Down put: nil. "To prevent triggering the #clicked: message in #button1Up."
			self triggerEvent: #clicked: with: self selectedItem.
			oldSelection ~= value ifTrue: [self triggerChanged].
			]
        ifFalse: [
			self propertyAt: #saveButton1Down put: nil. "To prevent triggering the #clicked: message in #button1Up."
			self selection: oldSelection ].    "restore old selection"
!
 
selection
        "Answer the selection as a one based index."
		"24.3.95 bug fix: always answer the stored value, 
		otherwise two consecutive calls to #selection could yield to 
		different values. The stored value is updated in the #notifySelected: method."
    "self isHandleOk ifTrue: [ ^self getSelection ]."
    ^value!

selectMessageQueued
        "Private - answer whether a select message event
        is coming in the input event queue."
    CurrentEvents
        detect: [ :msg |
            msg selector = #asyncControlEvent:with:
            and: [ msg receiver == self
            and: [ msg arguments size = 2
            and: [ ( msg arguments at: 1 ) = LnSelect ] ] ] ]
        ifNone: [ ^false ].
    ^true!
   
setInitialContents
        "Private - set the receiver's contents and selection."
		"@13.4.95 bug fix: preserve the value variable."
	| oldValue |
	oldValue := value.
    self contents: list.
	value := oldValue.
    value notNil ifTrue: [ self setSelection ]!
  
setSelection
        "Private - set the selection in the listbox control
        to correspond to value.  Assumes 'handle = NullHandle'
        is false."
		"@24.3.95 ch: Bug fix: use the #settingSelection property."
    | index |
    index := ( value isNil or: [ value < 1 or: [ value > list size ] ] )
        ifTrue: [ self class listEnd ]
        ifFalse: [ value - 1 ].
	self propertyAt: #settingSelection put: true.
    PMWindowLibrary
        sendMsg: handle
        msg: self selectMessage
        mp1: index
        mp2: true asParameter.
	self propertyAt: #settingSelection put: nil.
	self forceSelectionOntoDisplay
!

stringForItem: item
        "Private - Answer a string for the given item (which may be
        either a string or some other object which is converted to
        a string using the current printSelector)."
    | printSelector printBlock |
    ^( printSelector := self printSelector ) isNil
        ifTrue: [
            item isString
                ifTrue: [ item ]
                ifFalse: [ item printString ] ]
        ifFalse: [ item perform: printSelector ]!
 
syncControlEvent: msg with: aParameter
		"Private - Ignore LnSelect events if the #settingSelection property is set."
		"@23.3.95 ch: bug fix: added this method."
	(msg = LnSelect and: [(self propertyAt: #settingSelection) notNil]) ifTrue: [^nil].
	^super syncControlEvent: msg with: aParameter! !



!ListBox class methods ! !



!DropDownList methods !
  
syncControlEvent: msg with: aParameter
		"Private - Ignore CbnLbselect events if the #settingSelection property is set."
		"24.3.95 ch: Bug fix: added this method."
	(msg = CbnLbselect and: [(self propertyAt: #settingSelection) notNil]) ifTrue: [^nil].
	^super syncControlEvent: msg with: aParameter! !



!DropDownList class methods ! !



!MultipleSelectListBox methods !
   
clearSelection
        "Unselect any selected items"
		"@12.5.95 ch: bug fix: call getSelection only if handle is ok."
		"@23.3.95 ch: bug fix: don't trigger the changed event 
		to be consistent with ListBox."
	| oldSelection |
	self isHandleOk ifTrue: [ value := self getSelection ].
	oldSelection := self selections.
	value := nil.
    self isHandleOk ifFalse: [ ^self ].
    oldSelection do: [ :item |
        self deselectIndexPrivate: item ].
    "self triggerChanged"!
 
deselectIndexPrivate: itemIndex
        "Private - deselect the item at itemIndex."
		"@23.3.95 ch: bug fix: use the #settingSelection property."
    | index |
    value isNil ifFalse: [ value remove: itemIndex ifAbsent: [ nil ] ].
    self isHandleOk ifFalse: [ ^self ].
    index := ( itemIndex isNil or: [ itemIndex < 1 or: [ itemIndex > list size ] ] )
        ifTrue: [ self class listEnd ]
        ifFalse: [ itemIndex - 1 ].
	self propertyAt: #settingSelection put: true.
    PMWindowLibrary
        sendMsg: handle
        msg: LmSelectitem
        mp1: index
        mp2: false asParameter.
	self propertyAt: #settingSelection put: nil
!
  
forceSelectionOntoDisplay
		"Private - Scroll the receiver to ensure that the selected item is visible."
		"@28.03.95 ch: Creation"
	| topIndex lines |
	(self isHandleOk not or: [value isNil or: [value isEmpty]]) ifTrue: [^self].
	topIndex := self getTopIndex.
	lines := self drawingRectangle height // self itemHeight.
	(value first between: topIndex and: topIndex + lines) ifTrue: [^self].
	self setTopIndex: (value first - (lines // 2) max: 1)


!
   
selectIndex: itemIndex
		"Select the item at itemIndex. Index starts at 1."
		"@23.04.95 ch: call #setSelection here not in #selectIndexPrivate:" 
		"23.3.95 ch: bug fix: don't trigger the changed event to be 
		compatible with ListBox."
	((self isIndexValid: itemIndex ) and: [( self valueIndices includes: itemIndex ) not ] ) ifTrue: [
		self 
			selectIndexPrivate: itemIndex;
			setSelection]!
   
selectIndexPrivate: itemIndex
        "Private - Select the item at itemIndex. Index starts at 1."
		"23.4.95 ch: bug fix don't call #setSelection to prevent 
		multiple sends of this message, which my slow down the
		system."
    | index |
    value isNil ifTrue: [ value := OrderedCollection new ].
    ( itemIndex notNil and: [ ( value includes: itemIndex ) not ] )
        ifTrue: [ value add: itemIndex ].
    self isHandleOk ifFalse: [ ^self ].
    "self setSelection"!
   
selection: anObj
        "If anObj is a collection then select items whose indices
         are in anObj.
         If anObj is nil then unselect all items.
         If anObj is Integer then select the item indexed by anObj.
         Otherwise, select anObj in the list."
	| index |
    ( anObj isCollection and: [ anObj isString not ] )
        ifTrue: [
            self disableRedraw.
            self clearSelection.
            anObj do: [ :o |
				o isInteger
					ifTrue: [index := o]
					ifFalse: [index := self indexOf: o].
				(self isIndexValid: index) ifTrue: [self selectIndexPrivate: index].
				].
			self setSelection.
            self enableRedraw ]
        ifFalse: [ super selection: anObj ]!
  
selections
		"Answer indices of the items selected."
		"@08.05.95 ch: Don't call #getSelection to prevent inconsistencies" 
		"self isHandleOk ifTrue: [ value := self getSelection ]."

	value isNil ifTrue: [ ^OrderedCollection new ].
    ^value!
 
setSelection
        "Private - set the selection in the listbox control
        to correspond to value.  Assumes 'handle = NullHandle'
        is false."
		"@23.3.95 ch : bug fix: use the #settingSelection property."
    value isNil ifTrue: [ ^self clearSelections ].
	self propertyAt: #settingSelection put: true.
    value do: [ :index |
        PMWindowLibrary
            sendMsg: handle
            msg: self selectMessage
            mp1: index - 1
            mp2: true asParameter ].
	self propertyAt: #settingSelection put: nil.
	self forceSelectionOntoDisplay.
!

valueIndices: aCollectionOfIntegers
		"Set the selection to the items at the index positions
        in aCollectionOfIntegers."
		"@23.04.95 ch: bug fix: call #setSelection here not in 
		#selectIndexPrivate:" 
	| validIndices |
    aCollectionOfIntegers size = 0
        ifTrue: [ ^self clearSelection ].
    validIndices := aCollectionOfIntegers
        select: [ :i | self isIndexValid: i ].
    validIndices isEmpty
        ifTrue: [ ^self clearSelection ].
    self clearSelections.
    validIndices do: [ :i | self selectIndexPrivate: i ].
	self setSelection! !



!MultipleSelectListBox class methods ! !
"Finalization code"
    !

 
Transcript cr; nextPutAll: 'Bug Fixes VSO 3.0 installed.'!
