typedef struct
{
   USHORT Record_Number;
   CHAR Account_Holder[41];
   CHAR Account_Name[41];
   CHAR Account_Number[41];
   double Account_Balance;
   double Account_Limit;
   double Interest_Rate;
   USHORT Account_Type;
   CHAR Type_Name[41];
   CHAR Contact[41];
   CHAR Phone[20];
   CHAR Comments[100];
   CHAR Active_From[11];
   CHAR Active_To[11];
   CHAR Expired[2];
   ULONG Entries;
   BOOL bSelected;
} ACCOUNT;


#define AccountRecord_Number        Account->Record_Number
#define AccountAccount_Holder       Account->Account_Holder
#define AccountAccount_Name         Account->Account_Name
#define AccountAccount_Number       Account->Account_Number
#define AccountAccount_Balance      Account->Account_Balance
#define AccountAccount_Limit        Account->Account_Limit
#define AccountAccount_Type         Account->Account_Type
#define AccountComments             Account->Comments
#define AccountActive_From          Account->Active_From
#define AccountActive_To            Account->Active_To
#define AccountExpired              Account->Expired

typedef struct
{
   ULONG Record_Number;
   USHORT Account_Ref;
   USHORT CrossRec; /* 0 = not a cross account, 1 = a cross account */
   USHORT CrossAcc; /* cross account record number */
   ULONG CrossNum;  /* this accounts record Number */
   CHAR CrossHolder[41];
   CHAR CrossName[41];
   char Acc_Date[11];
   USHORT Trans_Num;
   double Amount;
   double Balance;
   double CrossBalance;
   char Cleared[2];
   char Chk_Num[21];
   char Payee[61];
   char Memo[61];
   ULONG Category;
   double StmtBal;
   USHORT ChkImg;
} ACC_INFO;

#define AccInfoRecord_Number        Acc_Info->Record_Number
#define AccInfoAccount_Ref          Acc_Info->Account_Ref
#define AccInfoCrossRec             Acc_Info->CrossRec
#define AccInfoCrossAcc             Acc_Info->CrossAcc
#define AccInfoCrossNum             Acc_Info->CrossNum
#define AccInfoAcc_Date             Acc_Info->Acc_Date
#define AccInfoTrans_Num            Acc_Info->Trans_Num
#define AccInfoAmount               Acc_Info->Amount
#define AccInfoBalance              Acc_Info->Balance
#define AccInfoCrossBalance         Acc_Info->CrossBalance
#define AccInfoCleared              Acc_Info->Cleared
#define AccInfoChk_Num              Acc_Info->Chk_Num
#define AccInfoPayee                Acc_Info->Payee
#define AccInfoMemo                 Acc_Info->Memo
#define AccInfoCategory             Acc_Info->Category
#define AccInfoStmtBal              Acc_Info->StmtBal
#define AccInfoChkImg               Acc_Info->ChkImg


ACC_INFO Acc_Info_Temp;

typedef struct
{
   ULONG Info_Rec_Num;
   ULONG Record_Number;
   CHAR Info_Address[61];

} ACC_ADDRESS;

#define Acc_AddressInfo_Rec_Num     Acc_Address->Info_Rec_Num
#define Acc_AddressRecord_Number    Acc_Address->Record_Number
#define Acc_AddressInfo_Address     Acc_Address->Info_Address

typedef struct
{
   ULONG Record_Number;
   CHAR Description[41];
   USHORT Selected;
} ACCOUNT_TYPES;

#define Account_TypesRecord_Number        Account_Types->Record_Number
#define Account_TypesDescription          Account_Types->Description

typedef struct
{
   ULONG Account_Ref;
   CHAR File_Name[1024];
   CHAR Import_Timestamp[30];
   CHAR Import_Date[11];
   CHAR Import_Time[15];
} IMPORTFILE;

#define ImportFileAccount_Ref       ImportFile->Account_Ref
#define ImportFileFile_Name         ImportFile->File_Name
#define ImportFileImport_Timestamp  ImportFile->Import_Timestamp
#define ImportFileImport_Date       ImportFile->Import_Date
#define ImportFileImport_Time       ImportFile->Import_Time

typedef struct
{
   ULONG Record_Number;
   ULONG Account_Ref;
   ULONG Category;
   char Memo[61];
   double Amount;
   USHORT Memorized;
} SPLIT_INFO;

#define Split_InfoRecord_Number     Split_Info->Record_Number
#define Split_InfoAccount_Ref       Split_Info->Account_Ref
#define Split_InfoCategory          Split_Info->Category
#define Split_InfoMemo              Split_Info->Memo
#define Split_InfoAmout             Split_Info->Amount
#define Split_InfoMemorized         Split_Info->Memorized

typedef struct
{
   ULONG Account_Ref;
   char Form_Num[21];
} TAXFORMS;

#define TaxFormsAccount_Ref       TaxForms->Account_Ref
#define TaxFormsForm_Num      TaxForms->Form_Num

typedef struct
{
   long Record_Num;
   char Form_Num[21];
   short LineNum;
   char Descrip[31];
} TAXFORMDATA;

#define TaxFormDataRecord_Num    TaxFormData->Record_Num
#define TaxFormDataForm_Num      TaxFormData->Form_Num
#define TaxFormDataLineNum       TaxFormData->LineNum
#define TaxFormDataDescrip       TaxFormData->Descrip

typedef struct
{
   long FormData_Num;
   long AccInfo_Num;

} ACC_TAXINFO;

#define Acc_TaxInfoFormData_Num        Acc_TaxInfo->FormData_Num
#define Acc_TaxInfoAccInfo_Num         Acc_TaxInfo->AccInfo_Num

typedef struct
{
   ULONG Record_Number;
   ULONG Parent;
   CHAR Name[41];
   CHAR Descrip[41];
   ULONG Cat_Type;
   ULONG Budget;
   ULONG Tax_Schedule;
} CATEGORY;

#define CategoryRecord_Number       Category->Record_Number
#define CategoryParent              Category->Parent
#define CategoryName                Category->Name
#define CategoryDescrip             Category->Descrip
#define CategoryCat_Type            Category->Cat_Type
#define CategoryBudget              Category->Budget
#define CategoryTax_Schedule        Category->Tax_Schedule

typedef struct
{
   ULONG Record_Number;
   ULONG Category;
   CHAR Begin_Date[11];
   CHAR End_Date[11];
   SHORT Month;
   SHORT Year;
   double Amount;
} BUDGET;

#define BudgetRecord_Number         Budget->Record_Number
#define BudgetCategory              Budget->Category
#define BudgetBegin_Date            Budget->Begin_Date
#define BudgetEnd_Date              Budget->End_Date
#define BudgetMonth                 Budget->Month
#define BudgetYear                  Budget->Year
#define BudgetAmount                Budget->Amount

typedef struct
{
   ULONG Record_Number;
   USHORT Trans_Type;
   double Amount;
   USHORT Cleared;
   CHAR Payee[41];
   CHAR Memo[41];
   USHORT Address;
   ULONG Category;
   CHAR Amort1PayDate[11];
   USHORT AmortYears;
   USHORT AmortNumPaid;
   USHORT AmortNumPer;
   double AmortInterest;
   double AmortBal;
   double AmortOrgAmt;
} MEMORIZED;

#define MemorizedKC     1
#define MemorizedKD     2
#define MemorizedKE     3
#define MemorizedKI     4
#define MemorizedKP     5

#define  MemorizedRecord_Number              Memorized->Record_Number
#define  MemorizedTrans_Type                 Memorized->Trans_Type
#define  MemorizedAmount                  Memorized->Amount
#define  MemorizedCleared                 Memorized->Cleared
#define  MemorizedPayee                   Memorized->Payee
#define  MemorizedMemo                    Memorized->Memo
#define  MemorizedAddress                 Memorized->Address
#define  MemorizedCategory                Memorized->Category
#define  MemorizedAmort1PayDate           Memorized->Amort1PayDate
#define  MemorizedAmortYears              Memorized->AmortYears
#define  MemorizedAmortNumPaid            Memorized->AmortNumPaid
#define  MemorizedAmortNumPer             Memorized->AmortNumPer
#define  MemorizedAmortInterest           Memorized->AmortInterest
#define  MemorizedAmortBal                Memorized->AmortBal
#define  MemorizedAmortOrgAmt             Memorized->AmortOrgAmt

typedef struct
{
   ULONG Record_Number;
   char Name[41];
   char Descrip[41];
} CLASS;

#define  ClassRecord_Number              Class->Record_Number
#define ClassName                         Class->Name
#define ClassDescrip                      Class->Descrip


typedef struct
{
   ULONG Record_Number;
   ULONG Account_Ref;
   ULONG Car_Ref;
   CHAR Acc_Date[11];
   ULONG Fuel_Type;
   double Fuel_Amt;
   double Fuel_Price;
   double Cost;
   CHAR Cleared;
   ULONG Category;
   double Trip_ODO;
   double Odometer;
   CHAR Fill_UP;
} GAS_REC;

#define  Gas_RecRecord_Number              Gas_Rec->Record_Number
#define Gas_RecAccount_Ref                Gas_Rec->Account_Ref
#define Gas_RecCar_Ref                     Gas_Rec->Car_Ref
#define Gas_RecAcc_Date                   Gas_Rec->Acc_Date
#define Gas_RecFuel_Type                  Gas_Rec->Fuel_Type
#define Gas_RecFuel_Amt                   Gas_Rec->Fuel_Amt
#define Gas_RecFuel_Price                 Gas_Rec->Fuel_Price
#define Gas_RecCost                       Gas_Rec->Cost
#define Gas_RecCleared                    Gas_Rec->Cleared
#define Gas_RecCategory                   Gas_Rec->Category
#define Gas_RecTrip_ODO                   Gas_Rec->Trip_ODO
#define Gas_RecOdometer                   Gas_Rec->Odometer
#define Gas_RecFill_UP                    Gas_Rec->Fill_UP

typedef struct
{
   CHAR szDB[10];
   USHORT usVerMajor;
   USHORT usVerMinor;
} DB_VER;


LONG DBStart(void);
LONG DBConnectFinance(PSZ pszHost, PSZ pszErrorMsg);
LONG DBMakeFinance(PSZ pszDrive);
LONG DBDisconnect(void);
LONG DBCommit(void);
LONG DBRollback(void);
SHORT isDBConnected(void);

LONG DBNumAccounts(ULONG *ulCount);
LONG DBOpenAllAccountCursor(void);
LONG DBFetchAllAccountsCursor(ACCOUNT *Account);
LONG DBCloseAllAccountCursor(void);
LONG DBOpenAccountHolderCursor(void);
LONG DBFetchAccountHolderCursor(ACCOUNT *Account);
LONG DBCloseAccountHolderCursor(void);
LONG DBOpenAccountNameByHolderCursor(ACCOUNT *Account);
LONG DBFetchAccountNameByHolderCursor(ACCOUNT *Account);
LONG DBCloseAccountNameByHolderCursor(void);
LONG DBInsertAccount(ACCOUNT *Account);
LONG DBSelectAccount(ACCOUNT *Account);
LONG DBSelectAccountNumber(ACCOUNT *Account);
LONG DBSelectAccountHolder(ACCOUNT *Account);
LONG DBUpdateAccount(ACCOUNT *Account);
LONG DBSelectAccountFromNumber(ACCOUNT *Account);

LONG DBSelectAccount_Type(ACCOUNT_TYPES *Account_Types);
LONG DBNumAccount_Type(ULONG *ulCount);
LONG DBOpenAccount_TypesCursor(void);
LONG DBFetchAccount_TypesCursor(ACCOUNT_TYPES *Account_Types);
LONG DBCloseAccount_TypesCursor(void);
LONG DBSelectAccount_TypeByDescrip(ACCOUNT_TYPES *Account_Types);

LONG DBSelectAccountRecNum(ACCOUNT *Account);
LONG DBInsertAccount(ACCOUNT *Account);
LONG DBInsertAccountInfo(ACC_INFO *Acc_Info, BOOL bUpdate, PSZ pszError);
LONG DBUpdateAccountInfo(ACC_INFO *Acc_Info1, ACC_INFO *Acc_Info2, PSZ pszChkImg);
LONG DBUpdateAccountInfoCross(ACC_INFO *Acc_Info);
LONG DBSelectAccount_InfoCount(ACC_INFO *Acc_Info);
LONG DBSelectAccount_Info(ACC_INFO *Acc_Info);
LONG DBOpenAccount_InfoCursor(ACC_INFO *Acc_Info);
LONG DBFetchAccount_InfoCursor(ACC_INFO *Acc_Info);
LONG DBCloseAccount_InfoCursor(void);
LONG DBDeleteAccountInfo(ACC_INFO *Acc_Info);
LONG DBOpenCrossAccCursor(ACC_INFO *Acc_Info);
LONG DBFetchCrossAccCursor(ACC_INFO *Acc_Info);
LONG DBCloseCrossAccCursor(void);
LONG DBInsertAcc_Address(ACC_ADDRESS *Acc_Address);
LONG DBInsertImportFile(IMPORTFILE *ImportFile);
LONG DBSelectImportFile(IMPORTFILE *ImportFile);
LONG DBInsertChkImg(PSZ pszFileName, ULONG ulLen, ULONG Account_Ref);
LONG DBGetChkImg(ULONG Account_Ref, PSZ pszFilename);
LONG DBGetChkCount(ULONG Account_Ref, USHORT *usCount);
LONG DBDeleteChkImage(ULONG Account_Ref);
LONG DBInsertSplitInfo(SPLIT_INFO *Split_Info);
LONG DBInsertTaxForm(TAXFORMS *TaxForms);
LONG DBOpenTaxFormsCursor(TAXFORMS *TaxForms);
LONG DBFetchTaxFormsCursor(TAXFORMS *TaxForms);
LONG DBCloseTaxFormsCursor(void);
LONG DBTaxFormDataCount(TAXFORMDATA *TaxFormData);
LONG DBOpenTaxFormDataCursor(TAXFORMDATA *TaxFormData);
LONG DBFetchTaxFormDataCursor(TAXFORMDATA *TaxFormData);
LONG DBCloseTaxFormDataCursor(void);
LONG DBInsertAccTaxInfo(ACC_TAXINFO *Acc_TaxInfo);
LONG DBSelectCategoryName(CATEGORY *Category);
LONG DBSelectCategory(CATEGORY *Category);
LONG DBSelectCategoryCount(SHORT *sRecordNum);
LONG DBMakeCategoryName(CATEGORY *Category, PSZ pszMyName);
LONG DBInsertCategory(CATEGORY *Category);
LONG DBSelectNumCategory(CATEGORY *Category, ULONG *ulTemp);
LONG DBOpenCategoryCursor(CATEGORY *Category);
LONG DBFetchCategoryCursor(CATEGORY *Category);
LONG DBCloseCategoryCursor(void);
LONG DBChangeCategory(CATEGORY *Category);
LONG DBDeleteCategory(CATEGORY *Category);
LONG DBInsertClass(CLASS *Class);
LONG DBSelectClassName(CLASS *Class);
LONG DBSelectBudget(BUDGET *Budget);
LONG DBInsertBudget(BUDGET *Budget);
LONG DBInsertMemorized(MEMORIZED *Memorized);
LONG DBSelectMemorized(MEMORIZED *Memorized);
LONG DBOpenBudgetValuesCursor(BUDGET *Budget);
LONG DBFetchBudgetValuesCursor(BUDGET *Budget);
LONG DBCloseBudgetValuesCursor(void);
LONG DBInsertGas_Rec(GAS_REC *Gas_Rec);
LONG DBBudgets(PSZ szBegin, PSZ szEnd);
LONG DBFetchBudgetDataCursor(PSZ szName, SHORT *sCat, double *dAmount, SHORT *sParent);
LONG DBCloseBudgetDataCursor(void);
LONG DBCategoryName(SHORT sCategory, PSZ pszName, SHORT *psParent);
LONG DBBudgetMonthYearAmount(SHORT sCat, SHORT sMonth, SHORT sYear, double *dAmount);
LONG DBBudgetMonthAmount(SHORT sCat, SHORT sMonth, double *dAmount);
LONG DBCategoryAllData(void);
LONG DBCategoryAllDataCursor(CATEGORY *Category);
LONG DBCloseCategoryAllDataCursor(void);
LONG DBBudgetAllYearOpen(BUDGET *Budget);
LONG DBBudgetAllYearCursor(BUDGET *Budget);
LONG DBBudgetAllYearClose(void);
LONG DBBudgetUpdate(BUDGET *Budget);





