#pragma strings( readonly )

/*+--------------------------------------------------------------------------+*/
/*| System and library header files.                                         |*/
/*+--------------------------------------------------------------------------+*/

#define INCL_NOCOMMON
#define INCL_DOSPROCESS
#define INCL_DOSSEMAPHORES
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_DOSMEMMGR
#define INCL_WINWINDOWMGR
#define INCL_WINMESSAGEMGR
#define INCL_WINFRAMEMGR
#define INCL_WINDIALOGS
#define INCL_WININPUT
#define INCL_WINSTDFILE                /* Window Standard File         */
#define INCL_WINSTDFONT
#define INCL_WINSWITCHLIST
#define INCL_WINPROGRAMLIST
#define INCL_GPICONTROL
#define INCL_GPIPRIMITIVES
#define  INCL_PM
#define INCL_DOS
#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

/* #include <ftpapi.h>  */
#include <netinet\in.h>
#include <sys\socket.h>
#include <netdb.h>
#include <sys/time.h>
#ifndef TCPV40HDRS
#include <unistd.h>
#endif

/*+--------------------------------------------------------------------------+*/
/*| Application header files.                                                |*/
/*+--------------------------------------------------------------------------+*/

#include "finSql.h"


int main(int argc, char *argv[] )
{
   CHAR szHost[100];
   CHAR szErrorMsg[256];
   ACCOUNT Account;

   if (DBConnectFinance(szHost, szErrorMsg) == 0)
   {
      ULONG ulCount = 0;

      if (DBNumAccounts(&ulCount) == 0)
      {

         if (ulCount > 0)
         {

            if (DBOpenAllAccountCursor() == 0)
            {

               while (DBFetchAllAccountsCursor(&Account) != 100)
               {
                  ACC_INFO Acc_Info;

                  printf("%s %s : %4.2f\r\n", Account.Account_Holder, Account.Account_Name, Account.Account_Balance);

                  Acc_Info.Account_Ref = Account.Record_Number;
                  DBSelectAccount_InfoCount(&Acc_Info);

                  if (Acc_Info.Record_Number > 0)
                  {

                     Acc_Info.Account_Ref = Account.Record_Number;
                     if (DBOpenAccount_InfoCursor(&Acc_Info) == 0)
                     {

                        while (DBFetchAccount_InfoCursor(&Acc_Info) == 0)
                        {
                           printf("%s : %4.2f  %4.2f\r\n", Acc_Info.Payee, Acc_Info.Amount, Acc_Info.Balance);

                        }



                        DBCloseAccount_InfoCursor();
                     }

                  }

               }

               DBCloseAllAccountCursor();
            }
         }
      }

      DBDisconnect();

   }

   return(0);

}

int TrimTrailing(PSZ pszData)
{
   SHORT x;

   x = strlen(pszData);
   if (x > 0)
   {
      x--;

      while ((pszData[x] == ' ') && (x > 0))
         x--;

   }
   if (x > -1)
   {
      x++;
      pszData[x] = 0x00;
   }

   return(0);
}

