/******************************************************************
 * COM.CMD
 *
 * This program calls the various REXX external functions provided in the FILEREXX DLL.
 *
 * Demonstrates using FileOpen(), FileRead(), FileWrite(), and FileDevIOCtl() upon a
 * COM driver that has a modem attached to it. In other words, the FileDevIOCtl()
 * Catagory is for the Async (RS232-C) Control; Catagory 1.
 *******************************************************************/

/* Change this to whatever COM port your modem is attached to */
port = 'COM2'

/* Change this to desired bit rate */
bitrate = '9600'

/* Change this to desired # of data bits (ie, 5, 6, 7, or 8) */
databits = '8'

/* Change this to desired parity (ie, 0=none, 1=odd, 2=even, 3=mark, 4=space) */
parity = '0'

/* Change this to desired # of stop bits (ie, 0=1 bit, 1=1.5 bits, 2=2 bits) */
stopbits = '0'




/* ============================ Init stuff =============================== */
/* The FileLoadFuncs loads all the rest of the REXX functions in the FILEREXX DLL. */
/* So, we don't have to make calls to RxFuncAdd to add each one of those functions. Of */
/* course, in order to call FileLoadFuncs, we have to add that one. */
CALL RxFuncAdd 'FileLoadFuncs', 'FILEREXX', 'FileLoadFuncs'
CALL FileLoadFuncs




/* ============================== FileOpen =============================== */
/** Open the device driver.
 **/
handle = FileOpen(port, 'rws')
IF handle <> 0 THEN DO




    /* =========================== FileDevIOCtl =========================== */
    /** Perform a device specific function.
     **/

    /* ============ Set Bit Rate =========== */
    REQ.0 = 2
    REQ.1 = '2' bitrate
    err = FileDevIOCtl(handle, 1, 65, 'REQ')
    IF err <> 0 THEN SAY "ERROR setting Bit Rate:" err

    /* ===== Set Line Characteristics (ie, parity, data and stop bits) ===== */
    REQ.0 = 3
    REQ.1 = '1' databits parity stopbits
    /* Note that if we wanted to specify each of the above separately, we
       could do:
    REQ.1 = '1' databits
    REQ.2 = '1' parity
    REQ.3 = '1' stopbits
    */
    err = FileDevIOCtl(handle, 1, 66, 'REQ')
    IF err <> 0 THEN SAY "ERROR setting Line Characteristics:" err

    SAY '/* ========== Query Extended Bit Rate =========== */'
    REQ.0 = 15
    REQ.1 = '4.1' /* current bit rate */
    REQ.2 = '1.1' /* fraction of current bit rate */
    REQ.3 = '4.1' /* minimum rate supported */
    REQ.4 = '1.1' /* fraction of minimum rate supported */
    REQ.5 = '4.1' /* maximum rate supported */
    REQ.6 = '1.1' /* fraction of maximum rate supported */
    err = FileDevIOCtl(handle, 1, 99, ,'REQ', 'd')
    IF err = 0 THEN DO
	SAY 'Bit Rate =' REQ.1
	SAY 'Fractional rate =' REQ.2

	SAY 'Minimum Supported Rate =' REQ.3
	SAY 'Minimum Supported Fractional rate =' REQ.4

	SAY 'Maximum Supported Rate =' REQ.5
	SAY 'Maximum Supported Fractional rate =' REQ.6
    END
    ELSE DO
	SAY '/* =============== Query Bit Rate =============== */'
	REQ.0 = 2
	REQ.1 = '2.1'
	err = FileDevIOCtl(handle, 1, 97, , 'REQ', 'd')
	IF err <> 0 THEN SAY "ERROR querying Bit Rate:" err
	ELSE SAY 'Bit Rate =' REQ.1
    END

    SAY '/* ========= Query Line Characteristics ========= */'
    REQ.0 = 4
    REQ.1 = '1.1' /* databits */
    REQ.2 = '1.1' /* parity */
    REQ.3 = '1.1' /* stopbits */
    REQ.4 = '1.1' /* a 1 if currently transmitting a break, a 0 if not */
    err = FileDevIOCtl(handle, 1, 98, ,'REQ', 'd')
    IF err <> 0 THEN SAY "ERROR querying Line Characteristics:" err
    ELSE DO
	SAY 'Data Bits =' REQ.1

	IF REQ.2 = 0 THEN parity = 'None'
	IF REQ.2 = 1 THEN parity = 'Odd'
	IF REQ.2 = 2 THEN parity = 'Even'
	IF REQ.2 = 3 THEN parity = 'Mark (always 1)'
	IF REQ.2 = 4 THEN parity = 'Space (always 0)'
	SAY 'Parity =' parity

	IF REQ.3 = 0 THEN stopbits = '1'
	IF REQ.3 = 1 THEN stopbits = '1.5'
	IF REQ.3 = 2 THEN stopbits = '2'
	SAY 'Stop Bits =' stopbits

	IF REQ.4 = 1 THEN SAY 'Transmitting break'
    END

    SAY '/* ============== Query COM Status ============== */'
    REQ.0 = 1
    REQ.1 = 'B1.1' /* Return it in BINARY (each bit is a 1 or 0) */
    err = FileDevIOCtl(handle, 1, 100, , 'REQ', 'd')
    IF err <> 0 THEN SAY "ERROR querying COM Status:" err
    ELSE DO
	/* Each bit of the returned 8-bit char is for a different aspect of
	   the COM status. So, we need to test each bit */
	IF FileBit(REQ.1, 0) THEN SAY 'Transmit status (Tx) waiting for CTS to be turned on.'
	IF FileBit(REQ.1, 1) THEN SAY 'Tx waiting for DSR to be turned on.'
	IF FileBit(REQ.1, 2) THEN SAY 'Tx waiting for DCD to be turned on.'
	IF FileBit(REQ.1, 3) THEN SAY 'Tx waiting because XOFF received.'
	IF FileBit(REQ.1, 4) THEN SAY 'Tx waiting because XOFF transmitted.'
	IF FileBit(REQ.1, 5) THEN SAY 'Tx waiting because break being transmitted.'
	IF FileBit(REQ.1, 6) THEN SAY 'Character waiting to transmit immediately.'
	IF FileBit(REQ.1, 7) THEN SAY 'Receive waiting for DSR to be turned on.'
    END

    SAY '/* ========= Query Transmit Data Status ========= */'
    REQ.0 = 1
    REQ.1 = 'B1.1'
    err = FileDevIOCtl(handle, 1, 101, , 'REQ', 'd')
    IF err <> 0 THEN SAY "ERROR querying Transmit Data Status:" err
    ELSE DO
	/* Each bit of the returned 8-bit char is for a different aspect of
	   the Transmit Status. So, we need to test each bit */
	IF FileBit(REQ.1, 0) THEN SAY 'Write Request Packets in progress or queued.'
	IF FileBit(REQ.1, 1) THEN SAY 'Data in driver transmit queue.'
	IF FileBit(REQ.1, 2) THEN SAY 'Hardware is currently transmitting data.'
	IF FileBit(REQ.1, 3) THEN SAY 'Character waiting to be transmitted immediately.'
	IF FileBit(REQ.1, 4) THEN SAY 'Waiting to automatically transmit an XON.'
	IF FileBit(REQ.1, 5) THEN SAY 'Waiting to automatically transmit an XOFF.'
    END

    SAY '/* ========= Query Modem Output Signals ========= */'
    REQ.0 = 1
    REQ.1 = 'B1.1'
    err = FileDevIOCtl(handle, 1, 102, , 'REQ', 'd')
    IF err <> 0 THEN SAY "ERROR querying Modem Output Signals:" err
    ELSE DO
	/* Each bit of the returned 8-bit char is for a different signal. So,
	   we need to check each bit */
	CALL CHAROUT ,'Data Terminal Ready (DTR) is '
	IF FileBit(REQ.1, 0) THEN SAY 'on.'
	ELSE SAY 'off.'

	CALL CHAROUT ,'Request To Send (RTS) is '
	IF FileBit(REQ.1, 1) THEN SAY 'on.'
	ELSE SAY 'off.'
    END

    SAY '/* ========= Query Modem Input Signals ========== */'
    REQ.0 = 1
    REQ.1 = 'B1.1'
    err = FileDevIOCtl(handle, 1, 103, , 'REQ', 'd')
    IF err <> 0 THEN SAY "ERROR querying Modem Input Signals:" err
    ELSE DO
	/* Each bit of the returned 8-bit char is for a different signal. So,
	   we need to check each bit */
	CALL CHAROUT ,'Clear To Send (CTS) is '
	IF FileBit(REQ.1, 4) THEN SAY 'on.'
	ELSE SAY 'off.'

	CALL CHAROUT ,'Data Set Ready (DSR) is ' /* 6th bit */
	IF FileBit(REQ.1, 5) THEN SAY 'on.'
	ELSE SAY 'off.'

	CALL CHAROUT ,'Ring Indicator (RI) is '
	IF FileBit(REQ.1, 6) THEN SAY 'on.'
	ELSE SAY 'off.'

	CALL CHAROUT ,'Data Carrier Detect (DCD) is '
	IF FileBit(REQ.1, 7) THEN SAY 'on.'
	ELSE SAY 'off.'
    END

    SAY '/* ============ Query Receive Queue ============= */'
    REQ.0 = 4
    REQ.1 = '2.1'  /* Number of chars currently in receive queue */
    REQ.2 = '2.1'  /* Size of receive queue */
    err = FileDevIOCtl(handle, 1, 104, , 'REQ', 'd')
    IF err <> 0 THEN SAY "ERROR querying Receive Queue:" err
    ELSE DO
	SAY 'Number of chars currently in receive queue:' REQ.1
	SAY 'Size of receive queue:' REQ.2
    END

    SAY '/* ============ Query Transmit Queue ============ */'
    REQ.0 = 4
    REQ.1 = '2.1'  /* Number of chars currently in transmit queue */
    REQ.2 = '2.1'  /* Size of transmit queue */
    err = FileDevIOCtl(handle, 1, 105, , 'REQ', 'd')
    IF err <> 0 THEN SAY "ERROR querying Transmit Queue:" err
    ELSE DO
	SAY 'Number of chars currently in transmit queue:' REQ.1
	SAY 'Size of transmit queue:' REQ.2
    END

    SAY '/* ============= Query COM Error ============= */'
    REQ.0 = 2
    REQ.1 = 'B2.1'
    err = FileDevIOCtl(handle, 1, 109, , 'REQ', 'd')
    IF err <> 0 THEN SAY "ERROR querying COM Error:" err
    ELSE DO
	/* Each bit of the returned 16-bit ushort is for a different error. So,
	   we need to check each bit */
	IF FileBit(REQ.1, 0) THEN SAY 'Receive queue overrun.'
	IF FileBit(REQ.1, 1) THEN SAY 'Receive hardware overrun.'
	IF FileBit(REQ.1, 2) THEN SAY 'Parity error.'
	IF FileBit(REQ.1, 3) THEN SAY 'Framing error.'
    END

    SAY '/* ============= Query COM Event ============= */'
    REQ.0 = 2
    REQ.1 = 'B2.1'
    err = FileDevIOCtl(handle, 1, 114, , 'REQ', 'd')
    IF err <> 0 THEN SAY "ERROR querying COM Event:" err
    ELSE DO
	/* Each bit of the returned 16-bit ushort is for a different event. So,
	   we need to check each bit */
	IF FileBit(REQ.1, 0) THEN SAY 'Character read from receive hardware and placed into queue.'
	IF FileBit(REQ.1, 1) THEN SAY 'Receive hardware timed out.'
	IF FileBit(REQ.1, 2) THEN SAY 'Current write request (transmit) complete.'
	IF FileBit(REQ.1, 3) THEN SAY 'Clear To Send (CTS) changed state.'
	IF FileBit(REQ.1, 4) THEN SAY 'Data Set Ready (DSR) changed state.'
	IF FileBit(REQ.1, 5) THEN SAY 'Data Carrier Detect (DCD) changed state.'
	IF FileBit(REQ.1, 6) THEN SAY 'Break is detected.'
	IF FileBit(REQ.1, 7) THEN SAY 'Framing, Parity, or receive hardware/queue overrun error.'
	IF FileBit(REQ.1, 8) THEN SAY 'Trailing edge of Ring Indicator detected.'
    END

    SAY '/* ========== Query DCB Parameters =========== */'
    REQ.0 = 11
    REQ.1 = '2.1'    /* Write Timeout (in tenths of a second, where 0 = .01 secs) */
    REQ.2 = '2.1'    /* Read Timeout */
    REQ.3 = 'B1.1' /* Flags1 */
    REQ.4 = 'B1.1' /* Flags1 */
    REQ.5 = 'B1.1' /* Flags1 */
    REQ.6 = '1.1'   /* Error replacement char */
    REQ.7 = '1.1'   /* Break replacement char */
    REQ.8 = '1.1'   /* XON char */
    REQ.9 = '1.1'   /* XOFF char */
    err = FileDevIOCtl(handle, 1, 115, , 'REQ', 'd')
    IF err <> 0 THEN SAY "ERROR querying DCB Parameters:" err
    ELSE DO
	SAY 'Write Timeout =' REQ.1
	SAY 'Read Timeout =' REQ.2

	/* Each bit of Flags1 is for a different aspect. So, we need to check each bit */
	CALL CHAROUT ,'DTR Control Mode = '
	err = FileBit(REQ.3, 0 2, 'XTRT')  /* Extract the first 2 bits */
	IF err = '00' THEN SAY 'disabled'
	IF err = '01' THEN SAY 'enabled'
	IF err = '10' THEN SAY 'input handshaking'
	IF err = '11' THEN SAY  /* Invalid. You should never get this */

	IF FileBit(REQ.3, 3) THEN SAY 'Output handshaking using CTS.'
	IF FileBit(REQ.3, 4) THEN SAY 'Output handshaking using DSR.'
	IF FileBit(REQ.3, 5) THEN SAY 'Output handshaking using DCD.'
	IF FileBit(REQ.3, 6) THEN SAY 'Input sensitivity using DSR.'

	/* Each bit of Flags2 is for a different aspect. So, we need to check each bit */
	IF FileBit(REQ.4, 0) THEN SAY 'Automatic Flow Control (XON/XOFF) on transmit.'
	IF FileBit(REQ.4, 1) THEN SAY 'Automatic Flow Control (XON/XOFF) on receive.'
	IF FileBit(REQ.4, 2) THEN SAY 'Error Replacement Char is enabled.'
	IF FileBit(REQ.4, 3) THEN SAY 'Null (zero byte) stripping is enabled.'
	IF FileBit(REQ.4, 4) THEN SAY 'Break Replacement Char is enabled.'

	CALL CHAROUT ,'Receive Duplex = '
	IF FileBit(REQ.4, 5) THEN SAY 'full.'
	ELSE SAY 'normal.'

	CALL CHAROUT ,'RTS Control Mode = '
	err = FileBit(REQ.4, 6 2, 'XTRT')
	IF err = '00' THEN SAY 'disabled'
	IF err = '01' THEN SAY 'enabled'
	IF err = '10' THEN SAY 'input handshaking'
	IF err = '11' THEN SAY 'toggle on transmit'

	/* Each bit of Flags3 is for a different aspect. So, we need to check each bit */
	IF FileBit(REQ.5, 0) THEN SAY 'Infinite timeout for writes.'

	CALL CHAROUT ,'Read timeout mode = '
	err = FileBit(REQ.5, 1 2, 'XTRT')
	IF err = '00' THEN SAY /* Invalid */
	IF err = '01' THEN SAY 'normal timeout'
	IF err = '10' THEN SAY 'wait for something'
	IF err = '11' THEN SAY 'no waiting'

	CALL CHAROUT ,'Extended hardware buffering = '
	err = FileBit(REQ.5, 3 2, 'XTRT')
	IF err = '00' THEN SAY 'not supported'
	IF err = '01' THEN SAY 'disabled'
	IF err = '10' THEN SAY 'enabled'
	IF err = '11' THEN SAY 'automatic protocol override'

	CALL CHAROUT ,'Receive trigger level = '
	err = FileBit(REQ.5, 5 2, 'XTRT')
	IF err = '00' THEN SAY '1 char'
	IF err = '01' THEN SAY '4 chars'
	IF err = '10' THEN SAY '8 chars'
	IF err = '11' THEN SAY '14 chars'

	CALL CHAROUT ,'Transmit buffer load count = '
	IF FileBit(REQ.5, 7) THEN SAY '16 chars'
	ELSE SAY '1 char'

	/* Error replacement char */
	SAY 'Error replacement char (as an ascii number) =' REQ.6

	/* Break replacement char */
	SAY 'Break replacement char (as an ascii number) =' REQ.7

	/* XON char */
	SAY 'XON char (as an ascii number) =' REQ.8

	/* XOFF char */
	SAY 'XOFF char (as an ascii number) =' REQ.9
    END


    SAY '/* ====== Query Enhanced Mode Parameters ===== */'
    REQ.0 = 5
    REQ.1 = 'B1.1' /* Flags */
    REQ.2 = '4.1'   /* Reserved */
    err = FileDevIOCtl(handle, 1, 116, , 'REQ', 'd')
    IF err <> 0 THEN SAY "ERROR querying Enhanced Mode Parameters:" err
    ELSE DO
	/* Each bit of Flags is for a different aspect. So, we need to check each bit */

	CALL CHAROUT ,'Enhanced Mode is '

	/* Is Enhanced Mode supported by the driver? */
	IF FileBit(REQ.1, 0) THEN DO
	    SAY 'supported'

	    /* Is Enhanced Mode enabled? */
	    IF FileBit(REQ.1, 1) THEN DO
		 SAY ', and enabled.'

		 /* DMA Receive Operation */
		 CALL CHAROUT ,'DMA Receive Operation = '
		 err = FileBit(REQ.1, 2 2, 'XTRT')
		 IF err = '00' THEN SAY 'disabled'
		 IF err = '01' THEN SAY 'enabled'
		 IF err = '10' THEN SAY 'dedicated DMA channel'
		 IF err = '11' THEN SAY  /* Invalid. You should never get this */

		 /* DMA Transmit Operation */
		 CALL CHAROUT ,'DMA Transmit Operation = '
		 err = FileBit(REQ.1, 4 2, 'XTRT')
		 IF err = '00' THEN SAY 'disabled'
		 IF err = '01' THEN SAY 'enabled'
		 IF err = '10' THEN SAY 'dedicated DMA channel'
		 IF err = '11' THEN SAY  /* Invalid. You should never get this */

		 /* Receive or Transmit DMA Operation in progress? */
		 IF FileBit(REQ.1, 6) THEN SAY 'Receive currently doing DMA Operation.'
		 IF FileBit(REQ.1, 7) THEN SAY 'Transmit currently doing DMA Operation.'
	    END

	    /* Enhanced Mode not enabled */
	    ELSE SAY ', but not enabled.'
	END

	/* Enhanced Mode not supported */
	ELSE SAY 'not supported.'
    END



    SAY "/* ====== Clear out driver's input queue ===== */"
    /* Clear out any queued input waiting to be read before we do the
       write and read operations below. We don't want FileGets to have
       to wade through anything except what the modem sends AFTER
       we do the FilePuts */
    REQ.0 = 1
    REQ.1 = '1.1.0'   /* Command. Must be 0 */
    DATA.0 = 1
    DATA.1 = '1.1.0'  /* Reserved */
    err = FileDevIOCtl(handle, 11, 1, 'REQ', 'DATA')
    IF err <> 0 THEN SAY "ERROR flushing input queue:" err



    /* ============================ FilePuts ============================= */
    /* Send the Hayes command string 'ATZ' (followed by a line feed, so we use FilePuts
	to automatically send that terminating line feed) to the modem */
    SAY '/* ====== Send the modem reset string ===== */'
    err = FilePuts(handle, 'ATZ')
    IF err <> 5 THEN SAY 'Error sending ATZ'



    /* ============================ FileGets ============================= */
    /** Read the "OK" line that we expect back from the modem. The modem
	  would send this with a line feed character at the end, so we can use
	  FileGets
     **/
    SAY '/* ====== Wait for "OK" response from the modem ===== */'
    DO UNTIL err = 'OK'
	err = FileGets(handle, 'tsc')
	SAY err  /* Print out the line that we read from the modem */
    END



    /* ============================ FileClose ============================= */
    /** Close the device driver.
     **/
    err = FileClose(handle)

END



/* Error opening the driver */
ELSE SAY "ERROR: Can't open 'port' driver"



/* ============================== clean up =============================== */
/* Drop the functions in FileRexx */
CALL FileDropFuncs

/* Done */
EXIT
