/******************************************************************
 * PATH.CMD
 *
 * This program calls the various REXX external functions provided in the FILEREXX DLL.
 *******************************************************************/


/* The FileLoadFuncs loads all the rest of the REXX functions in the FILEREXX DLL. */
/* So, we don't have to make calls to RxFuncAdd to add each one of those functions. Of */
/* course, in order to call FileLoadFuncs, we have to add that one. */
CALL RxFuncAdd 'FileLoadFuncs', 'FILEREXX', 'FileLoadFuncs'
CALL FileLoadFuncs

/* ============================== FileGetPath ============================ */
/* Split up the filespec that the user types on the command line when invoking this script.
    If he doesn't type any filespec, get the current path */
arg myspec
err = FileGetPath('Info', myspec, 'CHK')
IF err = 0 THEN DO
    SAY "Drive =" Info.0
    SAY "Path =" Info.1
    SAY "Filename =" Info.2
    SAY "Extension =" Info.3
END
ELSE SAY  "FileGetPath('Info', '"myspec"') =" err


/* =============================================================================== */
/* FileDropFuncs: This unloads all of the functions in the FILEREXX DLL. This is not necessary, and
    we could otherwise leave it open for some other REXX script */
CALL FileDropFuncs
