/**
 * REXX Communication Control Function Library  Ver.1.1
 *                  copyright 1998-1999, Naga(Kazuo Adachi)
 *                          mailto:nagaw@ibm.net
 *                          mailto:GDB00421@nifty.ne.jp
 *
 * $Id$
 *
 * $Log$
 */

CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
CALL SysLoadFuncs

CALL RxFuncAdd 'RxCommLoadFuncs','RxComm','RxCommLoadFuncs'
CALL RxCommLoadFuncs

/**
 * Setup Communication Parameter
 */
iniFile   = 'RxNIFTY.ini'
iniMode   = 0
comPort   = 'COM1'
comBaud   = 115200
comDial   = 'ATDT'
comInit.0 = 0

LINEIN( iniFile, 1, 0 )
DO WHILE LINES( iniFile )
    iniLine = LINEIN( iniFile )
    IF POS( '//', iniLine ) > 0 THEN iniLine = DELSTR( iniLine, POS( '//', iniLine ) )
    IF POS( '[' , iniLine ) = 1 THEN
    DO
        IF '[ʐMݒ]' = iniLine THEN iniMode = 1
                                  ELSE iniMode = 0
    END
    ELSE
    IF iniMode = 1 THEN
    DO
        PARSE VAR iniLine iniName '=' iniVals
        iniName = STRIP( iniName )
        iniVals = STRIP( iniVals )
        SELECT
            WHEN iniName = 'comInit' THEN
            DO
                addInit = comInit.0 + 1
                comInit.0 = addInit
                comInit.addInit = iniVals
            END
            WHEN iniName = 'comPort' THEN comPort = iniVals
            WHEN iniName = 'comBaud' THEN comBaud = iniVals
            WHEN iniName = 'comDial' THEN comDial = iniVals
            WHEN iniName = 'dialNo'  THEN dialNo  = iniVals
            WHEN iniName = 'userID'  THEN userID  = iniVals
            WHEN iniName = 'passwd'  THEN passwd  = iniVals
            OTHERWISE
        END
    END
END

logFile   = 'NIF'||SUBSTR(DATE('S'),5)||'.LOG'

/**
 * COM Port Device Open
 */
rc = RxCommOption( 'NULL_STRIP', 'ON' )
rc = RxCommOpen( comPort, comBaud, '8N1', 'RTS/CTS XON/XOFF' )
IF rc <> 0 THEN
DO
    SAY 'COM|[g̃I[vɎs܂!!'
    EXIT
END

SAY 'Let''s Start Communication!!'

/*--------------------------------------------------------*/
/**
 * Initialyzing Modem.
 */
DO i = 1 TO comInit.0
    CALL rxcInit comInit.i
    IF RESULT <> 0 THEN
    DO
        SAY 'f̏Ɏs܂B'
        EXIT
    END
END


/*--------------------------------------------------------*/
/**
 * Dial-up NIFTY FENICS-ROAD
 */
CALL rxcDial comDial, dialNo
IF RESULT <> 0 THEN
DO
    SAY '̐ڑɎs܂B'
    EXIT
END

rc = RxCommLog( logFile )

/*--------------------------------------------------------*/
/**
 * Log-on NIFTY-Serve
 */
CALL nifLogin userID, passwd

SAY '----- YES! welcome to NIFTY-Serve! -----'

getMail = 0
getNews = 0
cmdMenu = 0
DO FOREVER
    rc = RxCommRead()
    /* NIFTYȂł͂̏Ȃ(^_^; */
    DO WHILE POS( '00'x, rc ) > 0
        rc = DELSTR( rc, POS( '00'x, rc ), 1 )
    END
    CALL CHAROUT , rc

    SELECT
        WHEN POS( 'ʓ͂Ă܂iǕ', rc ) > 0
            THEN
            getMail = 1
        WHEN POS( 'T̂m点    NEW' , rc ) = 1
            THEN
            getNews = 1
        WHEN POS( 'NIFTY-Serve     TOP'   , rc ) = 1
            THEN
            cmdMenu = 1
        WHEN rc = ''
            THEN
            LEAVE
        OTHERWISE
    END
END

/*--------------------------------------------------------*/
/**
 *  NIFTY ̎}N!!
 */
iniMode = 0

LINEIN( iniFile, 1, 0 )
DO WHILE LINES( iniFile )
    iniLine = LINEIN( iniFile )
    IF POS( '//', iniLine ) > 0 THEN iniLine = DELSTR( iniLine, POS( '//', iniLine ) )
    IF POS( '[' , iniLine ) = 1 THEN
    DO
        IF '[ݒ]' = iniLine THEN iniMode = 1
                                  ELSE iniMode = 0
    END
    ELSE
    IF iniMode = 1 THEN
        IF POS( '*', iniLine ) = 1 THEN
        DO
            iniLine = DELSTR( iniLine, 1, 1 )
            rc = RxCommWrite( iniLine )
            CALL waitMain
        END
    DO
    END
END

/*--------------------------------------------------------*/
/**
 * Log-off NIFTY-Serve
 */
CALL nifLogof

SAY 'Stop Communication!'

rc = RxCommClose()

EXIT

/*--------------------------------------------------------*/
/**
 * Sub-routines for  NIFTY-Serve
 */
waitMain:
DO FOREVER
    rc = RxCommRead()
    /* NIFTYȂł͂̏Ȃ(^_^; */
    DO WHILE POS( '00'x, rc ) > 0
        rc = DELSTR( rc, POS( '00'x, rc ), 1 )
    END
    CALL CHAROUT , rc

    IF rc = '' THEN LEAVE
END
RETURN

