/* SAMPLE.CMD */
/* Sample REXX Program to access GPIB using rxGPIB */

/* To run this program, the file RXGPIB.DLL must be in */
/* the same directory as this file or in a directory */
/* listed in your LIBPATH. */

SAY ' '
SAY 'You must have a series 9300 LeCroy oscilloscope set to'
SAY 'GPIB address 4 and connected to the GPIB card for this'
SAY 'program to work.'
SAY ' '
SAY 'Press C to continue, or any other key to exit...'
keyhit = ''
PARSE PULL keyhit
keyhit = Translate(keyhit)
IF keyhit <> 'C' then
  EXIT

/*====================*/
/* Load RXGPIB.DLL    */
/*====================*/
CALL RXFuncAdd 'GPLoadFuncs', 'RXGPIB', 'GPLoadFuncs'
CALL GPLoadFuncs

SAY ''
SAY '--- Sample REXX Program to access GPIB.---'
SAY ''

device = 'DEV4'   /* GPIB device address of instrument */
devno = -1
IEEErd = ''
IEEEcmd = ''
reply = ''

devno1 = rxibfind(device)  /* find the device and get device number */
PARSE VALUE devno1 WITH . ' ' . ' ' devno
SAY 'Device found = ' || devno            

keyhit = ""
DO FOREVER
   SAY "---------------------------------------------------"
   SAY "Type 'x' to eXit..."
   SAY "Commands below are for LeCroy 9304 Scope"
   SAY "(type commands without the quotes):"
   SAY "'F' find DEV4; '0' set to local"
   SAY "'L' load setup; '2' read parameters;"
   SAY "'1' to set intensity; 'v' for DLL version."
   SAY ""
   SAY "--------------------------------------------------"
   SAY 'Enter selection: '
   PARSE PULL keyhit
   keyhit = Translate(keyhit)
   SELECT

      when keyhit = "F" then    /* find device */
        DO
          devno1 = rxibfind('DEV4')
          SAY 'Dev no. = ' || devno1
          PARSE VALUE devno1 WITH . ' ' . ' ' devno
          SAY 'Device found = ' || devno            
        END

      when keyhit = "1" then    /* set grid intensity */
        DO
          SAY 'Grid and trace intensity rc = ' || rxibwrt(devno, "INTS TRACE,75,GRID,40", 21)
        END

      when keyhit = "0" then    /* set local */
        DO
           IF devno > 0 THEN
             SAY 'Local = ' || rxibloc(devno)
           ELSE
             SAY "Invalid device, can't set to local"
        END

      when keyhit = "L" then    /* load 4 setups from file */
        DO
         IF devno > 0 then
           DO
             IEEErd = rxibclr(devno)
             PARSE VALUE IEEErd WITH ibsta ' ' iberr
             IF ibsta > 32767 THEN
               SAY "OSCILLOSCOPE not ON LINE"
             ELSE
               DO
                DO i = 1 to 4
                  SetFile = "D:\gpib\LECROY" || i || ".SET"
                  SAY "Setting up oscilloscope... " || SetFile  
                  SAY 'writing file: ' || rxibwrtf(devno, SetFile)
                  SAY 'write EXR?: ' || rxibwrt(devno, 'EXR?', 4)
                  IEEErd = rxibrd(devno, 100)
                  PARSE VALUE IEEErd WITH ibsta ' ' iberr ' ' reply
                  IF reply <> "EXR 0" THEN
                    DO
                      SAY "Scope setup problems with LECROY" || i || ".SET"
                      LEAVE
                    END
                  ELSE
                    DO
                      IEEEcmd = "*SAV " || i
                      SAY 'write *SAV: ' || rxibwrt(devno, IEEEcmd, Length(IEEEcmd))
                    END
                END

               IEEEcmd = "CLSW"
               SAY 'write CLSW: ' || rxibwrt(devno, IEEEcmd, Length(IEEEcmd))
               IEEEcmd = "EXR?"
               SAY 'write EXR?: ' || rxibwrt(devno, IEEEcmd, Length(IEEEcmd))
               SAY 'read: ' || rxibrd(devno, 100)
            END

          END
         ELSE
           SAY 'LeCroy not online.'

        END

      when keyhit = "2" then    /* read param */
        do
          /* request parameters from trace A */
          SAY 'request params: ' || rxibwrt(devno, "TA:PAVA? MAX,WID", 16)
          /* Read data from LeCroy */
          IEEErd = rxibrd(devno, 40)
          SAY 'parameters read: ' || IEEErd
        END

      when keyhit = "3" then    /* read param to file */
        do
          /* request parameters from trace A */
          SAY 'write: ' || rxibwrt(devno, "TA:PAVA? MAX,WID", 16)
          /* Read data from LeCroy and save to file */
          IEEErd = rxibrdf(devno, 'D:\gpib\testrd.txt')
          SAY 'read to file: ' || IEEErd
        END

      when keyhit = "V" then    /* rxGPIB.DLL version */
        do
          return_data = RXDLLVersion()    /* no parameters passed on */
          SAY "DLL version is: " || return_data
          keyhit = ""
        end

   otherwise
     DO
       IF keyhit = "X" THEN
         DO
            CALL GPDropFuncs
            SAY 'RXGPIB dropped.'
            EXIT
         END
       ELSE
         SAY "Invalid Input."
     END
   end  /* select */
end /* do */

EXIT

