/* Asuactl.dll
 * Pasek narzdzi, oglne deklaracje struktur danych i staych
 * paska narzdzi, niedostpne dla uytkownika.
 *
 * (c) 1999 Wojciech Gazda
 *
 * tooldefs.h
 *
 * $Author: Wojciech_Gazda $
 * $Date: 1999/06/27 12:36:37 $
 * $Name:  $
 * $RCSfile: tooldefs.h $
 * $Revision: 1.1 $
 */

/*  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


// Waniejsze wymiary
#define CX_TITLEWIDTH         10        // Szeroko paska tytuu
#define CY_TITLEHEIGHT        10        // Wysoko paska tytuu
#define CY_BOTTOMTIPSPACE     10        // Odstp midzy podpowiedzi a doln krawdzi przycisku
#define CY_TOPTIPSPACE        3         // Odstp midzy podpowiedzi a grn krawdzi przycisku
#define CX_ROTATEBUTTON       17        // Szeroko przycisku obracania paska
#define CY_ROTATEBUTTON       17        // Wysoko przycisku obracania paska
#define CX_ROTATEBITMAP       15        // Szeroko mapy bitowej uywanej do rysowania przycisku obracania
#define CY_ROTATEBITMAP       15        // Wysoko mapy bitowej uywanej do rysowania przycisku obracania
#define CXY_TITLEBUTTON       8         // Rozmiary przycisku rysowanego na pasku tytuu
#define CXY_TITLECUT          7         // Szeroko cicia
#define CXY_ENDMARGIN         4         // Margines kocowy
#define CXY_INTERNALMARGIN    1         // Dodatkowy margines midzy obramowaniem paska a obiektem
#define CXY_OBJECTSPACE       1         // Odstp midzy obiektami
#define CXY_ROTATESPACE       3         // Odstp od przycisku obracania (po obydwu stronach)
#define CXY_SEPARATOR         5         // Grubo separatora


// Inne definicje
#define TIME_TIPDELAY         1000      // Czas opnienia przed wczeniem podpowiedzi
#define TIME_TIPREMOVE        150       // Okres testowania pooenia kursora


// Kolory uywane przez pasek narzdzi
#define   TOOL_BACKGROUND           0    // Kolor nieaktywnego ta paska tytuu
#define   TOOL_HILITEBACKGROUND     1    // Kolor podwietlonego ta paska tytuu
#define   TOOL_FRAMEHILITE          2    // Podwietlenie
#define   TOOL_FRAMEDARK            3    // Cie
#define   TOOL_TIPBACKGROUND        4    // Kolor ta podpowiedzi
#define   TOOL_TIPTEXTCOLOR         5    // Kolor tekstu podpowiedzi
#define   TOOL_TIPFRAMECOLOR        6    // Kolor ramki otaczajcej tekst podpowiedzi
#define   TOOL_FRAMEDRAGHILITE      7    // Podwietlenie ramki podczas przesuwania
#define   TOOL_FRAMEDRAGDARK        8    // Cie ramki podczas przesuwania
// Liczba kolorw
#define   TOOL_MAXCOLOR             9




// Stany paska narzdzi niedostpne dla uytkownika - flToolState
#define  TST_FULLTRCFRAME  0x00010000   // danie rysowania penej ramki (np. podczas przesuwania paska)
#define  TST_MINMAXCTL     0x00020000   // Trwa wanie minimalizacja/maksymalizacja paska
#define  TST_TIPACTIVATED  0x00040000   // Podpowied zostaa uaktywniona
#define  TST_HITTEST       0x00080000   // Trwa przetwarzanie komunikatu WM_HITTEST



// Struktury danych
// Struktura kontrolna obiektu umieszczonego na pasku narzdzi
typedef struct
{ ULONG   iPosition;     // Pooenie obiektu na pasku narzdzi (numer kolejny)
  ULONG   ulGroup;       // Grupa do ktrej naley obiekt (wane tylko dla przyciskw)
  ULONG   flAttribute;   // Dodatkowe atrybuty obiektu
  LONG    x,  y;         // Pooenie obiektu na pasku narzdzi
  LONG    cx, cy;        // Wymiary obiektu
  ULONG   id;            // Identyfikator obiektu
  ULONG   ulUser;        // Pole do wykorzystania przez uytkownika
  HWND    hwndObject;    // Uchwyt okna obiektu
  PFNWP   pfnObjProc;    // Oryginalna procedura okna obiektu
  ATOM    aToolTip;      // Tekst podpowiedzi
} OBJCTL;



// Gwna struktura kontrolna paska narzdzi
typedef struct
{ ULONG    flWinStyle;             // Style okna
  ULONG    flToolAttrs;            // Atrybuty paska narzdzi
  ULONG    flToolState;            // Stan paska narzdzi
  ULONG    flOldState;             // Stan paska tytuu z przed ostatniej minimalizacji/maksymalizacji
  ULONG    flTitleState;           // Stan paska tytuu
  ULONG    flRotateState;          // Stan przycisku obracania okna
  ULONG    ulMaxLength;            // Maksymalna dugo paska w stanie floating
  LONG     lScrollOffset;          // Przesunicie elementw paska wzgldem pocztku
  LONG     lActiveTip;             // Identyfikator obiektu wywietlajcego podpowied
  HWND     hwndToolBar;            // Uchwyt paska narzdzi
  HWND     hwndTitleBar;           // Pasek tytuu paska narzdzi
  HWND     hwndToolTip;            // Uchwyt okna wywietlajcego podpowiedzi
  HWND     hwndRotate;             // Uchwyt przycisku obracania okna
  HWND     hwndObjectPad;          // Uchwyt okna aprzechowujcego obiekty
  POINTL   ptlOffset;              // Przesunicie paska narzdzi wzgldem waciciela
  PSZ      szWinText;              // Tytu okna (wywietlany jako podpowied)
  HATOMTBL hatomTips;              // Podpowiedzi do obiektw
  ULONG    nObjects;               // Liczba obiektw znajdujcych si na pasku narzdzi
  OBJCTL  *objtab;                 // Tablica definicji obiektw
  LONG     colors[TOOL_MAXCOLOR];  // Pomocnicza tablica kolorw
} TOOLCTL;


// Tablica wzorcw kolorw dla paska narzdzi
extern PPTEMPLATE PPmColor[];
// Uchwyt moduu zawierajcego zasoby i funkcje
extern HMODULE hResource;
// Wersja systemu operacyjnego
extern ULONG   ulWarpVer;




// Prototypy funkcji
VOID     ToolDisplayTip(HWND hwnd, HWND hwndRef, PSZ szTipText);
VOID     ToolDrawSeparator(HWND hwnd, LONG lPos, ULONG ulSize);
TOOLCTL *ToolLoadData(HWND hwnd, PSZ module);
LONG     ToolSendNotify(HWND hwnd, ULONG notify, VOID *ctlspec);
VOID     ToolUpdateSize(TOOLCTL *tcl);

/*
 * $Log: tooldefs.h $
 * Revision 1.1  1999/06/27 12:36:37  Wojciech_Gazda
 * Initial revision
 *
 */
