/*  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/* Asuactl.dll
 * Pasek narzdzi - dodatkowe okna kontrolne (Carrier Controls).
 * (c) 1999 Wojciech Gazda
 *
 * tcontrol.c
 *
 * $Author: Wojciech_Gazda $
 * $Date: 1999/06/27 12:35:51 $
 * $Name:  $
 * $RCSfile: tcontrol.c $
 * $Revision: 1.1 $
 *
 */

//#define  INCL_DOSDEV
#define  INCL_DOSPROCESS

// Deklaracje OS/2
#define  INCL_GPILOGCOLORTABLE
#define  INCL_GPIPRIMITIVES
#define  INCL_GPIPOLYGON
#define  INCL_WINRECTANGLES
#define  INCL_WINWINDOWMGR
#define  INCL_WINTRACKRECT
#define  INCL_WINFRAMEMGR
#define  INCL_WINPOINTERS
#define  INCL_WINTIMER
#define  INCL_WININPUT
#define  INCL_WINATOM
#define  INCL_WINSYS
#include <os2.h>


// Deklaracje lokalne
#define  __INTERNAL_USE__
#include "asuintl.h"
#include "toolbar.h"
#include "tooldefs.h"
#include "tcontrol.h"


// Identyfikatory timerw
#define TMR_TITLEHILITE       1         // Czasomierz sterujcy podwietlaniem paska tytuu
#define TMR_TITLETIP          2         // Czasomierz sterujcy wywietlaniem podpowiedzi
#define TMR_ROTATEHILITE      3         // Czasomierz sterujcy podwietlaniem przycisku obracania




// Prototypy funkcji
MRESULT EXPENTRY MiniTitlebarProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY RotateButtonProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);



// Prototypy funkcji lokalnych
static VOID  MtlControlPos(HWND hwnd, SWP *newpos);
static VOID  MtlHiliteControl(HWND hwnd, ULONG msg, ULONG timer);
static BOOL  MtlTestPoint(TOOLCTL *tcl, POINTS *cpos, ULONG mode);
static VOID  MtlMinMaxControl(HWND hwnd, ULONG msgcode, POINTS *cpos);
static VOID  MtlRedraw(HWND hwnd);
static VOID  MtlBeginTrack(HWND hwnd, POINTS *cpos);
static VOID  RtbHiliteControl(HWND hwnd, ULONG msg, ULONG timer);
static VOID  RtbRedraw(HWND hwnd);
static VOID  RtbRotateRequest(HWND hwnd);

// Dodatkowe funkcje usugowe
static VOID  DrawBitmap(HPS hps, HBITMAP hbitmap, POINTL *pos, ULONG flMode);
static VOID  DrawTitleButton(HPS hps, RECTL *wsize, ULONG TitleState);
static VOID  DrawTitleFace(HPS hps, RECTL *wsize, ULONG TitleState);
static VOID  DrawTitleFrame(HPS hps, RECTL *wsize, ULONG TitleState);





// Procedura okna sterujca paskiem tytuu
//
MRESULT EXPENTRY MiniTitlebarProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  switch(msg)
  { case WM_ADJUSTWINDOWPOS:  // Korekta skalowania
      MtlControlPos(hwnd, (SWP *)PVOIDFROMMP(mp1));
      return(0);

    case WM_BUTTON1DBLCLK:    // Obsuga minimalizacji/maksymalizacji
    case WM_BUTTON1CLICK:     // w trybie normalnym i full window drag.
      MtlMinMaxControl(hwnd, msg, (POINTS *)&mp1);
      break;

    case WM_BUTTON1DOWN:      // Nacinicie lewego przycisku myszy
      // Przesanie komunikatu do standardowej procedury
      // w celu poprawnej aktywacji gwnego okna aplikacji.
      WinDefWindowProc(hwnd, msg, mp1, mp2);
      // Sprawdzenie czy mona rozpocz przesuwanie okna
      MtlBeginTrack(hwnd, (POINTS *)&mp1);
      break;

    case WM_MOUSEMOVE:        // Reakcja na ruch myszy
      // Kontrola podwietlania, wywietlanie tytuu w okienku popowiedzi
      MtlHiliteControl(hwnd, msg, 0L);
      break;

    case WM_PAINT:            // Przerysowanie paska tytuu
      MtlRedraw(hwnd);
      break;

    case WM_TIMER:            // Sterowanie podwietleniem paska i wywietlaniem tytuu
      MtlHiliteControl(hwnd, msg, SHORT1FROMMP(mp1));
      break;
  }

  // Powrt do standardowej procedury okna
  return(WinDefWindowProc(hwnd, msg, mp1, mp2));
}





// Procedura obsugujca przycisk obracania okna
//
MRESULT EXPENTRY RotateButtonProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  switch(msg)
  { case WM_BUTTON1CLICK:     // Wygenerowanie dania obrcenia okna
      RtbRotateRequest(hwnd);
      break;

    case WM_BUTTON1DOWN:      // Kontrola podswietlania przycisku
    case WM_BUTTON1UP:
    case WM_MOUSEMOVE:
      RtbHiliteControl(hwnd, msg, 0L);
      break;

    case WM_CALCVALIDRECTS:   // Okrelenie obszaru nie podlegajcego uniewanieniu
      break;

    case WM_PAINT:            // Przerysowanie przycisku
      RtbRedraw(hwnd);
      return(0);

    case WM_TIMER:            // Sterowanie podwietleniem przycisku
      RtbHiliteControl(hwnd, msg, SHORT1FROMMP(mp1));
      break;
  }

  // Powrt do standardowej procedury okna
  return(WinDefWindowProc(hwnd, msg, mp1, mp2));
}





//*******************/
//* Funkcje lokalne */
//*******************/

// Kontrola rozmiarw okna podczas skalowania
//
// Parametry:
//   hwnd      - [parametr] uchwyt paska tytuu
//   newpos    - [parametr/rezultat] pozycja i znaczniki przekazywane przez WinSetWindowPos
//
static VOID  MtlControlPos(HWND hwnd, SWP *newpos)
{ TOOLCTL *tcl;          // Adres gwnej struktury kontrolnej okna

  tcl = ToolLoadData(hwnd, "MtlControlPos");
  if(tcl == NULL) return;

  // Okrelenie wymiarw paska tytuu
  if(tcl->flTitleState & STT_ROTATED)
  { // Pasek jest odwrcony - rysowany poziomo
    newpos->cy = CY_TITLEHEIGHT;
  }
  else
  { // Pasek jest w pozycji normalnej - rysowany pionowo
    newpos->cx = CX_TITLEWIDTH;
  }
  // Wymuszenie zmiany rozmiaru
  newpos->fl |= SWP_SIZE;
}





// Funkcja steruje podwietlaniem paska tytuu, oraz wywietlaniem
// podpowiedzi zawierajcej tytu paska narzdzi
//
// Parametry:
//   hwnd      - [parametr] uchwyt paska tytuu
//   msg       - [parametr] kod komunikatu - WM_MOUSEMOVE lub WM_TIMER
//   timer     - [parametr] numer timera
//
static VOID MtlHiliteControl(HWND hwnd, ULONG msg, ULONG timer)
{ TOOLCTL *tcl;          // Adres gwnej struktury kontrolnej paska narzdzi
  HAB      hab;          // Uchwyt anchor block
  RECTL    wsize;        // Rozmiary okna
  POINTL   pos;          // Pozycja kursora myszy
  LONG     tipdelay;     // Czas opnienia przed wczeniem podpowiedzi

  tcl = ToolLoadData(hwnd, "MtlHiliteControl");
  if(tcl == NULL) return;
  hab = WinQueryAnchorBlock(hwnd);

  // Zaczenie podwietlenia okna
  if(msg == WM_MOUSEMOVE)
  { // Sprawdzenie czy okno nie jest ju podwietlone
    if(!(tcl->flTitleState & STT_HILITED))
    { // Podwietlenie okna
      tcl->flTitleState |= STT_HILITED;
      // Odwieenie okna
      WinInvalidateRect(hwnd, NULL, TRUE);
      // Wyzwolenie czasomierza sterujcego podwietlaniem
      WinStartTimer(hab, hwnd, TMR_TITLEHILITE, TIME_TIPREMOVE);

      // Odczyt czasu opnienia przed wczeniem podpowiedzi
      if(!WinQueryPresParam(hwnd, PP_TOOLTIPDELAY, 0L, NULL, 4, &tipdelay, 0L))
        tipdelay = TIME_TIPDELAY;
      // Wyzwolenie czasomierza sterujcego wywietlaniem podpowiedzi
      WinStartTimer(hab, hwnd, TMR_TITLETIP, (ULONG)tipdelay);
    }
  }
  if(msg == WM_TIMER)
  { // Sprawdzenie czy wyczy podwietlenie i podpowied do paska tytuu
    if(timer == TMR_TITLEHILITE)
    { // Sprawdzenie czy kursor znajduje si w obrbie okna
      WinQueryPointerPos(HWND_DESKTOP, &pos);
      // Konwersja do wsprzdnych okna
      WinMapWindowPoints(HWND_DESKTOP, hwnd, &pos, 1);
      // Odczyt wymiarw okna
      WinQueryWindowRect(hwnd, &wsize);
      // Sprawdzenie czy kursor jest wewntrz okna
      if(WinPtInRect(hab, &wsize, &pos) == FALSE)
      { // Zatrzymanie timerw
        WinStopTimer(hab, hwnd, TMR_TITLEHILITE);
        WinStopTimer(hab, hwnd, TMR_TITLETIP);

        // Wyczenie podpowiedzi (jeli jest)
        if(tcl->flTitleState & STT_TOOLTIP)
        { tcl->flTitleState &= ~STT_TOOLTIP;
          // Zgaszenie okna z podpowiedzi
          if(tcl->hwndToolTip != NULLHANDLE)
            WinSetWindowPos(tcl->hwndToolTip, HWND_TOP, 0, 0, 0, 0, SWP_HIDE);
        }

        // Wyczenie podwietlenia paska
        tcl->flTitleState &= ~STT_HILITED;
        // Odwieenie okna
        WinInvalidateRect(hwnd, NULL, TRUE);
      }
    }

    // Wywietlenie tytuu (podpowiedzi)
    if(timer == TMR_TITLETIP)
    { // Zatrzymanie czasomierza
      WinStopTimer(hab, hwnd, TMR_TITLETIP);
      // Wywietlenie okna z podpowiedzi
      ToolDisplayTip(hwnd, hwnd, tcl->szWinText);
      // Uaktualnienie znacznika
      tcl->flTitleState |= STT_TOOLTIP;
    }
  }
}





// Funkcja sprawdza czy podana pozycja kursora mieci si w obrbie
// zadanego obszaru w obrbie paska tytuu.
//
// Parametry:
//   tcl       - [parametr] wskanik do gwnych struktur kontrolnych paska narzdzi
//   cpos      - [parametr] wsprzdne kursora liczone wzgldem paska tytuu
//   mode      - [parametr] identyfikator testowanego obszaru
//
// Powrt:
//   FALSE - kursor nie jest nad podanym obszarem
//   TRUE  - kursor jest nad podanym obszarem
//
static BOOL MtlTestPoint(TOOLCTL *tcl, POINTS *cpos, ULONG mode)
{ POINTL   pos;          // Pozycja kursora
  RECTL    area;         // Wsprzdne tesrowanego obszaru
  HAB      hab;          // Uchwyt anchor block PM

  // Odczyt uchwytu anchor block
  hab = WinQueryAnchorBlock(tcl->hwndTitleBar);
  // Odczyt wymiarw okna
  WinQueryWindowRect(tcl->hwndTitleBar, &area);

  // Sprawdzenie czy jest przycisk "przyklejania/odklejania" okna
  if(tcl->flTitleState & STT_DRAWBUTTON)
  { // Korekta wymiarw obszaru movebar
    if(tcl->flTitleState & STT_ROTATED)
    { // Pasek tytuu jest odwrcony - ley poziomo
      area.xLeft += (CXY_TITLEBUTTON + 1);
    }
    else
    { // Pasek tytuu jest w normalnej pozycji - pionowo
      area.yTop  -= (CXY_TITLEBUTTON + 2);
    }
  }

  // Przepisanie pozycji kursora
  pos.x = cpos->x; pos.y = cpos->y;
  // Sprawdzenie czy kursor jest ponad paskiem przesuwu okna
  if(mode == MTLQ_MOVEBAR)
    return(WinPtInRect(hab, &area, &pos));

  // Sprawdzenie czy kursor jest ponad przyciskiem min/max
  if((mode == MTLQ_FIXBUTTON) && (tcl->flTitleState & STT_DRAWBUTTON))
  { if(WinPtInRect(hab, &area, &pos) == FALSE)
      return(TRUE);
    else return(FALSE);
  }
  return(FALSE);
}





// Funkcja steruje minimalizacj i maksymalizacj paska narzdzi za pomoc myszy,
// oraz przyklejaniem/odklejaniem paska od okna rodzicielskiego.
//
// Parametry:
//   hwnd      - [parametr] uchwyt paska tytuu
//   msgcode   - [parametr] Kod komunikatu odpowiedzialnego za wywoanie funkcji
//   cpos      - [parametr] pozycja kursora w momencie naciskania przycisku
//
static VOID  MtlMinMaxControl(HWND hwnd, ULONG msgcode, POINTS *cpos)
{ TOOLCTL *tcl;          // Adres struktur kontrolnych paska nazdzi
  LONG     flswp;        // Zmienna sterujca procesem zmiany stanu okna

  tcl = ToolLoadData(hwnd, "MtlMinMaxControl");
  if(tcl == NULL) return;

  //// Sprawdzenie czy przesuwa tylko ramk
  if(ulWarpVer >= 40)
  { // Sprawdznie czy jest uaktywniona opcja "Full Window Drag"
    if(WinQuerySysValue(HWND_DESKTOP, SV_TRACKRECTLEVEL) != 0)
      // Ignorowanie podwjnego kliknicia
      if(msgcode == WM_BUTTON1DBLCLK) return;
  }
  else
    // Przesuwanie samej ramki
    if(msgcode == WM_BUTTON1DOWN) return;

  // Sprawdzenie czy kursor jest ponad uchwytem do przesuwania okna
  // oraz jest odblokowana minimalizacja/maksymalizacja okna
  if(MtlTestPoint(tcl, cpos, MTLQ_MOVEBAR) == TRUE)
  { if(tcl->flWinStyle & TBS_ENABLEMINIMIZE)
    {
      // Odczyt aktualnego stanu okna
      if(tcl->flToolState & TST_MINIMIZED)
        flswp = SWP_MAXIMIZE;
      else flswp = SWP_MINIMIZE;

      // Zmiana stanu okna
      WinSetWindowPos(tcl->hwndToolBar, HWND_TOP, 0, 0, 0, 0, flswp);
    }
  }

  // Sprawdzenie czy kursor jest nad przyciskiem dokowania
  else if(MtlTestPoint(tcl, cpos, MTLQ_FIXBUTTON) == TRUE)
  {
    // Okrelenie aktualnego stanu okna
    if(tcl->flToolState & (TST_MINIMIZED | TST_FIXED))
      flswp = SWP_RESTORE;
    else
    { // Odczyt poprzedniego stanu okna
      if(tcl->flOldState & TST_MINIMIZED)
        flswp = SWP_MINIMIZE;
      else flswp = SWP_MAXIMIZE;
    }

    // Zmiana stanu okna
    WinSetWindowPos(tcl->hwndToolBar, HWND_TOP, 0, 0, 0, 0, flswp);
  }
}





// Przerysowanie paska tytuu
//
// Parametry:
//   hwnd      - [parametr] uchwyt paska tytuu
//
static VOID MtlRedraw(HWND hwnd)
{ TOOLCTL *tcl;                    // Adres gwnej struktury kontrolnej paska narzdzi
  RECTL    wsize;                  // Rozmiar okna
  HPS      hps;                    // Uchwyt presentation space

  tcl = ToolLoadData(hwnd, "MtlRedraw");
  if(tcl == NULL) return;

  // Odczyt rozmiarw okna
  WinQueryWindowRect(hwnd, &wsize);
  // Rozpoczcie rysowania
  hps = WinBeginPaint(hwnd, NULL, NULLHANDLE);
  // adowanie tablicy kolorw
  PpmQueryPresColors(tcl->hwndToolBar, TOOL_MAXCOLOR, PPmColor, tcl->colors);
  // Tworzenie logicznej tablicy kolorw
  GpiCreateLogColorTable(hps, LCOL_PURECOLOR, LCOLF_CONSECRGB, 0L, TOOL_MAXCOLOR, tcl->colors);

  // Rysowanie obramowania
  DrawTitleFrame(hps, &wsize, tcl->flTitleState);
  // Rysowanie wntrza przycisku
  DrawTitleFace(hps, &wsize, tcl->flTitleState);
  // Rysowanie przycisku (trjkcika) wewntrz paska
  DrawTitleButton(hps, &wsize, tcl->flTitleState);

  // Zakoczenie rysowania
  WinEndPaint(hps);
}





// Sprawdzenie czy mona wygenerowa komunikat WM_TRACKRECT
// i jeli mona, to wysanie go do waciciela.
//
// Parametry:
//   hwnd      - [parametr] uchwyt paska tytuu
//   cpos      - [parametr] pozycja kursora myszy
//
static VOID MtlBeginTrack(HWND hwnd, POINTS *cpos)
{ TOOLCTL *tcl;          // Struktura kontrolna paska narzdzi
  HWND     owner;        // Waciciel paska tytuu
  ULONG    tflags;       // Zmienne sterujce przesuwem


  // Odczyt adresu struktury kontrolnej
  tcl = ToolLoadData(hwnd, "MtlBeginTrack");
  if(tcl == NULL) return;
  // Sprawdzenie czy kursor myszy znajduje si nad paskiem przesuwania
  if(MtlTestPoint(tcl, cpos, MTLQ_MOVEBAR) == FALSE) return;

  // Odczyt uchwytu waciciela paska tytuu
  owner = WinQueryWindow(hwnd, QW_OWNER);
  if(owner != NULLHANDLE)
  { // Zatrzymanie timera wywietlajcego podpowied
    WinStopTimer(WinQueryAnchorBlock(hwnd), hwnd, TMR_TITLETIP);
    // Zaczenie podwietlenia
    tcl->flTitleState |= STT_HILITED;
    WinInvalidateRect(hwnd, NULL, FALSE);

    // Okrelenie flag sterujcych przesuwem
    tflags = TF_MOVE;
    // Sprawdzenie czy okno jest "przymocowane" do okna rodzicielskiego
    if(tcl->flToolState & TST_FIXED) tflags |= TF_ALLINBOUNDARY;
    // Wysanie komunikatu WM_TRACKFRAME - rozpoczcie przesuwu okna
    WinSendMsg(owner, WM_TRACKFRAME, MPFROMLONG(tflags), 0L);

    // Wyczenie podwietlenia
    tcl->flTitleState &= ~STT_HILITED;
  }
}





// Funkcja steruje podwietlaniem przycisku obracania okna
//
// Parametry:
//   hwnd      - [parametr] uchwyt przycisku obracania
//   msg       - [parametr] kod komunikatu - WM_MOUSEMOVE lub WM_TIMER
//   timer     - [parametr] numer timera
//
static VOID RtbHiliteControl(HWND hwnd, ULONG msg, ULONG timer)
{ TOOLCTL *tcl;          // Wskanik do gwnej struktury kontrolnej okna
  POINTL   pos;          // Pozycja kursora wewntrz okna
  RECTL    wsize;        // Wymiary okna
  HAB      hab;          // Uchwyt anchor block PM

  tcl = ToolLoadData(hwnd, "RtbHiliteControl");
  if(tcl == NULL) return;
  hab = WinQueryAnchorBlock(hwnd);

  if(msg == WM_MOUSEMOVE)
  { // Sprawdzenie czy okno nie jest ju podwietlone,
    // i czy przycisk myszy nie jest w dolnym pooeniu
    if(!(tcl->flRotateState & (SRB_HILITED | SRB_BUTTONDOWN)))
    { // Podwietlenie okna
      tcl->flRotateState |= SRB_HILITED;
      // Odwieenie okna
      WinInvalidateRect(hwnd, NULL, TRUE);
      // Wyzwolenie czasomierza sterujcego podwietlaniem
      WinStartTimer(hab, hwnd, TMR_ROTATEHILITE, TIME_TIPREMOVE);
    }
  }
  if(msg == WM_TIMER)
  { // Sprawdzenie czy wyczy podwietlenie przycisku
    if(timer == TMR_ROTATEHILITE)
    { // Sprawdzenie czy kursor znajduje si w obrbie okna
      WinQueryPointerPos(HWND_DESKTOP, &pos);
      // Konwersja do wsprzdnych okna
      WinMapWindowPoints(HWND_DESKTOP, hwnd, &pos, 1);
      // Odczyt wymiarw okna
      WinQueryWindowRect(hwnd, &wsize);
      // Sprawdzenie czy kursor jest wewntrz okna
      if(WinPtInRect(hab, &wsize, &pos) == FALSE)
      { // Zatrzymanie timera
        WinStopTimer(hab, hwnd, TMR_ROTATEHILITE);
        // Wyczenie podwietlenia paska
        tcl->flRotateState &= ~SRB_HILITED;
        // Odwieenie okna
        WinInvalidateRect(hwnd, NULL, TRUE);
      }
    }
  }
  if(msg == WM_BUTTON1DOWN)
  { // Przejcie kursora myszy
    WinSetCapture(HWND_DESKTOP, hwnd);
    // Sprawdzenie czy wyczy podwietlanie przycisku
    if(tcl->flRotateState & SRB_HILITED)
    { // Wyczenie powietlania
      tcl->flRotateState &= ~SRB_HILITED;
      // Zaznaczenie nacinicia przycisku
      tcl->flRotateState |=  SRB_BUTTONDOWN;
      // Przerysowanie okna
      WinInvalidateRect(hwnd, NULL, TRUE);
    }
  }
  if(msg == WM_BUTTON1UP)
  { // Zwolnienie kursora myszy
    WinSetCapture(HWND_DESKTOP, NULLHANDLE);
    // Usunicie znacznika nacinicia przycisku
    tcl->flRotateState &= ~SRB_BUTTONDOWN;
  }
}





// Przerysowanie przycisku obracania okna
//
// Parametry:
//   hwnd      - [parametr] uchwyt okna przycisku
//
static VOID RtbRedraw(HWND hwnd)
{ TOOLCTL *tcl;          // Wskanik do struktur kontrolnych paska narzdzi
  POINTL   pos;          // Wsprzdne oglnego przeznaczenia
  RECTL    wsize;        // Wymiary okna
  HBITMAP  hbitmap;      // Uchwyt mapy bitowej
  HPS      hps;          // Uchwyt presentation space okna


  tcl = ToolLoadData(hwnd, "RtbRedraw");
  if(tcl == NULL) return;

  hps = WinBeginPaint(hwnd, NULLHANDLE, NULL);
  // adowanie tablicy kolorw
  PpmQueryPresColors(tcl->hwndToolBar, TOOL_MAXCOLOR, PPmColor, tcl->colors);
  // Tworzenie logicznej tablicy kolorw
  GpiCreateLogColorTable(hps, LCOL_PURECOLOR, LCOLF_CONSECRGB, 0L, TOOL_MAXCOLOR, tcl->colors);
  // Okrelenie wymiarw okna
  WinQueryWindowRect(hwnd, &wsize);

  // Kasowanie ta
  GpiSetColor(hps, TOOL_BACKGROUND);
  // Kasowanie wntrza przycisku
  pos.x = wsize.xLeft; pos.y = wsize.yBottom;
  GpiMove(hps, &pos);
  pos.x = wsize.xRight - 1; pos.y = wsize.yTop - 1;
  GpiBox(hps, DRO_FILL, &pos, 0, 0);

  // Obliczenie pooenia kopiowanych map bitowych
  pos.x = (wsize.xLeft   + wsize.xRight - CX_ROTATEBITMAP) / 2;
  pos.y = (wsize.yBottom + wsize.yTop   - CY_ROTATEBITMAP) / 2;

  // Rysowanie maski bitowej (wycicie ta)
  hbitmap  = GpiLoadBitmap(hps, hResource, ROTATE_BACK,    0, 0);
  if(hbitmap != NULLHANDLE)
  { // Ustawienie atrybutw - koloru ta i punktu
    GpiSetColor(hps, CLR_WHITE);
    GpiSetBackColor(hps, CLR_BLACK);
    // Kopiowanie mapy bitowej
    DrawBitmap(hps, hbitmap, &pos, ROP_SRCAND);
    // Usunicie mapy bitowej
    GpiDeleteBitmap(hbitmap);
  }

  // Wypenienie strzaki
  hbitmap  = GpiLoadBitmap(hps, hResource, ROTATE_FILL,    0, 0);
  if(hbitmap != NULLHANDLE)
  { // Ustawienie atrybutw - koloru ta i punktu
    GpiSetColor(hps, tcl->flRotateState & SRB_HILITED ? TOOL_HILITEBACKGROUND : TOOL_FRAMEDARK);
    GpiSetBackColor(hps, CLR_BLACK);
    // Kopiowanie mapy bitowej
    DrawBitmap(hps, hbitmap, &pos, ROP_SRCPAINT);
    // Usunicie mapy bitowej
    GpiDeleteBitmap(hbitmap);
  }

  // Naoenie konturu
  hbitmap  = GpiLoadBitmap(hps, hResource, ROTATE_OUTLINE, 0, 0);
  if(hbitmap != NULLHANDLE)
  { // Kopiowanie mapy bitowej
    DrawBitmap(hps, hbitmap, &pos, ROP_SRCPAINT);
    // Usunicie mapy bitowej
    GpiDeleteBitmap(hbitmap);
  }

  WinEndPaint(hps);
}





// Wygenerowanie dania obrcenia paska narzdzi
//
// Parametry:
//   hwnd      - [parametr] uchwyt przycisku obracania okna
//
static VOID  RtbRotateRequest(HWND hwnd)
{ TOOLCTL *tcl;     // Wskanik do gwnych struktur kontrolnych okna

  tcl = ToolLoadData(hwnd, "RtbRotateRequest");
  if(tcl == NULL) return;

  // Wysanie komunikatu TM_ROTATE do paska narzdzi
  WinSendMsg(tcl->hwndToolBar, TM_ROTATE, 0L, 0L);
}





/******************************/
/* Dodatkowe funkcje usugowe */
/******************************/

// Rysowanie mapy bitowej. Rozmiary s odczytywane automatycznie.
//
// Parametry:
//   hps       - [parametr] presentation space
//   hbitmap   - [parametr] uchwyt rysowanej mapy bitowej
//   pos       - [parametr] pooenie lewego dolnego rogu
//   flMode    - [parametr] tryb nakadania mapy bitowej
//
static VOID DrawBitmap(HPS hps, HBITMAP hbitmap, POINTL *pos, ULONG flMode)
{ BITMAPINFOHEADER2 *bfh;     // Wskanik do pocztku struktury informacyjnej
  POINTL bmpos[4];            // Pozycja mapy bitowej (wsprzdzne dla GpiWCBitBlt)
  UCHAR  tmp[16];             // Bufor na pocztkow cz struktury BITMAPINFOHEADER2

  // Inicjacja zmiennych
  bfh = (BITMAPINFOHEADER2 *)tmp;
  // Odczyt wymiarw mapy bitowej
  bfh->cbFix = 16;
  if(GpiQueryBitmapInfoHeader(hbitmap, bfh) == FALSE) return;

  // Obliczenie wsprzdnych kopiowanych map bitowych
  // Wsprzdne lewego dolnego rogu obszaru docelowego
  bmpos[0].x = pos->x;
  bmpos[0].y = pos->y;
  // Wsprzdne prawego grnego rogu obszaru docelowego
  bmpos[1].x = bmpos[0].x + bfh->cx - 1;
  bmpos[1].y = bmpos[0].y + bfh->cy - 1;
  // Wsprzdne lewego dolnego rogu obszaru rdowego
  bmpos[2].x = 0;
  bmpos[2].y = 0;
  // Wsprzdne prawego grnego rogu obszaru rdowego
  bmpos[3].x = bfh->cx;
  bmpos[3].y = bfh->cy;

  // Kopiowanie mapy bitowej
  GpiWCBitBlt(hps, hbitmap, 4L, bmpos, flMode, 0L);
}





// Rysowanie przycisku (trjkcika) na pasku tytuu
//
// Parametry:
//   hps       - [parametr] uchwyt presentation space
//   wsize     - [parametr] rozmiary okna
//   tcl       - [parametr] wskanik do struktur kontrolnych paska narzdzi
//
static VOID DrawTitleButton(HPS hps, RECTL *wsize, ULONG TitleState)
{ POINTL  pos;           // Wsprzdne oglnego przeznaczenia
  HBITMAP hbmMono;       // Uchwyt monochromatycznej maski bitowej
  HBITMAP hbmColor;      // Uchwyt kolorowej mapy bitowej wywietlanej na przycisku

  // Sprawdzenie czy opcje pozawalaj na rysowania
  if(!(TitleState & STT_DRAWBUTTON)) return;

  // Kasowanie ta pod przycisk
  // Okrelenie koloru ta
  GpiSetColor(hps, TitleState & STT_HILITED ? TOOL_HILITEBACKGROUND : TOOL_BACKGROUND);

  // Wsprzdne lewego dolnego rogu obszaru docelowego
  pos.x = wsize->xLeft + 1;
  pos.y = TitleState & STT_ROTATED ? wsize->yBottom  + 1 : wsize->yTop   - 1 - CXY_TITLEBUTTON;
  GpiMove(hps, &pos);
  // Wsprzdne prawego grnego rogu obszaru docelowego
  pos.x = TitleState & STT_ROTATED ? CXY_TITLEBUTTON     : wsize->xRight - 2;
  pos.y = wsize->yTop - 2;
  GpiBox(hps, DRO_FILL, &pos, 0L, 0L);

  // Tworzenie map bitowych
  hbmMono  = GpiLoadBitmap(hps, hResource,
                           TitleState & STT_UPTRIANGL ? MONO_UPTRIANGL  : MONO_DOWNTRIANGL,
                           0, 0);
  hbmColor = GpiLoadBitmap(hps, hResource,
                           TitleState & STT_UPTRIANGL ? COLOR_UPTRIANGL : COLOR_DOWNTRIANGL,
                           0, 0);

  // Wsprzdne lewego dolnego rogu obszaru docelowego
  pos.x = wsize->xLeft + 2;
  pos.y = wsize->yTop - 7;

  // Rysowanie ta pod kolorow map bitow
  if(hbmMono != NULLHANDLE)
  { // Ustawienie atrybutw - koloru ta i punktu
    GpiSetColor(hps, CLR_WHITE);
    GpiSetBackColor(hps, CLR_BLACK);
    // Kopiowanie mapy bitowej
    DrawBitmap(hps, hbmMono, &pos, ROP_SRCAND);
    // Usunicie mapy bitowej
    GpiDeleteBitmap(hbmMono);
  }
  // Rysowanie przycisku - kolorowej mapy bitowej
  if(hbmColor != NULLHANDLE)
  { // Kopiowanie mapy bitowej
    DrawBitmap(hps, hbmColor, &pos, ROP_SRCPAINT);
    // Usunicie mapy bitowej
    GpiDeleteBitmap(hbmColor);
  }
}





// Rysowanie wntrza paska tytuu
//
// Parametry:
//   hps       - [parametr] uchwyt presentation space
//   wsize     - [parametr] rozmiary okna
//   tcl       - [parametr] wskanik do struktur kontrolnych paska narzdzi
//
static VOID DrawTitleFace(HPS hps, RECTL *wsize, ULONG TitleState)
{ POLYGON poly;          // Definicja wielokta
  POINTL  ptl[4];        // Punkty wielokta
  POINTL  pos;           // Wsprzdne oglnego przenaczenia
  LONG    start, stop;   // Pozycja pocztkowa i kocowa


  // Okrelenie koloru ta
  GpiSetColor(hps, TitleState & STT_HILITED ? TOOL_HILITEBACKGROUND : TOOL_BACKGROUND);
  // Rysowanie ta
  // Ustawienie punktu pocztkowego
  pos.x = wsize->xRight - 2;
  pos.y = wsize->yTop   - 2;
  if(TitleState & STT_DRAWBUTTON)
    pos.y -= (TitleState & STT_ROTATED ? 0 : CXY_TITLEBUTTON);
  GpiMove(hps, &pos);

  // Okrelenie liczby punktw
  poly.ulPoints = 3;

  // Lewy grny rg
  ptl[0].x = wsize->xLeft + 1;
  ptl[0].y = wsize->yTop  - 2;
  if(TitleState & STT_DRAWBUTTON)
  { ptl[0].x += (TitleState & STT_ROTATED ? CXY_TITLEBUTTON : 0);
    ptl[0].y -= (TitleState & STT_ROTATED ? 0 : CXY_TITLEBUTTON);
  }

  // Lewy dolny rg
  ptl[1].x = wsize->xLeft   + 1;
  ptl[1].y = wsize->yBottom + 1;
  if(TitleState & STT_DRAWBUTTON)
    ptl[1].x += (TitleState & STT_ROTATED ? CXY_TITLEBUTTON : 0);

  // Prawy dolny rg
  ptl[2].x = wsize->xRight  - 2;
  ptl[2].y = wsize->yBottom + 1;

  // Obliczenie pozycji punktw podczas rysowania wycicia
  if(TitleState & STT_DRAWCUT)
  { // O jeden punkt wicej
    poly.ulPoints ++;
    // Korekta pierwszego punktu wycicia
    ptl[2].x = wsize->xRight - CXY_TITLECUT - 1;
    // Pozycja drugiego punktu wycicia
    ptl[3].x = wsize->xRight - 2;
    ptl[3].y = wsize->yBottom + CXY_TITLECUT;
  }

  // Rysowanie wielokta
  poly.aPointl = ptl;
  GpiPolygons(hps, 1, &poly, 0L, POLYGON_INCL);

  // Rysowanie kropkowanego ta
  if(TitleState & STT_ROTATED)
  { // Pasek w pooeniu poziomym
    // Okrelenie pozycji pocztkowej i kocowej
    start = wsize->xLeft  + 2 + (TitleState & STT_DRAWBUTTON ? CXY_TITLEBUTTON : 0);
    stop  = wsize->xRight - 2 - (TitleState & STT_DRAWCUT    ? CXY_TITLECUT    : 0);

    // Rysowanie podwietlenia
    pos.y = wsize->yTop - 3;
    GpiSetColor(hps, TOOL_FRAMEHILITE);
    for(pos.x = start; pos.x < stop; pos.x += 3)
      GpiSetPel(hps, &pos);
    pos.y = wsize->yTop - 6;
    for(pos.x = start + 1; pos.x < stop; pos.x +=3)
      GpiSetPel(hps, &pos);

    // Rysowanie cienia
    pos.y = wsize->yTop - 4;
    GpiSetColor(hps, TOOL_FRAMEDARK);
    for(pos.x = start + 1; pos.x < stop; pos.x += 3)
      GpiSetPel(hps, &pos);
    pos.y = wsize->yTop - 7;
    for(pos.x = start + 2; pos.x < stop; pos.x += 3)
      GpiSetPel(hps, &pos);
  }
  else
  {  // Pasek w pooeniu pionowym
     // Okrelenie pozycji pocztkowej i kocowej
     start = wsize->yTop    - 3 - (TitleState & STT_DRAWBUTTON ? CXY_TITLEBUTTON : 0);
     stop  = wsize->yBottom + 1 + (TitleState & STT_DRAWCUT    ? CXY_TITLECUT    : 0);

     // Rysowanie podwietlenia
     pos.x = wsize->xLeft + 2;
     GpiSetColor(hps, TOOL_FRAMEHILITE);
     for(pos.y = start; pos.y > stop; pos.y -= 3)
       GpiSetPel(hps, &pos);
     pos.x = wsize->xLeft + 5;
     for(pos.y = start - 1; pos.y > stop; pos.y -= 3)
       GpiSetPel(hps, &pos);

     // Rysowanie cienia
     pos.x = wsize->xLeft + 3;
     GpiSetColor(hps, TOOL_FRAMEDARK);
     for(pos.y = start - 1; pos.y > stop; pos.y -= 3)
       GpiSetPel(hps, &pos);
     pos.x = wsize->xLeft + 6;
     for(pos.y = start - 2; pos.y > stop; pos.y -= 3)
       GpiSetPel(hps, &pos);
  }
}




// Rysowanie obramowania paska tytuu
//
// Parametry:
//   hps       - [parametr] uchwyt presentation space
//   wsize     - [parametr] rozmiary okna
//
static VOID DrawTitleFrame(HPS hps, RECTL *wsize, ULONG TitleState)
{ POINTL pos;       // Wsprzdne oglnego przeznaczenia

  // Rysowanie owietlenia
  GpiSetColor(hps, TOOL_FRAMEHILITE);
  pos.y = /*TitleState & STT_ROTATED ?*/ wsize->yBottom /*: wsize->yBottom + 1*/;
  pos.x = wsize->xLeft;      GpiMove(hps, &pos);
  pos.y = wsize->yTop - 1;   GpiLine(hps, &pos);
  pos.x = TitleState & STT_ROTATED ? wsize->xRight - 2  : wsize->xRight - 1;
  GpiLine(hps, &pos);

  // Rysowanie cienia
  GpiSetColor(hps, TOOL_FRAMEDARK);
  // Pocztek dolnego obramowania
  pos.x =/* TitleState & STT_ROTATED ?*/ wsize->xLeft + 1 /*: wsize->xLeft*/;
  pos.y = wsize->yBottom;  GpiMove(hps, &pos);
  // Koniec dolnego obramowania
  pos.x = TitleState & STT_DRAWCUT ? wsize->xRight - 1 - CXY_TITLECUT : wsize->xRight - 1;
  GpiLine(hps, &pos);

  // Rysowanie ukonego wycicia
  if(TitleState & STT_DRAWCUT)
  { pos.x = wsize->xRight - 1;
    pos.y = wsize->yBottom + CXY_TITLECUT;
    GpiLine(hps, &pos);
    // Rysowanie pogrubienia
    pos.x = wsize->xRight - CXY_TITLECUT;
    pos.y = wsize->yBottom;
    GpiMove(hps, &pos);
    pos.x = wsize->xRight - 1;
    pos.y = wsize->yBottom + CXY_TITLECUT - 1;
    GpiLine(hps, &pos);
  }

  // Rysowanie prawej krawdzi
  pos.y = TitleState & STT_ROTATED ? wsize->yTop - 1 : wsize->yTop - 2;
  GpiLine(hps, &pos);

  // Rysowanie ta pod wyciciem
  if(TitleState & STT_DRAWCUT)
  { POLYGON poly;        // Struktura zawirajca punkty wielokta
    POINTL  ptl[2];      // Punkty wielokta

    GpiSetColor(hps, TOOL_BACKGROUND);
    // Okrelenie punktw wielokta
    ptl[0].x = wsize->xRight - CXY_TITLECUT + 1;
    ptl[0].y = wsize->yBottom;
    ptl[1].x = wsize->xRight - 1;
    ptl[1].y = wsize->yBottom + CXY_TITLECUT - 2;
    // Inicjacja struktury kontrolnej wielokta
    poly.ulPoints = 2;
    poly.aPointl  = ptl;
    // Punkt startowy
    pos.x = wsize->xRight - 1;
    pos.y = wsize->yBottom;
    GpiMove(hps, &pos);
    // Rysowanie wielokta
    GpiPolygons(hps, 1, &poly, 0L, POLYGON_INCL);
  }
}



/*
 * $Log: tcontrol.c $
 * Revision 1.1  1999/06/27 12:35:51  Wojciech_Gazda
 * Initial revision
 *
 */
