/* --------------------------------------------------------------------------
 axPMUndoc.h : undocumented OS/2 APIs and defintions.

 31 May 2006 - Alessandro Felice Cantatore

- Notes : ----------------------------------------------------------------
- Contents: --------------------------------------------------------------
 - window styles
 - PM messages
 - WinQuery/SetSysValue flags
 - WinDrawBorder flags
 - Full window drag API.
-------------------------------------------------------------------------- */

#ifndef _AXPMUNDOC_H_
   #define _AXPMUNDOC_H_

/* ---------------------------------------------------------------------------
 window styles
*/
#ifndef WS_TOPMOST
  #define WS_TOPMOST  0x00200000
#endif


/* ---------------------------------------------------------------------------
 PM messages
*/

/*
 Mouse messages.
 These messages are generated by Warp 4 and superior versions
 These messages are posted to a window when the mouse pointer enters
 or leaves the window rectangle.
 The default window procedure returns FALSE in both cases.

 mouse getting inside the window area
 mp1 : handle of the window the mouse is moving to
 mp2 : handle of the window previously under the mouse
*/
#define WM_MOUSEENTER      0x041e

/*
 mouse getting outside the window area
 mp1 : handle of the window the mouse is moving away from
 mp2 : handle of the window the mouse is moving to
*/
#define WM_MOUSEEXIT       0x041f    // mouse leaving the window area


/* ---------------------------------------------------------------------------
 WinQuery/SetSysValue flags
*/
#define SV_FULLWINDOWDRAG          99      /* FullWindowDrag            */
#define SV_ALTTABSWITCHWIN        100      /* Alt-Tab Switching windows */
#define SV_VIOMOUSEACTIONS        101      /* VIO mouse actions         */
#define SV_ASYNCFOCUSCHANGE       102      /* Asynchronus focus change  */
#define SV_FOCUSCHANGESENS        103      /* Focus Change sensivity    */


/* ---------------------------------------------------------------------------
 WinDrawBorder flags
*/
// Draw a 3-d border giving the window a raised appearance.
#define DB_RAISED    0x0400
// Draw a 3-d border giving the window a sunken appearance.
#define DB_DEPRESSED 0x0800


/* ---------------------------------------------------------------------------
 Full window drag API.
 This function is similar to WinTrackRect(), but it drags a solid window
 rather than just a frame of the window.
 Parameters:
 HWND hwnd      : window to be dragged (sized or moved).
 PTRACKINFO pti : window tracking options (see the Presentation Manager
                  Programming Guide and Reference for more details).
*/
#pragma import(WinTrackWindow,,"PMMERGE.DLL", 5466)
BOOL APIENTRY WinTrackWindow(HWND hwnd, PTRACKINFO pti);



/* ---------------------------------------------------------------------------

*/
/* ---------------------------------------------------------------------------

*/
/* ---------------------------------------------------------------------------

*/
/* ---------------------------------------------------------------------------

*/
/* ---------------------------------------------------------------------------

*/
/* ---------------------------------------------------------------------------

*/
/* ---------------------------------------------------------------------------

*/
/* ---------------------------------------------------------------------------

*/
/* ---------------------------------------------------------------------------

*/

#endif // #ifndef _AXPMUNDOC_H_