/*
 * scat.c -- This is where we define the Scat external function.
 *           It takes a single parm... if '1', all the windows
 *           are moved off the screen, if '0', they're all brought
 *           back....
 */

#include <stddef.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#define INCL_DOS
#define INCL_REXXSAA
#define INCL_PM

#include <os2.h>
#include <rexxsaa.h>

#include "llist.h"

typedef struct {
    llist_link  link;
    HWND        hWnd;
} WINENTRY, *PWINENTRY;

static llist_header WindowList = { NULL, NULL };
static BOOL         InitDone = FALSE;
static HAB          Anchor = 0;
static HMQ          Queue = 0;

void ScatWindows( void );
void UnscatWindows( void );

/*
 * RXScat -- This is the function that REXX calls when the 'Scat'
 *           function is encountered...
 */

ULONG APIENTRY RXScat( PUCHAR funcname, ULONG numargs, PRXSTRING args,
                       PSZ queuename, PRXSTRING result )
  {
    char ch;

    /* Get rid of warnings... */

    funcname = funcname;
    queuename = queuename;

    /* Check number of args... we only want one! */

    if( numargs != 1 ) goto syntax_error;

    /* OK, make sure it's a boolean value... */

    if( args[0].strptr == NULL || args[0].strlength == 0 ) goto syntax_error;

    ch = args[0].strptr[0];
    if( ch != '1' && ch != '0' ) goto syntax_error;

    /* OK, call our C functions accordingly... */

    if( ch == '1' ){
        ScatWindows();
    } else {
        UnscatWindows();
    }

    /* Always return '1' */

    result->strptr[0] = '1';
    result->strlength = 1;

    return( 0 );

  syntax_error:
    return( 40 );
  }

/*
 * Init -- Initialize things and make sure a message queue exists...
 */

void Init( void )
  {
    MQINFO mqinfo;
    BOOL   has_queue;

    if( !InitDone ){
        LListNew( &WindowList );

        has_queue = WinQueryQueueInfo( HMQ_CURRENT, &mqinfo, sizeof( MQINFO ) );
        if( !has_queue ){
            Anchor = WinInitialize( 0 );
            Queue = WinCreateMsgQueue( Anchor, 0 );

            WinCancelShutdown( Queue, TRUE );
        }

        InitDone = TRUE;
    }
  }

/*
 * ScatWindows -- Scat the windows off the screen...
 */

void ScatWindows( void )
  {
    HENUM      henum;
    HWND       hWnd;
    PPIB       pib;
    PTIB       tib;
    PID        pid;
    TID        tid;
    PWINENTRY  wentry;

    DosGetInfoBlocks( &tib, &pib );

    Init();

    if( LLFirst( &WindowList ) != NULL ){
        UnscatWindows();
    }

    /* Get the list of all top-level windows... ignore any with our
       process id or the desktop window... */

    henum = WinBeginEnumWindows( HWND_DESKTOP );

    while( ( hWnd = WinGetNextWindow( henum ) ) != NULLHANDLE ){
        WinQueryWindowProcess( hWnd, &pid, &tid );

        if( pid == pib->pib_ulpid ) continue;
        if( !WinIsWindowVisible( hWnd ) ) continue;
        if( WinQueryWindow( hWnd, QW_OWNER ) != NULLHANDLE ) continue;
        if( WinQueryWindow( hWnd, QW_NEXT ) == NULLHANDLE ) continue;

        wentry = malloc( sizeof( *wentry ) );
        if( wentry ){
            wentry->hWnd = hWnd;
            LListSuffix( &WindowList, wentry );
        }
    }

    WinEndEnumWindows( henum );

    /* Now go through the list of windows in reverse order and
       hide them... this minimizes painting... */

    for( wentry = LLLast( &WindowList ); wentry != NULL;
         wentry = LLPrev( wentry ) ){
        WinShowWindow( wentry->hWnd, FALSE );
    }
  }

/*
 * UnscatWindows -- Undo the scat...
 */

void UnscatWindows( void )
  {
    PWINENTRY  wentry;

    Init();

    for( wentry = LLLast( &WindowList ); wentry != NULL;
         wentry = LLLast( &WindowList ) ){

        if( WinIsWindow( Anchor, wentry->hWnd ) ){
            WinShowWindow( wentry->hWnd, TRUE );
            WinInvalidateRect( wentry->hWnd, NULLHANDLE, TRUE );
        }

        LListDelete( &WindowList, wentry );
        free( wentry );
    }
  }
