/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         __VXREXX____APPENDS__
*/
__VXREXX____APPENDS__:
/*
*/
return
/*:VRX         Fini
*/
Fini: procedure expose Globals.
    call WPFini

    window = VRWindow()
    parent = VRGet( window, "Parent" )
    if VRGet( window, "Visible" ) then do
        left = VRGet( window, "Left" ) - VRGet( parent, "Left" )
        top = VRGet( window, "Top" ) - VRGet( parent, "Top" )
        call IniMgr "Set", "ReportLeft", left
        call IniMgr "Set", "ReportTop", top
        call VRSet window, "Visible", 0
    end

    ReportFiniDone = 1
    call VRMethod "Application", "PutVar", "ReportFiniDone"

return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init: procedure expose Globals.
    window = VRWindow()
    parent = VRGet( window, "Parent" )
    left = IniMgr( "Get", "ReportLeft" )
    top = IniMgr( "Get", "ReportTop" )
    if left \= "" & top \= "" then do
        left = left + VRGet( parent, "Left" )
        top = top + VRGet( parent, "Top" )
        call VRSet window, "Left", left, "Top", top
    end
    self = VRGet( window, "Self" )
    call VRMethod "Application", "PutVar", "self", "ReportStatusWindow"

    Globals. = ""
    call WPConfig

    ReportThreadStarted = 1
    call VRMethod "Application", "PutVar", "ReportThreadStarted"
return

/*:VRX         Main
*/
/*
    ok = DDEExecB( dde, cmnd [,wait] )

    - Adds "[" and "]" to the command before executing it.
*/
DDEExecB:
    parse arg dde, cmnd, wait
    ok = DDEExec( dde, "[" || cmnd || "]", wait )
return ok


/* End of included file */

/* Including file 'shared\ddewaitt.vrs' */

/*:VRX         PinkSlip
*/
PinkSlip: procedure expose Globals.
    parse arg name, print

    ok = WPInit()
    if \ok then signal PinkSlipDone

    ok = WPDocInit()
    if \ok then signal PinkSlipDone

    nl = "0D0A"x
    call WPDocType  "Dear" Name || ":" || nl ||,
                    "    You're fired." || nl ||,
                    "Sincerely," || nl ||,
                    "    The Management."

    if print = 1 then do
        call WPDocPrint
    end
    else do
    /*
        state = VRGet( Globals.!WPHWnd, "WindowState" )
        if state \= "Minimized" then do
            call SysSleep 3
        end
    */
    end

    call WPDocFini

    /* The following is used to keep the testing program in sync.
    */
    call VRMethod "Application", "GetVar", "ReportPinkSlipDone"
    if DataType( ReportPinkSlipDone, "N" ) then do
        ReportPinkSlipDone = ReportPinkSlipDone + 1
        call VRMethod "Application", "PutVar", "ReportPinkSlipDone"
    end

PinkSlipDone:

return
/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Restart
*/
Restart: procedure expose Globals.
    call WPFini

    Globals. = ""
    call WPConfig

    ReportRestartDone = 1
    call VRMethod "Application", "PutVar", "ReportRestartDone"
return

/*:VRX         ShowWindow
*/
ShowWindow: procedure expose Globals.
    window = "W_Reports"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate" 
return

/*:VRX         W_Reports_Close
*/
W_Reports_Close:
    call VRSet "W_Reports", "Visible", 0
return

/*:VRX         WPConfig
*/
/*  
    ok = WPConfig()    
*/
WPConfig: procedure expose Globals.

    wpConfigOK = 0

    Globals.!WP = IniMgr( "Get", "Wordprocessor" )
    Globals.!WPHome = VRGet( "Application", "WorkingDirectory" )
    Globals.!WPPath = ""

    if Globals.!WP = "" then signal WPConfigDone

    interpret "ok = WPConfig_" || Globals.!WP || "()"
    if \ok then do  
        Globals.!WP = ""
        signal WPConfigDone
    end
    
    wpConfigOK = 1
    
wpConfigDone:
return wpConfigOK

/*:VRX         WPConfig_AmiPro
*/
WPConfig_AmiPro: procedure expose Globals.
    Globals.!WPPath = CfgPath( "Ami Pro", "AmiPro.EXE", "AmiProPath" )
return Globals.!WPPath \= ""

/*:VRX         WPConfig_AmiProWin
*/
WPConfig_AmiProWin: procedure expose Globals.
    Globals.!WPPath = CfgPath( "Ami Pro for Windows", "AmiPro.EXE", "AmiProWInPath" )
return Globals.!WPPath \= ""

/*:VRX         WPConfig_DeScribe
*/
WPConfig_DeScribe: procedure expose Globals.
    Globals.!WPPath = CfgPath( "DeScribe", "DeScribe.EXE", "DeScribePath" )
return Globals.!WPPath \= ""

/*:VRX         WPConfig_WordWin
*/
WPConfig_WordWin: procedure expose Globals.
    Globals.!WPPath = CfgPath( "Word for Windows", "WinWord.EXE", "WordWinPath" )
return Globals.!WPPath \= ""

/*:VRX         WPDocFini
*/
WPDocFini: procedure expose GLobals.
    interpret "call WPDocFini_" || Globals.!WP
return

/*:VRX         WPDocFini_AmiPro
*/
WPDocFini_AmiPro: procedure expose Globals.
    WPCtrl = "DDEC_WPCtrl"
    WPData = "DDEC_WPData"

/*  No ack is returned after closing the connection nor is the 
    connection terminated.
*/
    call DDEExecB WPData, "FileChanged( 1, 0)"
    call DDEExecB WPData, "FileClose", "N"
    call VRMethod WPData, "Terminate", "Wait", 5

    call VRMethod WPCtrl, "Terminate", "Wait", 5
return

/*:VRX         WPDocFini_AmiProWin
*/
WPDocFini_AmiProWin: procedure expose Globals.
    WPCtrl = "DDEC_WPCtrl"
    WPData = "DDEC_WPData"

/*  Ami Pro for Windows sends the ack before terminating the conversation
    after a FileClose so wait for it.
*/
    call DDEExecB WPData, "FileChanged( 1, 0)"
    call DDEExecB WPData, "FileClose"
    call VRMethod WPData, "Terminate", "Wait", 5

    call VRMethod WPCtrl, "Terminate", "Wait", 5
return

/*:VRX         WPDocFini_DeScribe
*/
WPDocFini_DeScribe: procedure expose Globals.
    WPCtrl = "DDEC_WPCtrl"
    WPData = "DDEC_WPData"

/*  Closing the file terminates the connection so don't wait for an
    ack after the DDE execute, instead wait for the conversation to
    terminate.
*/
    file = Globals.!WPHome || "\PinkSlip.DSC"
    call DDEExecB WPData, 'Close("' || file || '")', "N"
    call DDEWaitT WPData, 5

    call VRMethod WPCtrl, "Terminate", "Wait", 5
return

/*:VRX         WPDocFini_WordWin
*/
WPDocFini_WordWin: procedure expose Globals.
    WPCtrl = "DDEC_WPCtrl"
    WPData = "DDEC_WPData"

    call VRMethod WPData, "Terminate", "Wait", 5

    call DDEExecB WPCtrl, "FileClose 2"
    call VRMethod WPCtrl, "Terminate", "Wait", 5
return

/*:VRX         WPDocInit
*/
WPDocInit: procedure expose Globals.
    interpret "ok = WPDocInit_" || Globals.!WP || "()"
return ok 

/*:VRX         WPDocInit_AmiPro
*/
WPDocInit_AmiPro: procedure expose Globals.

    ok = 0

    WPCtrl = "DDEC_WPCtrl"
    WPData = "DDEC_WPData"

    call Status "Connecting to Ami Pro"
    ok = DDEInit( WPCtrl, "AmiPro", "System" )
    if \ok then signal WPDocInit_AmiPro_Done

    /*  Make sure the SAM file is R/W (an Ami Pro crash will leave it R/O).
    */
    file = Globals.!WPHome || "\data\PinkSlip.SAM"
    call VRChAttr file, "", "R"

    call Status "Loading document" file
    call DDEExecB WPCtrl, 'FileOpen( "' || file || '", 1, "")'

    /*  Establish a conversation with the document
    */
    call Status "Connecting to" file
    ok = DDEInit( WPData, "AmiPro", file )
    if \ok then signal WPDocInit_AmiPro_Done

    ok = 1

WPDocInit_AmiPro_Done:

    call Status ""

return ok


/*:VRX         WPDocInit_AmiProWin
*/
WPDocInit_AmiProWin: procedure expose Globals.
    ok = WPDocInit_AmiPro()
return ok

/*:VRX         WPDocInit_DeScribe
*/
WPDocInit_DeScribe: procedure expose Globals.

    ok = 0

    WPCtrl = "DDEC_WPCtrl"
    WPData = "DDEC_WPData"

    call Status "Connecting to DeScribe"
    ok = DDEInit( WPCtrl, "DeScribe", "System" )
    if \ok then signal WPDocInit_DeScribe_Done

    file = Globals.!WPHome || "\data\PinkSlip.DSC"
    call Status "Loading document" file
    call DDEExecB WPCtrl, 'Open("' || file || '")'    

    /*  Establish a conversation with the document
    */
    call Status "Connecting to" file
    ok = DDEInit( WPData, "DeScribe", file )
    if \ok then signal WPDocInit_DeScribe_Done

    ok = 1

WPDocInit_DeScribe_Done:

    call Status ""

return ok


/*:VRX         WPDocInit_WordWin
*/
WPDocInit_WordWin: procedure expose Globals.

    ok = 0

    WPCtrl = "DDEC_WPCtrl"
    WPData = "DDEC_WPData"

    call Status "Connecting to Word for Windows"
    ok = DDEInit( WPCtrl, "WinWord", "System" )
    if \ok then signal WPDocInit_WordWin_Done

    file = Globals.!WPHome || "\data\PinkSlip.DOC"
    call Status "Loading document" file
    call DDEExecB WPCtrl, 'ChDir "' || Globals.!WPHome || '"'
    call DDEExecB WPCtrl, 'FileOpen .Name = "data\pinkslip.doc", .ReadOnly = 0, .PasswordDoc = "", .PasswordDot = ""'

    /*  Establish a conversation with the document
    */
    call Status "Connecting to" file
    ok = DDEInit( WPData, "WinWord", file )
    if \ok then signal WPDocInit_WordWin_Done

    /* Move to correct position to start typing
    */
    call DDEExecB WPData, 'LineDown 2'

    ok = 1

WPDocInit_WordWin_Done:

    call Status ""

return ok

/*:VRX         WPDocPrint
*/
WPDocPrint: procedure expose Globals.
    interpret "call WPDocPrint_" || Globals.!WP
return

/*:VRX         WPDocPrint_AmiPro
*/
WPDocPrint_AmiPro:
    call DDEExecB "DDEC_WPData", "FilePrint( 1, 1, 999, 1537 )"
return

/*:VRX         WPDocPrint_AmiProWIn
*/
WPDocPrint_AmiProWIn: procedure expose Globals.
    call WPDocPrint_AmiPro
return

/*:VRX         WPDocPrint_DeScribe
*/
/*  
    call WPDocPrint_Describe file

    - The DDE Print command causes a "Print Options" dialog to appear.
    {Alt}P starts the print.
*/
WPDocPrint_DeScribe: procedure expose Globals.
    file = Globals.!WPHome || "\PinkSlip.DSC"
    call DDEExecB "DDEC_WPData", 'Print("' || file || '")'
    call SendKeys "Print Options", "{Alt}P", 10
return

/*:VRX         WPDocPrint_WordWin
*/
WPDocPrint_WordWin:
    cmd = 'FilePrint .Type = 0, .NumCopies = "1", .Range = 0, .From = "", .To = "", .PrintToFile = 0, .Collate = 1, .FileName = ""'
    call DDEExecB "DDEC_WPData", cmd
return

/*:VRX         WPDocType
*/
WPDocType: procedure expose Globals.
    parse arg string
    interpret "call WPDocType_" || Globals.!WP "string"
return

/*:VRX         WPDocType_AmiPro
*/
WPDocType_AmiPro: procedure expose Globals.
    parse arg text
    WPData = "DDEC_WPData"
    do forever
        parse VAR text line "0D0A"x text
        if line = "" then leave
        call DDEExecB WPData, 'Type("' || line || '[Enter]")'
    end
return

/*:VRX         WPDocType_AmiProWin
*/
WPDocType_AmiProWin: procedure expose Globals.
    parse arg text
    call WPDocType_AmiPro text
return

/*:VRX         WPDocType_DeScribe
*/
WPDocType_DeScribe: procedure expose Globals.
    parse arg text
    WPData = "DDEC_WPData"
    call VRMethod WPData, "Poke", "Text", text
return

/*:VRX         WPDocType_WordWin
*/
WPDocType_WordWin: procedure expose Globals.
    parse arg text
    WPData = "DDEC_WPData"
    do forever
        parse VAR text line "0D0A"x text
        if line = "" then leave
        call DDEExecB WPData, 'Insert "' || line || '"'
        call DDEExecB WPData, 'InsertPara'
    end
return

/*:VRX         WPFini
*/
WPFini: procedure expose Globals.
    ok = 0
    
    if GLobals.!WP = "" then do
        ok = 1
        signal WPFiniDone
    end

    if \VRIsValidObject( Globals.!WPHWnd ) then do
        ok = 1
        signal WPFiniDone
    end

    if Globals.!WPShutDown \= 1 then do
        ok = 1
        signal WPFiniDone
    end

    interpret "ok = WPFini_" || Globals.!WP || "()"

WPFiniDone:
return ok


/*:VRX         WPFini_AmiPro
*/
WPFini_AmiPro: procedure expose Globals.

    ok = 0

    WPCtrl = "DDEC_WPCtrl"

    /*  Make sure we (still) have a DDE connection
    */
    ok = DDEInit( WPCtrl, "AmiPro", "System" )
    if \ok then signal WPFini_AmiPro_Done

    /*  Shut down
        - We don't get an ack to the AppClose, but it does not
        terminate the connection either.
    */
    caption = VRGet( Globals.!WPHWnd, "Caption" )
    call DDEExecB WPCtrl, 'AppClose("' || caption || '")', "N"
    call VRMethod WPCtrl, "Terminate", "Wait", 5

    call TestWait "Closing Ami Pro", 5

    ok = 1

WPFini_AmiPro_Done:

return ok

/*:VRX         WPFini_AmiProWIn
*/
WPFini_AmiProWIn: procedure expose Globals.
    ok = WPFini_AmiPro()
return ok

/*:VRX         WPFini_DeScribe
*/
/*
    call WPFini_Describe

    - There is no direct way to shutdown describe via DDE, so we activate the 
    Describe window and use {Alt}{F4} instead.
*/
WPFini_DeScribe: procedure expose Globals.

    ok = 0

    if \VRIsValidObject( Globals.!WPHWnd ) then signal WPFini_Describe_Done

    WPCtrl = "DDEC_WPCtrl"
    call DDEExecB WPCtrl, 'Close'
    call VRMethod WPCtrl, "Terminate", "Wait", 5

    call VRMethod Globals.!WPHWnd, "Restore"
    call VRMethod Globals.!WPHWnd, "Activate"
/*    call SendKeys "DeScribe", "{Alt}{F4}", 10
*/
    call TestWait "Closing DeScribe", 5

    ok = 1

WPFini_DeScribe_Done:

return ok

/*:VRX         WPFini_WordWin
*/
WPFini_WordWin: procedure expose Globals.

    ok = 0

    WPCtrl = "DDEC_WPCtrl"

    /*  Make sure we (still) have a DDE connection
    */
    ok = DDEInit( WPCtrl, "WinWord", "System" )
    if \ok then signal WPFini_WordWin_Done

    /*  Shut down
    */
    call DDEExecB WPCtrl, 'FileExit'
    call VRMethod WPCtrl, "Terminate", "Wait", 5

    call TestWait "Closing Word", 5

    ok = 1

WPFini_WordWin_Done:

return ok


/*:VRX         WPInit
*/
/*
    ok = WPInit()

    - Start the word processor and connect to it
*/
WPInit: procedure expose Globals.
    wpInitOK = 0

    if Globals.!WP = "" then do
        ok = WPConfig()
        if \ok then do
            signal WPInitDone
        end
    end

    if VRIsValidObject( Globals.!WPHWnd ) then do
        wpInitOK = 1
        signal WPInitDone
    end
    Globals.!WPHwnd = ""

    interpret "ret = WPInit_" || Globals.!WP || "()"

    parse VAR ret hWnd ";" new
    if hWnd = "" then do
        call Error "Unable to start the word processor."
        signal WPInitDone
    end

    call VRMethod hWnd, "Restore"
    call WinPos hWnd, "Bottom", "Right"

    Globals.!WPHWnd = hWnd
    if new = "NEW" then do
        Globals.!WPShutDown = 1
    end

    wpInitOK = 1

WPInitDone:

    call Status ""

return wpInitOK

/*:VRX         WPInit_AmiPro
*/
WPInit_AmiPro: procedure expose Globals.
    call Status "Starting Ami Pro"
    ret = RunProg( Globals.!WPPath || "\" || "AMIPRO.EXE", "Lotus Ami Pro", 30 )
    call Status ""
return ret

/*:VRX         WPInit_AmiProWin
*/
WPInit_AmiProWin: procedure expose Globals.
    call Status "Starting Ami Pro for Windows"
    ret = RunProg( Globals.!WPPath || "\" || "AMIPRO.EXE", "Ami Pro", 60 )
    call Status ""
return ret

/*:VRX         WPInit_DeScribe
*/
WPInit_DeScribe: procedure expose Globals.
    call Status "Starting DeScribe"
    ret = RunProg( Globals.!WPPath || "\" || "DeScribe.EXE", "DeScribe", 30 )
    call Status ""
return ret

/*:VRX         WPInit_WordWin
*/
WPInit_WordWin:
    call Status "Starting Word for Windows"
    ret = RunProg( Globals.!WPPath || "\" || "WinWord.EXE", "Microsoft Word", 60 )
    call Status ""
return ret

/* Including file 'shared\ddeinit.vrs' */

/* Including file 'shared\cfgpath.vrs' */

/* Including file 'shared\ddeinit.vrs' */

/* Including file 'shared\ddeinit.vrs' */

/* Including file 'shared\ddeinit.vrs' */

/* Including file 'shared\ddeinit.vrs' */

