/*:VRX         Main
*/
/*
    ret = RunProg( <path>, <caption>, [<timeout>], [<setup>] )

    - Returns hWnd || ";" || ( "NEW" | "EXISTING" ) or the empty string
    - The setup string must begin with a ";"
    - When starting Windows programs make sure that the program object caption does
    not match the application caption or the search for the application may find
    the wrong window
*/    
Main:
    parse arg path, caption, timeout, setup

    ret = ""

    if timeout = "" then do
        timeout = 60
    end

/*  Check for a copy already running
*/
    hWnd = FindWin( caption )
    if hWnd \= "" then do
        ret = hWnd || ";EXISTING"
        signal RunProgDone
    end

/*  Start a new one
*/
    tmpName = "__" || VRParseFilePath( path, "N" ) || "__"
    tmpObjName = "<" || tmpName || ">"

    ok = SysCreateObject( "WPProgram", tmpName, "<WP_NOWHERE>", ,
                          "OBJECTID=" || tmpObjName || ";EXENAME=" || path || setup, ,
                          "r" )
    if ok \= 1 then signal RunProgDone

    ok = SysSetObjectData( tmpObjName, "OPEN=DEFAULT")
    if ok \= 1 then signal RunProgDone

/*  Wait for it to start
*/
    nTimes = trunc( timeout/3 )
    do nTimes
        hWnd = FindWin( caption )
        if hWnd \= "" then do
            ret = hWnd || ";NEW"
            signal RunProgDone
        end
        call SysSleep 3
    end

RunProgDone:

exit ret

