/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         __VXREXX____APPENDS__
*/
__VXREXX____APPENDS__:
/*
#append ddetools.vrs
*/
return
/*:VRX         AmiPro_Close
*/
AmiPro_Close:
    call Quit
return

/*:VRX         CloseFile
*/
CloseFile: procedure expose Globals.
    call status "Closing File"

    WPCtrl = VRGet( "DDEC_WPCtrl", "Self" )
    WPData = VRGet( "DDEC_WPData", "Self" )

    if \WPRunning() then do
        error = "Word Processor is not running"
        signal CloseFile_error
    end

    if VRGet( WPData, "Status" ) <> "ACTIVE" then do
        error = "No file connection."
        signal CloseFile_error
    end

    success = DDEExecB( WPData, "FileChanged( 1, 0)")
    if word(success,1)<>"Success:" then do
        error = success
        signal CloseFile_error
    end
    
    success = DDEExecB( WPData, "FileClose", "N" )
    if word(success, 1)<>"Success:" then do
        error = success
        signal CloseFile_error
    end

    success = VRMethod( WPData, "Terminate", "Wait", 5 )
    if \success then do
        error = "Could not Terminate data topic"
        signal CloseFile_error
    end

    call status "Closed File"
return 1

  Closefile_error:
    call status error
return 0
/*:VRX         CloseWP
*/
CloseWP:procedure expose Globals.

    call Status "Closing WordProcessor"

    WPCtrl = VRGet( "DDEC_WPCtrl", "Self" )
    WPData = VRGet( "DDEC_WPData", "Self" )

    window = FindWPWin()
    if window="" then do
        error = "No WPRunning"
        signal CloseWP_ok
    end


    /*  Make sure we (still) have a DDE connection
    */
    success = DDEInit( WPCtrl, "AmiPro", "System" )
    if word(success, 1) <> "Success:" then do
        error = success
        signal CloseWP_Error
    end

    /*
     * Close any open documents
     */
    ok = VRMethod( WPData, "Initiate", "conv.", Globals.!WPDDEName )
    NumDocuments = conv.0 -2 /* AmiPro has two "builtin" 
                              * topics: System and RemoteControl
                              */

    do i=1 to NumDocuments
        success = DDEExecB( WPCtrl, "FileClose", "N" )
        /* Sending a FileClose to the system topic
         * closes the "active" file.
         */
        if word(success, 1)<>"Success:" then do
            error = success
            signal CloseFile_error
        end
    end

    /*  Shut down
        - We don't get an ack to the AppClose, but it does not
        terminate the connection either.
    */

    if NumDocuments > 0 then do i=3 to 1 by -1
        call Status "Waiting for files to close"
        call syssleep 1
    end

    caption = VRGet( window, "Caption" )

    success = DDEExecB( WPCtrl, 'AppClose("' || caption || '")', "N" )
    if word( success, 1) <> "Success:" then do
        error = success
        signal CloseWP_Error
    end

    ok = VRMethod( WPCtrl, "Terminate", "Wait", 5 )
    if ok<> 1 then do
        error = "Cannot Terminate connection in 5 seconds"
        signal CloseWP_Error
    end

    call status "Closed WordProcessor"
  CloseWP_ok:
return 1

  CloseWP_Error:
    call status error
return 0
/*:VRX         FindWPWin
*/
FindWPWin: 
    window = VRMethod( "Screen", "FindWindow", Globals.!WPCaption, "Desktop", "Exact","Abbreviation" )
    if window<>"" then 
        if VRGet( window, "Classname" ) <> "WC_FRAME" then window = ""
return window

/*:VRX         Fini
*/
Fini:
    Globals.!WPThreadStarted = 0
    call VRMethod "Application", "PutVar", "Globals.!WPThreadStarted"
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 1
/*:VRX         Globals.
*/
Globals.: 
    /* Dummy Section for documenting Global Variables */
    
/* File Global */
    /* Globals.!WPCaption = Caption of WordProcessor Window*/
                         /* Modified in: InitAmiPro  */
    /* Globals.!WPName = Name of WordProcessor */
                         /* Modified in: InitAmiPro  */
    /* Globals.!Windows = Is this a Windows program? */
                         /* Modified in: InitAmiPro */
    /* Globals.WPDDEName = DDE Server name */
                         /* Modified in: InitAmiPro */

/* Application Global */
    /* Globals.!WpThreadStarted= Is WP thread running?  */
                         /* Modified in: Init, Fini     */
                         /* Used in main thread, not here */
return
/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    call InitAmiPro

    window = VRWindow()
    call VRMethod window, "CenterWindow", "Desktop"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

    Globals.!WPThreadStarted = 1
    call VRMethod "Application", "PutVar", "Globals.!WPThreadStarted"
return
/*:VRX         InitAmiPro
*/
InitAmiPro: 
    Globals.!WPDDEName = "AmiPro"
    Globals.!Windows = ( initargs.0 > 0 ) & (initargs.1 <> "" )

    if Globals.!Windows then Globals.!WPCaption = "Ami Pro"
    else Globals.!WPCaption = "Lotus Ami Pro"

    if Globals.!Windows then Globals.!WPName = "Ami Pro for Windows"
    else Globals.!WPName = "Ami Pro for OS/2"
return

/*:VRX         OpenFile
*/
OpenFile:procedure expose Globals.
    parse arg file
    call Status "Opening File" file "through DDE"

    if \WPRunning() then do
        error = "WordProcessor not running"
        signal OpenFile_Error
    end

    WPCtrl = VRGet( "DDEC_WPCtrl", "Self" )
    WPData = VRGet( "DDEC_WPData", "Self" )


    if \VRFileExists( file ) then do
        error = "Cannot find file" file
        signal OpenFile_Error
    end

    /*  Make sure the SAM file is R/W (an Ami Pro crash will leave it R/O).
    */
    call VRChAttr file, "", "R"

    call Status "Loading document" file

    /*
     * Tell the system topic to load the file
     */
    success = DDEExecB( WPCtrl, 'FileOpen( "' || file || '", 1, "")' )
    if word( success, 1 ) <> "Success:" then do
        error = "System topic cannot open file."
        signal OpenFile_Error
    end

    /*  Establish a conversation with the document
    */
    call Status "Connecting to" file
    success = DDEInit( WPData, Globals.!WPDDEName, file )
    if word( success, 1 ) <> "Success:" then do
        error = "Could not connect to file topic."
        signal OpenFile_Error
    end

    call Status "Connected to" file
return 1

  OpenFile_Error:
    call Status error
return 0
/*:VRX         OpenWP
*/
OpenWP:procedure expose Globals.
    parse arg wpPath
    wp = Globals.!WPName

    call Status "Opening" wp

    if \VRFileExists( wpPath ) then do
        error = wp "not found at:" wpPath
        signal OpenWP_error
    end

    if WPRunning() then do
        error = "Window Already Exists!"
        signal OpenWP_error
    end

    tmpName = "__" || VRParseFilePath( wpPath, "N" ) || "__"
    tmpObjName = "<" || tmpName || ">"

    ok = SysCreateObject( "WPProgram", tmpName, "<WP_NOWHERE>", ,
                          "OBJECTID=" || tmpObjName || ";EXENAME=" || WpPath , ,
                          "r" )
    if ok<>1 then do
        error = "Create failed"
        signal OpenWP_error
    end

    ok = SysSetObjectData( tmpObjName, "OPEN=DEFAULT")
    if ok<>1 then do
        error = "Open failed"
        signal OpenWP_error
    end

    window = ""
    do i = 30 to 0 by -1 while window=""
        call Status "Waiting for" wp "at" wpPath "to open:" i
        call syssleep 2
        window = VRMethod( "Screen", "FindWindow", Globals.!WPcaption, "Desktop")
    end
    if window="" then do
        error = "Window did not open"
        call OpenWP_error
    end

    call Status "Connecting to"  Globals.!WPName 

    WPCtrl = VRGet( "DDEC_WPCtrl", "Self" )

    /*
     * Connect to the "system" topic.  The system topic is the "main" topic.
     */
    success = DDEInit( WPCtrl, Globals.!WPDDEName, "System" )
    if word( success, 1 )<>"Success:" then do
        error = "Cannot connect to System Topic"
        signal OpenFile_Error
    end

    call status "Opened" wp 
return 1

  OpenWP_error:
     call Status error
return 0
/*:VRX         PrintFile
*/
PrintFile: 
    call Status "Printing File"
    call DDEExecB "DDEC_WPData", "FilePrint( 1, 1, 1, 1 )"    
    call Status "Printed File"
return

/*:VRX         Quit
*/
Quit:
    ok = CloseWP()
    if ok then do
        window = VRWindow()
        call VRSet window, "Shutdown", 1
        drop window
    end
return

/*:VRX         SendText
*/
SendText:procedure expose Globals.
    parse arg text
    call Status "Sending Text"

    ddec = VRGet( "DDEC_WPData", "Self" )
    do forever
        parse VAR text line "0D0A"x text

        if line = "" & text = "" then leave

        success = DDEExecB( ddec, 'Type("' || line || '[Enter]")' )

        if word( success, 1) <> "Success:" then do
            error = "Error sending text."
            signal SendText_Error
        end

    end

    call status "Sent Text"
return 1

  SendText_Error:
    call status error
return 0
/*:VRX         Status
*/
Status: 
    call VRSet "DT_1", "Caption", arg(1)
return

/*:VRX         WPRunning
*/
WPRunning:procedure expose Globals.
return FindWPWin()<>"" 
