/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         DDCB_1_Change
*/
DDCB_1_Change: 
    wp = VRGet( VRInfo( "O" ), "Value" )
    call setup wp
return

/*:VRX         Fini
*/
Fini:
    call SaveIni
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         GetEXEFile
*/
GetEXEFile:procedure expose Globals.
    parse arg file
    if file="" then file = "*.exe"

    do while \VRFileExists( file ) & file<>""
        file = VRFileDialog( VRWindow(), "WordProcessor Executable File", "O", file )
    end
return file

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    call LoadFuncs
    Globals.!IniFile = VRParseFileName( VRGet( "Application", "Program" ), "DPN" ) || ".ini"
    if Globals.!IniFile = ".ini" then Globals.!Inifile = "WordProc.ini"
    call LoadIni
    call setup VRGet( "DDCB_1", "Value" )

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Top", 0
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         LoadFuncs
*/
LoadFuncs: 
    call RXFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
    call SysLoadFuncs
return

/*:VRX         LoadIni
*/
LoadIni:procedure expose Globals.
    /*
     * Store the EXEFile location for the WPs
     */
    call VRMethod "DDCB_1", "GetStringList", "list."
    do i=1 to list.0
        wp = list.i
        Globals.wp.!EXEFile = VRGetIni( "WordProc","Globals."wp".!EXEFile", Globals.!Inifile, "NoClose" )
    end
return

/*:VRX         PB_1_Click
*/
PB_1_Click: 
    wp = Globals.!WP
    Globals.wp.!EXEFile = GetExeFile()
return

/*:VRX         PB_Close_File_Click
*/
PB_Close_File_Click: 
    call VRMethod "Application", "GetVar", "Globals.!WPThreadStarted"

    if Globals.!WPThreadStarted<>1 then do
        call VRMessage VRWindow(), "Wordprocessor thread not started", "No WP Thread", "E"
        signal PB_Close_File_Click_Error
    end

    if VRGet( "DDEC_WPData", "Status" )<>"ACTIVE" then do
         call VRMessage VRWindow(), "No file open or no connection made."
         signal PB_Close_File_Click_Error
    end

    call VRMethod "Application", "PostQueue", Globals.!WPThread ,0, "Call CloseFile '"file"'"

   PB_Close_File_Click_Error:

    call VRSet "PB_Send_Text", "Enabled", 0
    call VRSet "PB_Print_File", "Enabled", 0
    call VRSet "PB_Open_File", "Enabled", 1
    call VRSet "PB_Close_File", "Enabled", 0

return

/*:VRX         PB_Close_WP_Click
*/
PB_Close_WP_Click: 

    call VRMethod "Application", "GetVar", "Globals.!WPThreadStarted"

    if Globals.!WPThreadStarted<>1 then do
        call VRMessage VRWindow(), "WP Thread not Started", "No WP Thread", "E"
    end
    else do
        call VRMethod "Application", "PostQueue", Globals.!WPThread ,0, "Call Quit"
        call VRSet "PB_Open_WP", "Enabled", 1
        Globals.!WPThreadStarted = 0
        call VRMethod "Application", "PutVar", "Globals.!WPThreadStarted"
    end

    call VRSet "PB_Open_WP", Enabled, 1
    call VRSet "PB_Open_File", Enabled, 0
    call VRSet "PB_Send_Text", Enabled, 0
    call VRSet "PB_Print_File", Enabled, 0
    call VRSet "PB_Close_FIle", Enabled, 0
    call VRSet "PB_Close_WP", Enabled, 0
return

/*:VRX         PB_Open_file_Click
*/
PB_Open_File_Click:
    call VRMethod "Application", "GetVar", "Globals.!WPThreadStarted"
    if Globals.!WPThreadStarted<>1 then do
        call VRMessage VRWindow(), "WP Thread not Started", "No WP Thread", "E"
        signal PB_Open_File_Click_Done
    end;

   file = VRFileDialog(  VRWindow(), "Words to Process", "O", Globals.wp.!files )
   if file="" then signal PB_Open_File_Click_Done

    call VRMethod "Application", "PostQueue", Globals.!WPThread ,0, "Call OpenFile '"file"'"
    call VRSet "PB_Send_Text", "Enabled", 1
    call VRSet "PB_Print_File", "Enabled", 1
    call VRSet "PB_Close_File", "Enabled", 1
    call VRSet "PB_Open_File", "Enabled", 0

PB_Open_File_Click_Done:
return

/*:VRX         PB_Open_WP_Click
*/
PB_Open_WP_Click: 

    wp = Globals.!Wp
    call VRMethod "Application", "GetVar", "Globals.!WPThreadStarted"

    if Globals.!WPThreadStarted<> 1 then do 
        ok = StartWPThread( wp )
    end

    call VRSet "PB_Open_WP", "Enabled", 0
    call VRSet "PB_Open_File", "Enabled", 1
    call VRSet "PB_Close_WP", "Enabled", 1

    call VRMethod "Application", "PostQueue", Globals.!WPThread, 0, "call OpenWP '"Globals.wp.!EXEFile"'"
return
/*:VRX         PB_Print_File_Click
*/
PB_Print_File_Click: 
    call VRMethod "Application", "GetVar", "Globals.!WPThreadStarted"

    if Globals.!WPThreadStarted<>1 then do
        call VRMessage VRWindow(), "Wordprocessor thread not started", "No WP Thread", "E"
        signal PB_Print_File_Click_Error
    end

    if VRGet( "DDEC_WPData", "Status" )<>"ACTIVE" then do
         call VRMessage VRWindow(), "No file open or no connection made."
         signal PB_Print_File_Click_Error
    end

    call VRMethod "Application", "PostQueue", Globals.!WPThread ,0, "Call PrintFile '"file"'"
return 1

   PB_Print_File_Click_Error:
return 0

/*:VRX         PB_Send_Click
*/
PB_Send_Click:
    Globals.!Text = VRGet( "MLE_1", "Value" )
    call VRMethod "Application", "PutVar", "Globals.!Text"
    message = 'call VRMethod "Application", "GetVar", "Globals.!Text"; call SendText Globals.!Text' 
    call VRMethod "Application", "PostQueue", Globals.!WPThread, 0, message

    call VRDestroy "SW_Text"
return 1

PB_Send_Click_Error:
return 0

/*:VRX         PB_Send_Text_Click
*/
PB_Send_Text_Click: 
    call VRMethod "Application", "GetVar", "Globals.!WPThreadStarted"

    if Globals.!WPThreadStarted<>1 then do
        call VRMessage VRWindow(), "Wordprocessor thread not started", "No WP Thread", "E"
        signal PB_Send_Click_Error
    end

    if VRGet( "DDEC_WPData", "Status" )<>"ACTIVE" then do
         call VRMessage VRWindow(), "No file open or no connection made."
         signal PB_Send_Click_Error
    end

    call VRLoadSecondary "SW_Text", "Wait"
return
/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         SaveIni
*/
SaveIni: 
    /*
     * Store the EXEFile location for the WPs
     */
    call VRMethod "DDCB_1", "GetStringList", "list."
    do i=1 to list.0
        wp = list.i
        call VRSetIni "WordProc", "Globals."wp".!EXEFile", Globals.wp.!EXEFile, Globals.!IniFile, "NoClose"
    end
return

/*:VRX         setup
*/
setup:procedure expose Globals.
    parse arg wp

    /*
     * get rid of funny characters
     */
    jump = translate( wp, "__!", ". /" )

    /*    
     * signal destinations should be upper case
     */
    jump = translate( jump )
    signal value translate( "SETUP_"jump )
return
/*:VRX         Setup_AmiPro_For_OS!2
*/
Setup_AmiPro_For_OS!2:
    Globals.!Wp = wp
    Globals.wp.!Files = "*.sam"
    Globals.wp.!WPFile = "amipro"
    Globals.wp.!WPFileArgs = ""
return

/*:VRX         Setup_AmiPro_For_Windows
*/
Setup_AmiPro_For_Windows: 
    Globals.!wp = wp
    Globals.wp.!Files = "*.sam"
    Globals.wp.!WPFile = "Amipro"
    Globals.wp.!WPFileArgs = "windows"
return

/*:VRX         Setup_Describe_5_0_For_OS!2
*/
Setup_Describe_5_0_For_OS!2: 
    Globals.!wp = wp
    Globals.wp.!Files = "*.*"
    Globals.wp.!WPFile = "Describe"
    Globals.wp.!WPFileArgs = "5.0"
return
/*:VRX         Setup_Describe_v__4_0
*/
Setup_Describe_v__4_0: 
    Globals.!wp = wp
    Globals.wp.!Files = "*.dsc"
    Globals.wp.!WPFile = "Describe"
    Globals.wp.!WPFileArgs = "4.0"
return

/*:VRX         Setup_Word_For_Windows
*/
Setup_Word_For_Windows: 
    Globals.!wp = wp
    Globals.wp.!Files = "*.doc"
    Globals.wp.!WPFile = "Winword"
    Globals.wp.!WPFileArgs = ""
return

/*:VRX         StartWPThread
*/
StartWPThread:procedure expose Globals.
    parse arg wp

    if \VRFileExists( Globals.wp.!EXEFile ) then do 
        Globals.wp.!EXEFile = GetEXEFile( VRParseFilePath( Globals.wp.!EXEFile , "NE" ) )
    end

    /*
     * If user chose not to enter a file.
     */
    if Globals.wp.!EXEFile="" then do
        signal StartWPThread_error
    end

    /* 
     * Start the thread
     */
    Globals.!WPThread = VRMethod( "Application", "StartThread", "SUBROUTINE" Globals.wp.!WPFile, VRWindow(), Globals.wp.!WPFileArgs )

    /*
     * Wait for thread to start.
     */
    do i= 1 to 20 until Globals.!WPThreadStarted = 1
        call SysSleep 1
        call VRMethod "Application", "GetVar", "globals.!WPThreadStarted"
    end

return Globals.!WPThreadStarted = 1

StartWPThread_Error:
return 0
/*:VRX         SW_Text_Close
*/
SW_Text_Close: 
    call SW_Text_Fini
return

/*:VRX         SW_Text_Create
*/
SW_Text_Create: 
    call SW_Text_Init
return

/*:VRX         SW_Text_Fini
*/
SW_Text_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_Text_Init
*/
SW_Text_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return


/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

