/*
 * runmacro.c -- Runs a rexx macro.
 */

#include <os2.h>
#include <rexxsaa.h>

BOOL RunMacro( PSZ filename, PCH argstring, ULONG len, PSZ defaddr )
  {
    char     buf[ 256 ];
    RXSTRING arglist[1];
    APIRET   rc;
    RXSTRING result;
    SHORT    retcode;
    ULONG    numargs = 1;

    result.strptr    = buf;
    result.strlength = 256;

    arglist[0].strlength = len;
    arglist[0].strptr    = argstring;

    if( len == 0 && argstring == NULL ){
        numargs = 0;
    }

    if( !defaddr ){
        defaddr = "CMD";
    }

    rc = RexxStart( numargs, arglist, filename, NULL, defaddr, RXCOMMAND,
                    NULL, &retcode, &result );

    if( result.strptr != buf ){
        DosFreeMem( result.strptr );
    }

    return( rc == 0 );
  }
