/* -------------------------------------------------------------------

	Project: Objective C PM library

	Objective-C interface file for the class menuitem

	COPYRIGHT (C), 1995, Thomas Baier
	ALL RIGHTS RESERVED.

	Date:				Rev: 0.1
	1995-Jul-28			___

 */

#ifndef _MENUITEM_H_
#define _MENUITEM_H_

/*====================================================================
                     Interface of class menuitem                      
====================================================================*/
#include <pm/pm.h>

@interface MenuItem : Object
{
  ULONG  pmId;
  char  *title;
  id     subMenu;
}

/* -------------------------- Initialize -------------------------- */
-init;
-initWithId: (ULONG) anId andTitle: (char *) aTitle;
-initWithId: (ULONG) anId andTitle: (char *) aTitle subMenu: aSubMenu;

/* ----------------------------- Free ----------------------------- */
-free;

/* ----------- Methods for access to Instance Variables ----------- */
-setTitle: (char *) aTitle;
-(char *) title;
-setPmId: (ULONG) anId;
-(ULONG) pmId;
-setSubMenu: aSubMenu;
-subMenu;

/* ------------------------ Public methods ------------------------ */

/* ----------------------- Private methods ------------------------ */

/* ---------------------- Archiving methods ----------------------- */
-read: (TypedStream *) aStream;
-write: (TypedStream *) aStream;

@end

#endif
