/*
@echo off
cls
echo.
echo ERROR: You do not have REXX support installed.
echo.
echo Before you can run this install script, you must install REXX support
echo from the 'Selective Install' program object.
echo.
pause
exit
*/

/*
 * Install.CMD
 *
 * Installs PMD 2.0 Demo Edition
 */


TRACE n
signal on HALT
call LoadLibs

/*
 * get the cmd line
 */
parse arg destdir sourcedir

/*
 * find out where this cmd file resides
 */
parse source . . thispgm

if sourcedir = ' ' then do
  sourcedir = substr(thispgm, 1, (length(thispgm) - (length('install.cmd') + 1)));
  say sourcedir
end


/*
 * do the intro screen
 */
call SysCls
say 'Ŀ'
say '                        PMD V.2.0 Installation                       '
say 'Ĵ'
say '                                                                     '
say '   This is the install program for the demo version of PMD           '
say '   version 2.0. It will install the PMD demo files on your hard      '
say '   disk.                                                             '
say '                                                                     '
say '   Please follow through the screens and answer the prompts as       '
say '   they appear.                                                      '
say '                                                                     '
say '   You will be asked for a destination directory. Please choose      '
say '   a destination directory on a drive or partition that has at       '
say '   least 5 MB of free space.                                         '
say '                                                                     '
say '                                                                     '
say '                                                                     '
say '   Press any key to continue, or Ctrl+C to exit.                     '
say ''
'@pause > NUL'

/*
 * Get the destination directory
 */
if destdir = ' ' then do
  call SysCls
  say 'Ŀ'
  say '                        PMD V.2.0 Installation                       '
  say 'Ĵ'
  say '                                                                     '
  say '                                                                     '
  say '       Please enter the name of the directory you wish to            '
  say '       install PMD to, at the prompt below.                          '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say ''
  say '  Directory to install to (Default = C:\PMD): '
  parse pull destdir
  /* if they accepted the default */
  if destdir = ' ' then destdir = 'C:\PMD'
end

if sourcedir = ' ' then do
  thisdir = directory()
  call SysCls
  say 'Ŀ'
  say '                        PMD V.2.0 Installation                       '
  say 'Ĵ'
  say '                                                                     '
  say '                                                                     '
  say '       Please enter the name of the directory where the              '
  say '       installation files are, at the prompt below:                  '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say '                                                                     '
  say ''
  say '  Directory to install from (Default = 'thisdir'): '
  parse pull sourcedir
  /* if they accepted the default */
  if sourcedir = ' ' then do
    sourcedir = thisdir
  end
end

/*
 * is the dest. dir a valid path?
 */
if stream(sourcedir'\install.cmd', 'c', 'query exists') = '' then do
  call SysCls
  say 'Error:'
  say 'Could not verify that the installation files are actually in'
  say 'the directory ' sourcedir '.'
  say ''
  say 'Please re-run this program from the directory where it and the'
  say 'other installation files are stored,'
  say 'or run it and specify <source dir> <dest dir> as arguments.'
  say ''
  say 'Press ENTER to exit:'
  pull MyFinger
  call SysCls
  exit 0
end


/*
 * make sure the source path is good
 */
if substr(sourcedir, length(sourcedir), 1) \= '\' then
  sourcedir = sourcedir||'\'

/*
 * Confirm the user's selections
 */
call SysCls
say 'Ŀ'
say '                     PMD V.2.0 Demo Installation                     '
say 'Ĵ'
say '     PM Designer will be installed using the following settings:     '
say ''
say ''
say '  Source directory: ' sourcedir
say '  Dest. directory: ' destdir
say ''

if(AskYN('Okay to continue') = 0) then do
  say
  say 'Installation cancelled.'
  exit
end

call SysCls
say ''
say 'Installing PMD...'

/*
 * Check the output directory
 */
rc = SysMkDir(destdir)
if rc \= 0 then do
  select
    when rc = 3   then msg = 'Path not found.'
    when rc = 5   then msg = 'Access denied.'
    when rc = 26  then msg = 'Not a DOS disk.'
    when rc = 87  then msg = 'Invalid parameter specified.'
    when rc = 108 then msg = 'Drive Locked.'
    when rc = 206 then msg = 'Filename exceeds range.'
    otherwise msg = 'Unknown error (???)'
  end
  /* if rc==5, it's probably because the directory exists already.  */
  if rc <> 5 then do
    say 'Error creating destination directory. ' msg
    if askNY('Proceed anyway?') = 0 then do
      exit
    end
  end
end

/* Create the required subdirs */
rc = SysMkDir(destdir||'\bin')
rc = SysMkDir(destdir||'\examples')
rc = SysMkDir(destdir||'\vic')
rc = SysMkDir(destdir||'\Projects')
rc = SysMkDir(destdir||'\Projects\Project')

basedir = destdir

say 'Source dir: 'sourcedir
say 'Dest dir: 'basedir

/*
 * Copy the files
 */
say
say 'NOTE:'
say 'If you are installing this program from a floppy disk,'
say 'this process may will take several minutes.'
say ''
say
say 'Install is copying files, please wait...'
call CopyFile 'readme.inf', sourcedir, basedir
call CopyFile 'pmd.ico',   sourcedir, basedir||'\BIN'

say 'Install is unpacking files, please wait...'

'@view.exe '||destdir||'\Readme Introduction'

/*
 * Install the individual archives:
 *
  The archives are .lzh files that have the required directory
  structures stored in them already. They are set up so they
  just have to be unpacked to the base dest. directory.
 */

/*-- unpack the PMDBIN.EXE archive --*/
say 'Unpacking program files...'
command = '@echo y |'||sourcedir||'PMDBASE.EXE /o 'basedir'>NUL'
command

/*-- unpack the VPPGEN.EXE archive --*/
say 'Unpacking the code generator files...'
command = '@echo y |'||sourcedir||'VICGEN.EXE /o 'basedir'>NUL'
command

/*-- unpack the VICBASE.EXE archive --*/
say 'Unpacking the VIC files...'
command = '@echo y |'||sourcedir||'VICBASE.EXE /o 'basedir'\vic>NUL'
command

say 'Unpacking the Example files...'
command = '@echo y |'||sourcedir||'PMDXMP.EXE /o 'basedir'\examples>NUL'
command

/*
 * Create the objects on the desktop
 */
say
say 'Creating the program folder,'
x = SysCreateObject("WPFolder",,
                    "PMD V.2.0 demo edition",,
                    "<WP_DESKTOP>",,
        "OBJECTID=<PMD>;ICONFILE="||destdir||"\BIN\PMD.ICO;OPEN=DEFAULT", "replace")
if x = 0 then do
  say 'Unable to create folder; cancelling.'
  exit
end

say 'Adding the'

say 'ReadMe file,'
x = SysCreateObject("WPProgram",,
                    "Read Me First",,
                    "<PMD>",,
                    "EXENAME=VIEW.EXE;PARAMETERS="||destdir||"\README.INF")

say 'Manual,'
x = SysCreateObject("WPProgram",,
                    "PMD Help",,
                    "<PMD>",,
                    "EXENAME=VIEW.EXE;PARAMETERS="||destdir||"\DOC\PMD.INF")

say 'VICGEN Manual,'
x = SysCreateObject("WPProgram",,
                    "VICGEN Help",,
                    "<PMD>",,
                    "EXENAME=VIEW.EXE;PARAMETERS="||destdir||"\DOC\VICGEN.INF")

say 'VIC Reference,'
x = SysCreateObject("WPProgram",,
                    "VIC Reference",,
                    "<PMD>",,
                    "EXENAME=VIEW.EXE;PARAMETERS="||destdir||"\VIC\VIC.INF")

say 'PM Designer,'
x = SysCreateObject("WPProgram",,
                    "PM Designer",,
                    "<PMD>",,
  "EXENAME="||destdir||"\BIN\PMD.EXE;STARTUPDIR="||destdir"\BIN;ASSOCFILTER=*.APP")

say 'License agreement,'
x = SysCreateObject("WPProgram",,
                    "License Agreement",,
                    "<PMD>",,
  "EXENAME=E.EXE;PARAMETERS="||destdir||"\DOC\LICENSE.TXT")

say 'Problem reporting form,'
x = SysCreateObject("WPProgram",,
                    "Problem report form",,
                    "<PMD>",,
  "EXENAME=E.EXE;PARAMETERS="||destdir||"\DOC\pmdprob.TXT")


say 'Examples folder,'
x = SysCreateObject("WPShadow",,
                   "Examples",,
                   "<PMD>",,
 "SHADOWID="||destdir||"\examples")

say 'Projects folder,'
x = SysCreateObject("WPShadow",,
                    "Projects",,
                    "<PMD>",,
  "SHADOWID="||destdir||"\Projects")

say 'Project template,'
x = SysSetObjectData(destdir||"\Projects\project", "TEMPLATE=YES")
if x = 0 then do
  say 'Unable to set the "TEMPLATE" attribute on the project template.'
  say 'You will have to do this manually...'
  pull confirm
end

/*
 * Create the template .APP file in the Projects\Project folder
 */
templatedir = destdir||"\Projects\Project"
appfile = destdir||"\bin\_default.app "

say 'Creating template files...'
'@copy 'appfile templatedir'\newapp.app'


say 'Creating PMDENV.CMD...'
'@echo SET BOOKSHELF=%BOOKSHELF%;'destdir||'\DOC >> 'destdir||'\bin\pmdenv.cmd'
'@echo SET HELPNDX='destdir||'\BIN\PMDAPI.NDX >> 'destdir||'\bin\pmdenv.cmd'
'@echo SET PATH=%PATH%;'destdir||'\BIN >> 'destdir||'\bin\pmdenv.cmd'

GoodBye:
/*-- exit with a goodbye --*/
say
say 'Done.'
say
say
say 'The PMD demo has been installed on your system.'
say 'Please run the PMDENV.CMD file in the PMD\BIN directory to add the'
say 'relevant PMD variables to your environment settings.'
say
say 'Be sure to read the README file for up-to-date information.'
say

exit

/*----------------------------------------------*/
/*-- FUNCTION:                                --*/
/*-- LoadLibs                                 --*/
/*-- ACTION:                                  --*/
/*-- loads the libraries needed by this REXX  --*/
/*----------------------------------------------*/
LoadLibs:
  if RxFuncQuery('SysLoadFuncs') THEN
  do
    /*-- load the load-function --*/
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    /*-- load the Sys* utilities --*/
    CALL SysLoadFuncs
  end
return

HALT:
  say
  say 'Program cancelled; Interrupted by user.'
  exit

/*-----------------------------------------------------------------------------*/
/*-- CopyFile                                                                --*/
/*-----------------------------------------------------------------------------*/
CopyFile: parse Arg ArgFile2Copy, ArgSourceDir, ArgInstallDir

    Say 'Copying 'ArgSourceDir||ArgFile2Copy' to 'ArgInstallDir||'\'||ArgFile2Copy'...'
    Command = '@Copy 'ArgSourceDir||ArgFile2Copy' 'ArgInstallDir||'\'||ArgFile2Copy' >NUL'
    Command
    if rc \= 0 Then Do
        say 'Error! 'ArgFile2Copy' was not installed properly.'
        pull MyFinger
    End
    Return

/*-----------------------------------------------------------------------------*/
/*-- AskYN: defaults to 'YES'                                                --*/
/*-----------------------------------------------------------------------------*/
AskYN: parse arg argPrompt
  say
  say argPrompt||'(Y/n)?'
  k = SysGetKey('NOECHO')
  if k = 'N' | k = 'n' then return 0
  else return 1

/*-----------------------------------------------------------------------------*/
/*-- AskNY: defaults to 'NO'                                                 --*/
/*-----------------------------------------------------------------------------*/
AskNY: parse arg argPrompt
  say
  say argPrompt||'(y/N)?'
  k = SysGetKey('NOECHO')
  if k = 'Y' | k = 'y' then return 1
  else return 0

/* eof */

