# exceptq-test-wat.mak - Make exceptq-test-wat.exe as OS/2 OpenWatcom VIO c app with standard options
# $Id: $

# FIXME to test wcc386 or wpp386

# 2012-08-30 SHL Baseline - clone from elsewhere
# 2012-09-15 SHL Renames

# Set MAKE=wmake to avoid confusion
# Build with -a to avoid confusion

# Assumes
# set INCLUDE=*;D:\WATCOM\H;D:\TOOLKIT\H
# set LIB=*;D:\TOOLKIT\LIB;;D:\WATCOM\LIB386\OS2;D:\WATCOM\LIB386

# Required environment variables
# WATCOM
# VENDOR
# BUILDVER
# BUILDMACH
# BUILDTIME

# Supported environment variables
# Define DEBUG in environment for debug build
# Define WARN to allow warnings

# Check required environment variables

!ifndef %WATCOM
!error WATCOM not defined
!endif

!ifndef %BUILDTIME
!error BUILDTIME not defined
!endif

!ifndef %BUILDVER
!error BUILDVER not defined
!endif

!ifndef %BUILDMACH
!error BUILDMACH not defined
!endif

!ifndef %VENDOR
!error VENDOR not defined
!endif

.ERASE

.SUFFIXES:
.SUFFIXES: .sys .obj .asm .inc .def .lrf .ref .lst .sym .map .c .cpp .h .lib

NAME = sample2
DESC = OpenWatcom Exceptq Test
EXENAME = exceptq-test-wat
MAKEFILE = exceptq-test-wat.mak

CC = wcc386
#CC = wpp386

!ifndef DEBUG			# if not defined on wmake command line
!ifdef %DEBUG			# if defined in environment
DEBUG = $(%DEBUG)		# use value from environment
!endif
!endif

!ifndef WARN		# if not defined on wmake command line
!ifdef %WARN		# if defined in environment
WARN = $(%WARN)	# use value from environment
!endif
!endif

# wcc/wpp flags
# -bc           console app
# -bd		build target is a Dynamic Link Library (DLL) (see bd)
# -bm           multithread libs
# -bt=os2       target
# -d2           full debug
# -hd           dwarf
# -j		signed char
# -mf           flat
# -of           generate traceable stack frames
# -olinars      optimze loops, inline, e(n)able fp recip, relax (a)lias, reordering, space
# -s            disable stack checks
# -sg	generate calls to grow the stack
# -st           touch stack through SS first
# -wcd14	no reference to symbol
# -wcd726	no reference to formal parameter
# -we		treat warnings as errors
# -wx           max warnings
# -ze           define _cdecl etc.
# -zfp          disable fs use
# -zgp          disable gs use
# -zp4          align 4
# -zq           quiet

# Order dependent flags
!ifdef DEBUG
CFLAGS = -bt=os2 -mf -bm -of -olirs -d2 -s -j -wx -zfp -zgp      -hd

!else
CFLAGS =   -bt=os2 -bm -mf -of -olirs     -s -j -wx -zfp -zgp      -hd
!endif

# Order independent flags
CFLAGS += -zq
CFLAGS += -wcd14 -wcd726

!ifndef WARN
CFLAGS += -we
!endif

LINK = wlink

#################
# Inference rules
#################

.c.obj: .AUTODEPEND $(MAKEFILE)
     $(CC) $(CFLAGS) $*.c

##############
# Object files
##############

# objects built here
OBJS=$(NAME).obj

# objects built elsewhere
EXTRA_OBJS=

# all object files
ALL_OBJS=$(OBJS) $(EXTRA_OBJS)

#############
# Build rules
#############

all: $(EXENAME).exe

# Avoid lost spaces in @%write
FILL = xxxx

$(NAME).lrf: $(MAKEFILE)
   @%write $^@ system os2v2
   @%write $^@ option verbose
   @%write $^@ option cache
   @%write $^@ option caseexact
   @%write $^@ option stack=0x10000
!ifdef DEBUG
    @%write $^@ debug dwarf all
!endif
   @%write $^@ option map
   @%write $^@ op desc '@$#$(%VENDOR):$(%BUILDVER)$#@$#$#1$#$# $(%BUILDTIME) $(FILL:x= ) $(%BUILDMACH)::EN:US:0:U:@@$(DESC)'
   @%write $^@ name $(EXENAME)
   @for %f in ($(ALL_OBJS)) do @%append $^@ file %f
   @%write $^@ library os2386.lib

$(EXENAME).exe: $(OBJS) $(MAKEFILE) $(NAME).lrf
   $(LINK) @$(NAME).lrf

lxlite: $(EXENAME).exe .symbolic
    dir $<
    lxlite -X- -B- $<
    bldlevel $<
    dir $<

distclean: .symbolic
  -del $(NAME).err
  -del $(NAME).lrf
  -del $(NAME).map
  -del $(NAME).mbr
  -del $(NAME).sym
  -del $(OBJS)

clean: distclean .symbolic
  -del $(EXENAME).exe

settings: .SYMBOLIC
  @echo MAKE is $MAKE
  @echo __VERSION__ is $__VERSION__
  @echo MAKEOPTS is $__MAKEOPTS__
  @echo MAKEFILES is $__MAKEFILES__
  @echo __LOADDLL__ is $__LOADDLL__
