// Developer Helper Object Set, (C) 1994 Thomas E. Bednarz, Jr.
//  All rights reserved


#include"applicat.h"
#include<stdlib.h>

TApplication *Application;  
static CHAR MWtitle[]= "Standard Window";


//-------------------------------------------------------------------
//   TApplication
TApplication::TApplication(ULONG resource)
{   
   Application = this;
   Proc = new TProcess;
   fResource = resource;
   if (Proc==NULL)
   {
      WinMessageBox(HWND_DESKTOP,HWND_DESKTOP, 
         (PSZ)"Couldn't create Process Object", 
         (PSZ)"Error!",0, MB_MOVEABLE | MB_CANCEL ); 
      exit(1);
   }
   MainWin=NULL;
}

//-------------------------------------------------------------------
//   init
void TApplication::init(void)
{
   CreateMainWindow();
   if (MainWin!=NULL)
   {
       if (!MainWin->Init(Proc->getAnchorBlock()))
       {
         WinMessageBox(HWND_DESKTOP,HWND_DESKTOP, 
            (PSZ)"Couldn't create Window Frame", 
            (PSZ)"Error!",0, MB_MOVEABLE | MB_CANCEL ); 
       exit(1);
        }
   }
   else
   {
      WinMessageBox(HWND_DESKTOP,HWND_DESKTOP, 
         (PSZ)"Couldn't create Window Object", 
         (PSZ)"Error!",0, MB_MOVEABLE | MB_CANCEL ); 
      exit(1);
   }
}


//-------------------------------------------------------------------
//   run
void TApplication::run(void)
{
   //  Standard message processing loop. WinGetMsg returns FALSE if the  
   //  returned message is WM_QUIT.  Returns TRUE for all other messages 

      while (WinGetMsg(Proc->getAnchorBlock(), &QueMsg, HMODULE(NULL),0,0))
         WinDispatchMsg(Proc->getAnchorBlock(), &QueMsg);

}
 

//-------------------------------------------------------------------
//   done
void TApplication::done(void)
{
   if (MainWin!=NULL)
      delete(MainWin);
   if (Proc!=NULL)
      delete(Proc);
}

//-------------------------------------------------------------------
//   CreateMainWindow
void TApplication::CreateMainWindow(void)
{
   MainWin = new TWindow(MWtitle,DefaultFlags,fResource);
}

//-------------------------------------------------------------------
//   getClassName
const char *TApplication::getClassName(void)
{
   return "TApplication";
}

//-------------------------------------------------------------------
//   getAnchorBlock
HAB TApplication::getAnchorBlock()
{
   return Proc->getAnchorBlock();
}

//-------------------------------------------------------------------
//   getMainWindow
TWinBase *TApplication::getMainWindow(void)
{
   return MainWin;  
}
