/*
 * table.h -  table and other explicit ipfc command strings
 *
 * texi2roff history:
 *             Release 1.0a    August 1988
 *             Release 2.0     January 1990
 *
 * Copyright 1988, 1989, 1990  Beverly A.Erlebacher
 * erlebach@cs.toronto.edu    ...uunet!utai!erlebach
 *
 * texi2ipf history:
 *             Release 1.0     February 1993
 *
 * Modified by Marcus Grber, Fido 2:2402/61.1
 *
 * Modified by Martin "Herbert" Dietze, Email herbert@wiloyee.shnet.org
 *
 */

/*
 * History:
 *
 * $Log: table.h,v $
 * Revision 1.8  1997/02/06 12:45:16  herbert
 * - Added documentation in Texinfo format.
 * - Minor bug fixes.
 *
 * Revision 1.7  1997/01/17 14:53:32  herbert
 * Corrected all the "@def*" commands (for index entries).
 *
 * Revision 1.6  1997/01/15 13:34:18  herbert
 * - Fixed the index entry generating for some @def* commands.
 *
 * Revision 1.5  1997/01/15 12:18:19  herbert
 * - Fixed a bug in eat_first_word() that made the program crash sometimes.
 * - "@ignore" environments will now be handled like real comments.
 *
 * Revision 1.4  1997/01/08 13:19:15  herbert
 * Added file change.log and changed the handling of the @*heading commands.
 * The OS/2 executable texi2ipf.exe will now be part of the archive.
 *
 * Revision 1.3  1996/12/17 15:14:22  herbert
 * Only some cosmetic changes. The code looks still rather ugly to me :-)
 *
 * Revision 1.2  1996/12/17 14:10:00  herbert
 * Added support for pseudo-Texinfo-commands: @ifhtml (ignored) and @ipfline{}
 * (my invention) for putting IPF code into the Texinfo source.
 * Added @macro command to table.h, will be ignored.
 *
 * Revision 1.1.1.1  1996/12/02 12:10:01  herbert
 * Texi2IPF 1.0
 *
 */

#define FONT_MONO ":font facename=Courier size=16x8."
#define EFNT_MONO ":font facename=default size=0x0."

/*
 * miscellaneous commands, described in texi2roff.h
 */
struct misccmds mscmds = { 
    ":userdoc.\n:docprof toc=1234.",    /* init string */
    ":euserdoc.",                       /* end string */
    ":p.",                              /* text paragraph */
    ":li.",                             /* list item */
    ":pd.",                             /* paragraph inside list item */
    "",
    "",
    "\n:h%d%s."                         /* heading */
};

struct tablerecd
  tempframe =   { "","\n","",EFNT_MONO"\n.br\n",FONT_MONO,INPARA },
  temp1stbrac = { "","}",":hp2.","&colon.:ehp2."FONT_MONO,"",INPARA },
  temp1stword = { ""," ",":hp2.","&colon.:ehp2. "FONT_MONO,"",INPARA };


/*
 * Herbert: changed the trbegin fields of the @def* commands and added the 
 *  @shortcontents command. @menu now has the command type MENU.
 */

struct tablerecd mstable[] = {
    {"@",               "",     "@",            "",     "",     ESCAPED},
    {"@&colon.",        "",     "",             "",     "",     ESCAPED},
    {"@&per.",          "",     "&per.",        "",     "",     ESCAPED},
    {"@*",              "",     "\n.br\n",      "",     "",     ESCAPED},
    {"@@",              "",     "@",            "",     "",     ESCAPED},
    {"@Arrow",          "\n",   "->",           "",     "",     CHAR},
    {"@TeX{",           "}",    "TeX",          "",     "",     INPARA},
    {"@afourpaper",     "\n",   "",             "",     "",     DISCARD},
    {"@appendix",       "\n",   "",             "\n",   "",     HEADING1},
    {"@appendixsec",    "\n",   "",             "\n",   "",     HEADING2},
    {"@appendixsection","\n",   "",             "\n",   "",     HEADING2},
    {"@appendixsubsec", "\n",   "",             "\n",   "",     HEADING3},
    {"@appendixsubsubsec","\n", "",             "\n",   "",     HEADING4},
    {"@arrow",          "\n",   "->",           "\n",   "",     CHAR},
    {"@asis",           "\n",   "",             "\n",   "",     PARAGRAPH},
    {"@asis{",          "}",    "",             "",     "",     INPARA},
    {"@author",         "\n",   "\n:lines align=center.\n",
                                "\n:elines.\n", "",             DISPLAY},
    {"@author{",        "}",    "\n:lines align=center.\n",
                                "\n:elines.\n", "",             DISPLAY},
    {"@br",             "\n",   "\n.br\n",      "",     "",     PARAGRAPH},
    {"@bullet{",        "}",    "&sqbul.",      "",     "",     CHAR},
    {"@bye",            "\n",   "",             "",     "",     BYE},
    {"@b{",             "}",    ":hp2.",        ":ehp2.","",    INPARA},
    {"@c",              "\n",   "",             "",     "",     COMMENT},
    {"@cartouche",      "@end", "",             "",     "",     PARAGRAPH},
    {"@center",         "\n",   "\n:lines align=center.\n",
                                "\n:elines.\n", "",             PARAGRAPH},
    {"@center{",        "}",    "\n:lines align=center.\n",
                                "\n:elines.\n", "",             PARAGRAPH},
    {"@chapheading",    "\n",   ":hp2.", ":ehp2.\n", 
                                                        "",     PARAGRAPH},
    {"@chapter",        "\n",   "",             "\n",   "",     HEADING1},
    {"@cindex",         "\n",   "\n:i1.",       "\n",   "",     INDEX},
    {"@cite{",          "}",    ":hp1.",        ":ehp1.","",    INPARA},
    {"@clear",          "\n",   "",             "",     "",     SETCLEAR},
    {"@code",           "\n",   FONT_MONO,      "\n",   FONT_MONO,
                                                                INPARA},
    {"@code{",          "}",    FONT_MONO,      "",     FONT_MONO,
                                                               INPARA},
    {"@comment",        "\n",   "",             "",     "",     COMMENT},
    {"@contents",       "\n",   "",             "",     "",     INPARA},
    {"@copyright{",     "}",    "(C)",          "",     "",     CHAR},
    {"@ctrl{",          "}",    FONT_MONO"^",   "",     FONT_MONO,INPARA},
    {"@dag",            "}{",   "+",            "",     "",     CHAR},
    {"@dag{",           "}",    "+",            "",     "",     CHAR},
    {"@ddag",           "}{",   "++",           "",     "",     CHAR},
    {"@ddag{",          "}",    "++",           "",     "",     CHAR},
    {"@defcmd",         "@end", ":p.Command",   "",     "",     TEMPLATE2},
    {"@defcmdx",        "\n",   ":p.Command",   "",     "",     TEMPLATE2},
    {"@defconst",       "@end", ":p.Constant",  "",     "",     TEMPLATE2},
    {"@defconstx",      "\n",   ":p.Constant",  "",     "",     TEMPLATE2},
    {"@defcv",          "@end", ":p.",          "",     "",     TEMPLATE},
    {"@defcvx",         "\n",   ":p.",          "",     "",     TEMPLATE},
    {"@deffn",          "@end", ":p.",          "",     "",     TEMPLATE3},
    {"@deffnx",         "\n",   ":p.",          "",     "",     TEMPLATE3},
    {"@defivar",        "@end", ":p.Instance Variable",
                                                "",     "",     TEMPLATE2},
    {"@defivarx",       "\n",   ":p.Instance Variable",
                                                "",     "",     TEMPLATE2},
    {"@defmac",         "@end", ":p.Macro",     "",     "",     TEMPLATE4},
    {"@defmacx",        "\n",   ":p.Macro",     "",     "",     TEMPLATE4},
    {"@defmethod",      "@end", ":p.Method",    "",     "",     TEMPLATE2},
    {"@defmethodx",     "\n",   ":p.Method",    "",     "",     TEMPLATE2},
    {"@defop",          "@end", ":p.",          "",     "",     TEMPLATE}, 
    {"@defopx",         "\n",   ":p.",          "",     "",     TEMPLATE}, 
    {"@defopt",         "@end", ":p.User Option","",    "",     TEMPLATE4},
    {"@defoptx",        "\n",   ":p.User Option","",    "",     TEMPLATE4},
    {"@defspec",        "@end", ":p.Special Form","",   "",     TEMPLATE4},
    {"@defspecx",       "\n",   ":p.Special Form","",   "",     TEMPLATE4},
    {"@deftp",          "@end", ":p.",          "",     "",     TEMPLATE3},
    {"@deftypefn",      "@end", ":p.",          "",     "",     TEMPLATE},
    {"@deftypefnx",     "\n",   ":p.",          "",     "",     TEMPLATE},
    {"@deftypefun",     "@end", ":p.Function",  "",     "",     TEMPLATE2},
    {"@deftypefunx",    "\n",   ":p.Function",  "",     "",     TEMPLATE2},
    {"@deftypevar",     "@end", ":p.Variable",  "",     "",     TEMPLATE2},
    {"@deftypevarx",    "\n",   ":p.Variable",  "",     "",     TEMPLATE2},
    {"@deftypevr",      "@end", ":p.",          "",     "",     TEMPLATE},
    {"@deftypevrx",     "\n",   ":p.",          "",     "",     TEMPLATE},
    {"@defun",          "@end", ":p.Function",  "",     "",     TEMPLATE4},
    {"@defunx",         "\n",   ":p.Function",  "",     "",     TEMPLATE4},
    {"@defvr",          "@end", ":p.",          "",     "",     TEMPLATE3},
    {"@defvrx",         "\n",   ":p.",          "",     "",     TEMPLATE3},
    {"@defvar",         "@end", ":p.Variable",  "",     "",     TEMPLATE4},
    {"@defvarx",        "\n",   ":p.Variable",  "",     "",     TEMPLATE4},
    {"@dfn{",           "}",    ":hp1.",        ":ehp1.","",    INPARA},
    {"@display",        "@end", "\n:lines.\n",  "\n:elines.\n",
                                                        "",     PARAGRAPH},
    {"@dmn{",           "}",    "",             "",     "",     INPARA},
    {"@dots{",          "}",    "&per.&per.&per.","",   "",     INPARA},
    {"@eject",          "\n",   "",             "",     "",     DISCARD},
    {"@emph{",          "}",    ":hp1.",        ":ehp1.","",    INPARA},
    {"@end",            "\n",   "",             "",   "",       END},
    {"@enumerate",      "@end", "\n:ol.\n",     "\n:eol.\n","", ITEMIZING},
    {"@equiv{",         "}",    "==",           "",     "",     CHAR},
    {"@error{",         "}",    "error-->",     "",     "",     CHAR},
    {"@example",        "@end", "\n:xmp.\n",    "\n:exmp.\n",
                                                       FONT_MONO,DISPLAY},
    {"@example{",       "}",    FONT_MONO,      "",     FONT_MONO,INPARA},
    {"@exdent",         "\n",   "",             "\n",   "",     PARAGRAPH},
    {"@expansion{",     "}",    "->",           "",     "",     CHAR},
    {"@file{",          "}",    FONT_MONO"`",   "'",    FONT_MONO,INPARA},
    {"@finalout",       "\n",   "",             "\n",   "",     DISCARD},
    {"@findex",         "\n",   "\n:i1.",       "\n",   "",     INDEX},
    {"@flushleft",      "@end", "\n:lines align=left.\n",
                               "\n:elines.\n", "",             PARAGRAPH},
    {"@flushright",     "@end", "\n:lines align=right.\n",
                               "\n:elines.\n", "",             PARAGRAPH},
    {"@format",         "@end", "",             "",     "",     PARAGRAPH},
    {"@footnote{",      "}",    ":link refid=", ":efn.","",     FOOTNOTE},
    {"@ftable",         "@end", "\n:parml.\n",  "\n:eparml.\n","",
                                                        ITEMIZING},
    {"@group",          "@end", "\n",   "\n",   "",     PARAGRAPH},
    {"@heading",        "\n",   ":hp7.",":ehp7.\n",
                                                "",     PARAGRAPH},
    {"@headings",       "\n",   "",     "",     "",     DISCARD},
    {"@iappendix",      "\n",   "",     "\n",   "",     HEADING1},
    {"@iappendixsec",   "\n",   "",     "\n",   "",     HEADING2},
    {"@iappendixsubsec","\n",   "",     "\n",   "",     HEADING3},
    {"@ichapter",       "\n",   "",     "\n",   "",     HEADING1},
    {"@ifclear",        "@end", "",     "",     "",     CONDITION},
    {"@ifhtml",         "@end", "",     "",     "",     DISCARD}, /* no *real*
                                                                   * Texinfo */
    {"@ifinfo",         "@end", "\n",   "\n",   "",     PARAGRAPH},
    {"@ipfline{",       "}",    "",     "",     "",     VERBATIM},
    {"@ifset",          "@end", "",     "",     "",     CONDITION},
    {"@iftex",          "@end", "",     "",     "",     DISCARD},
    {"@ignore",         "@end", "",     "",     "",     DISCARD},
    {"@include",        "\n",   "",     "\n",   "",     INCLUDE},
    {"@inforef{",       "}",    "See Info file ","",    "",     PARAGRAPH},
    {"@isection",       "\n",   "",     "\n",   "",     HEADING2},
    {"@isubsection",    "\n",   "",     "\n",   "",     HEADING3},
    {"@isubsubsection", "\n",   "",     "\n",   "",     HEADING4},
    {"@item",           "\n",   "",     "",   "",       ITEM},
    {"@itemize",        "@end", "\n:ul.\n",     "\n:eul.\n","", ITEMIZING},
    {"@itemx",          "\n",   "",     "",   "",       ITEM},
    {"@iunnumbered",    "\n",   "",     "\n","",        HEADING1},
    {"@iunnumberedsec", "\n",   "",     "\n","",        HEADING2},
    {"@iunnumberedsubsec","\n", "",     "\n",   "",     HEADING3},
    {"@i{",             "}",    ":hp1.",        ":ehp1.","",    INPARA},
    {"@kbd{",           "}",    FONT_MONO,      "",     FONT_MONO,INPARA},
    {"@key{",           "}",    FONT_MONO,      "",     FONT_MONO,INPARA},
    {"@kindex",         "\n",   "\n:i1.",       "\n",   "",     INDEX},
    {"@lisp",           "@end", "\n:xmp.\n",    "\n:exmp.\n",
                                                        FONT_MONO,DISPLAY},
    {"@macro",          "@end", "",      "",    "",     DISCARD},
    {"@majorheading",   "\n",   ":hp2.", ":ehp2.\n", 
                                                        "",     PARAGRAPH},
    {"@menu",           "@end", "",             "",     "",     MENU},
    {"@minus{",         "}",    "-",            "",     "",     CHAR},
    {"@need",           "\n",   "",             "",     "",     DISCARD},
    {"@node",           "\n",   "",             "",     "",     NODE},
    {"@noindent",       "\n",   "\n",           "",     "",     PARAGRAPH},
    {"@page",           "\n",   ":p.:p.\n",     "",     "",     PARAGRAPH},
    {"@pindex",         "\n",   "\n:i1.",       "\n",   "",     INDEX},
    {"@point{",         "}",    "-!-",          "",     "",     CHAR},
    {"@printindex",     "\n",   "Sorry, no ",   " index\n","",  PARAGRAPH},
    {"@prints{",        "}",    "-|",           "",     "",     CHAR},
    {"@print{",         "}",    "-|",           "",     "",     CHAR},
    {"@pxref{",         "}",    "see :link reftype=hd %s refid='%s'.",
                                               ":elink.","",   XREF},
    {"@quotation",      "@end", "",             "",     "",     PARAGRAPH},
    {"@refill",         "\n",   "",             "\n",   "",     DISCARD},
    {"@ref{",           "}",    ":link reftype=hd %s refid='%s'.",
                                                ":elink.","",   XREF},
    {"@result",         "\n",   "=>",           "\n",   "",     CHAR},
    {"@result{",        "}",    "=>",           "",     "",     CHAR},
    {"@r{",             "}",    EFNT_MONO,      "",     EFNT_MONO,
                                                                INPARA},
    {"@samp{",          "}",    FONT_MONO"`",   "'",    FONT_MONO,INPARA},
    {"@sc{",            "}",    ":hp2.",        ":ehp2.","",    INPARA},
    {"@section",        "\n",   "",             "\n",   "",     HEADING2},
    {"@set",            "\n",   "",             "",     "",     SETCLEAR},
    {"@setchapternewpage","\n", "",             "\n",   "",     DISCARD},
    {"@setfilename",    "\n",   "",             "",     "",     DISCARD},
    {"@settitle",       "\n",   ":title.",      "\n",   "",     PARAM},
    {"@shortcontents",  "\n",   "",             "",     "",     DISCARD},
    {"@smallbook",      "\n",   "",             "\n",   "",     DISCARD},
    {"@smallexample",   "@end", "\n:xmp.\n",    "\n:exmp.\n",FONT_MONO,
                                                                DISPLAY},
    {"@sp",             "\n",   "\n:p.",        "",     "",     DISCARD},
    {"@sp2",            "\n",   "\n:p.",        "",     "",     DISCARD},
    {"@strong{",        "}",    ":hp2.*",       "*:ehp2.","",   INPARA},
    {"@subheading",     "\n",   ":hp6.",        ":ehp6.\n",
                                                        "",     PARAGRAPH},
    {"@subsection",     "\n",   "",             "\n",   "",     HEADING3},
    {"@subsubheading",  "\n",   ":hp5.",        ":ehp5.\n",
                                                        "",     PARAGRAPH},
    {"@subsubsection",  "\n",   "",             "\n",   "",     HEADING4},
    {"@subtext",        "\n",   "\n:lines align=center.\n",
                                "\n:elines.\n", "",             PARAGRAPH},
    {"@subtext{",       "}",    "\n:lines align=center.\n",
                                "\n:elines.\n", "",             PARAGRAPH},
    {"@subtitle",       "\n",   "\n:lines align=center.\n",
                                "\n:elines.\n", "",             PARAGRAPH},
    {"@subtitle{",      "}",   "\n:lines align=center.\n",
                                "\n:elines.\n", "",             PARAGRAPH},
    {"@summarycontents","\n",   "",             "",     "",     INPARA},
    {"@syncodeindex",   "\n",   "",             "\n",   "",     DISCARD},
    {"@synindex",       "\n",   "",             "\n",   "",     DISCARD},
    {"@t",              "\n",   "\t",           "\n",   "",     CHAR},
    {"@table",          "@end", "\n:parml.\n",  "\n:eparml.\n","",
                                                                ITEMIZING},
    {"@tex",            "@end", "",             "",     "",     DISCARD},
    {"@tindex",         "\n",   "\n:i1.",       "\n",   "",     INDEX},
    {"@title",          "\n",   "\n:lines align=center.\n",
                                "\n:elines.\n", "",             PARAGRAPH},
    {"@title{",         "}",    "\n:lines align=center.\n",
                                "\n:elines.\n", "",             PARAGRAPH},
    {"@titlefont{",     "}",    "",             "",     "",     INPARA},
    {"@titlepage",      "@end", "Title page",   "",     "",     HEADING1},
    {"@titlespec",      "@end", "",             "",     "",     PARAGRAPH},
    {"@top",            "\n",   "Top node: \"", "\"\n", "",     HEADING1},
    {"@t{",             "}",    FONT_MONO,      "",     FONT_MONO,INPARA},
    {"@tt{",            "}",    FONT_MONO,      "",     FONT_MONO,INPARA},
    {"@unnumbered",      "\n",  "",             "\n",   "",     HEADING1},
    {"@unnumberedsec",   "\n",  "",             "\n",   "",     HEADING2},
    {"@unnumberedsubsec","\n",  "",             "\n",   "",     HEADING3},
    {"@unnumberedsubsubsec","\n","",            "\n",   "",     HEADING4},
    {"@value{",         "}",    "",             "",     "",     VALUE},
    {"@var{",           "}",    ":hp1.",        ":ehp1.","",    INPARA},
    {"@vfil",           "\n",   "",             "\n",   "",     DISCARD},
    {"@vindex",         "\n",   "\n:i1.",       "\n",   "",     INDEX},
    {"@vskip",          "\n",   "",             "\n",   "",     DISCARD},
    {"@vtable",         "@end", "\n:parml.\n",  "\n:eparml.\n","",
                                                               ITEMIZING},
    {"@w{",             "}",    "",             "",     "",     INPARA},
    {"@xref{",          "}",    "See :link reftype=hd %s refid='%s'.",
                                               ":elink.","",   XREF},
/* the following macro is for internal communication between modules only */
    {"@_tag{",          "}",    ":",            ".",    "",     CHAR},

    {"@{",              "",     "{",            "",     "",     ESCAPED},
    {"@}",              "",     "}",            "",     "",     ESCAPED}
     
};


