/*

  REXX Script to uninstall PrjBld and remove all desktop folders
  - leaves the INI file intact.  Erases most EXE and support files.

  This file should be located in the same directory as the PRJBLD.EXE 
  and support files.
*/

    if RxFuncQuery('SysLoadFuncs') then do
        call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
        call SysLoadFuncs
    end

    do forever
        CALL SysCls
        say "You are about to delete all the PrjBld program folders from your desktop."
        say
        say "This will not affect any project folders created with PrjBld."
        say 
        say "Your PRJBLD.INI file will be left in your installation directory so that"
        say "PrjBld can be easily reinstalled later.  Remove PRJBLD.INI manually if"
        say "you don't need it any more."
        say
        call SysSleep 2
        say "Are you sure you want to uninstall PrjBld? [Y/N]"
        CALL BEEP 2000,1
        parse upper pull Char
            if Char = "Y" then 
 	        leave
        if Char = "N" THEN
 	        EXIT;
    end

    say "Deleting folders"
    call SysDestroyObject("<PRJBLDFOLDER>") 
    say "Deleting files"
    call SysFileDelete("FILE_ID.DIZ");
    call SysFileDelete("IDK.ICO");
    call SysFileDelete("IDKO.ICO");
    call SysFileDelete("INSTALL.CMD");
    call SysFileDelete("INSTALL.ICO");
    call SysFileDelete("ORDER.FRM");
    call SysFileDelete("PLASTER.BMP");
    call SysFileDelete("PRJBLD.EXE");
    call SysFileDelete("PRJBLD.HLP");
    call SysFileDelete("PURCHASE.APP");
    call SysFileDelete("PURCHASE.DOC");
    call SysFileDelete("PURCHASE.EXE");
    call SysFileDelete("README.TXT");
    call SysFileDelete("REGISTER.FRM");
    call SysFileDelete("REGISTER.TXT");
    call SysFileDelete("UNINSTAL.ICO");

    say "UnInstallation completed - PrjBld"

