/*---------------------------------------------------------------------------

               Copyright (c) 1994 SandStone Software Inc.
                          All rights reserved

----------------------------------------------------------------------------*/
#if defined( __OS2__)

   SSInline SSBooleanValue SSDbcsInfo::isLeadByte( char qchByte)
      {
      if ( isascii( qchByte)) return SSFalse;
      char* zpchLead = oachDbcs;
      while ( *zpchLead)
         {
         if ( qchByte >= *zpchLead && qchByte <= *( zpchLead + 1))
            return SSTrue;
         zpchLead += 2;
         }

      return SSFalse;
      }

#else

   extern "C"
      {
      int _far _pascal IsDBCSLeadByte( unsigned char);
      }

   SSInline SSBooleanValue SSDbcsInfo::isLeadByte( char qchByte)
      {
      return IsDBCSLeadByte( qchByte) ? SSTrue : SSFalse;
      }

#endif

   SSInline SSDbcsInfo::SSDbcsInfo( void)
      {
      memset( oachDbcs, 0, sizeof oachDbcs);
      set();
      }

   SSInline SSUnsigned32 SSDbcsInfo::asUnsigned32( const char* qpchDbcs)
      {
      unsigned long zulCurrent = *qpchDbcs & 0x000000ff;
      zulCurrent <<= 8;
      zulCurrent |= *( qpchDbcs + 1);
      return zulCurrent;
      }
