/*---------------------------------------------------------------------------

               Copyright (c) 1994 SandStone Technology Inc.
                          All rights reserved

----------------------------------------------------------------------------*/
#if !defined( SSYACCCH)
#  define SSYACCCH
#  include<ssglobal.h>

#  if defined __cplusplus
      extern "C" {
#  endif

#  if !defined( SSYaccErrorToken)
#     define SSYaccErrorToken  0xfffffffe
#  endif
#  if !defined( SSYaccEofToken)
#     define SSYaccEofToken    0xffffffff
#  endif

   /*--------------------------------------------------------------------- 
   -- SSYaccTable functions
   ----------------------------------------------------------------------*/
   void*          SSYaccTableCreate( const char*, void**);
   void           SSYaccTableDestroy( void*);

   /*--------------------------------------------------------------------- 
   -- SSYaccStackElement functions
   ----------------------------------------------------------------------*/
   void*          SSYaccStackElementCreate( SSUnsigned32, void**);
   void           SSYaccStackElementRefInc( void*);
   void           SSYaccStackElementRefDec( void*);
   void           SSYaccStackElementDestroy( void*);

   void*          SSYaccStackElementGetExtra( void*);
   SSUnsigned32   SSYaccStackElementGetState( void*);
   void*          SSYaccStackElementGetLexeme( void*);

   void           SSYaccStackElementSetState( void*, SSUnsigned32);
   void           SSYaccStackElementSetLexeme( void*, void*);

   /*--------------------------------------------------------------------- 
   -- SSYacc functions
   ----------------------------------------------------------------------*/
   typedef        void* ( *SSYaccNextLexemeCallback)( void*, void*);
   typedef        void* ( *SSYaccShiftCallback)( void*, void*, void*);
   typedef        void* ( *SSYaccReduceCallback)( void*, SSUnsigned32, 
                     SSUnsigned32, void*);
   typedef        SSBooleanValue ( *SSYaccErrorCallback)( void*, void*, 
                     SSUnsigned32, void*);

   void*          SSYaccCreate( void*, void*, SSYaccReduceCallback, void*,
                     SSUnsigned32, void**);
   void           SSYaccDestroy( void*);

   void           SSYaccSetNextLexemeCallback( void*, SSYaccNextLexemeCallback,
                     void*);
   void           SSYaccSetShiftCallback( void*, SSYaccShiftCallback, void*);
   void           SSYaccSetErrorCallback( void*, SSYaccErrorCallback, void*);
   void           SSYaccSetAbort( void*);
   void           SSYaccClearLastException( void*);

   SSBooleanValue SSYaccGetAbort( void*);
   SSBooleanValue SSYaccGetError( void*);
   void*          SSYaccGetLastException( void*);
   SSUnsigned32   SSYaccGetShiftedSinceError( void*);
   void*          SSYaccGetElementFromStack( void*, SSUnsigned32);
   void*          SSYaccGetElementFromProduction( void*, SSSigned32);
   SSUnsigned32*  SSYaccGetValidLookaheads( void*, SSUnsigned32, SSUnsigned32*);

   SSBooleanValue SSYaccReset( void*);
   SSBooleanValue SSYaccParse( void*);
   SSBooleanValue SSYaccProcessError( void*);
   SSBooleanValue SSYaccPushStackElement( void*, void*);
   void           SSYaccFreeValidLookaheads( SSUnsigned32*);
   SSBooleanValue SSYaccPopStackElement( void*, SSUnsigned32);

#  if defined __cplusplus
      }
#  endif

#endif
/*---------------------------------------------------------------------------

               Copyright (c) 1994 SandStone Technology Inc.
                          All rights reserved

----------------------------------------------------------------------------*/
