/* showmem.c (emx+gcc) */

/* Show the memory map of an OS/2 process, for sbrk1.c and showmem1.c. */

#define INCL_DOSMEMMGR
#define INCL_DOSERRORS
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>

void showmem (void)
{
  ULONG rc, size, flags, base, esp;
  ULONG total_used, total_commit;

  base = 0x10000; total_used = 0; total_commit = 0;
  esp = (ULONG)&esp;
  for (;;)
    {
      size = 0xffffffff;
      rc = DosQueryMem ((PVOID)base, &size, &flags);
      if (rc == ERROR_INVALID_ADDRESS)
        break;
      if (rc != 0)
        {
          printf ("DosQueryMem failed, rc=%lu\n", rc);
          break;
        }
      if (flags & PAG_BASE)
        puts ("------------------------------");
      printf ("%.8lx - %.8lx (%.8lx)", base, base + size - 1, size);
      if (flags & PAG_FREE)    printf (" FREE  ");
      if (flags & PAG_COMMIT)  printf (" COMMIT");
      if (flags & PAG_GUARD)   printf (" GUARD ");
      if (flags & PAG_SHARED)  printf (" share ");
      if (flags & PAG_READ)    printf (" read  ");
      if (flags & PAG_READ)    printf (" write ");
      if (flags & PAG_EXECUTE) printf (" exec  ");
      if (base <= esp && esp < base + size) printf ("<-- ESP");
      putchar ('\n');
      base += size;
      if (!(flags & PAG_FREE))
        {
          total_used += size;
          if (flags & PAG_COMMIT)
            total_commit += size;
        }
      if (base == 0) break;
    }
  printf ("Total:               %.8lx  not FREE\n", total_used);
  printf ("Total:               %.8lx  COMMIT\n", total_commit);
}
