default: runtime-info.h st mt lib-st lib-mt

lib-st .SETDIR=st:
	$(MAKE) -f ../makefile objc.a THREADS=thr-single.o CFLAGS=

lib-mt .SETDIR=mt:
	$(MAKE) -f ../makefile objc.a THREADS=thr-os2.o CFLAGS=-Zmt

lib: $(DIR) objc.a

.SUFFIXES: .m .o

.SOURCE.c: ..
.SOURCE.m: ..
.SOURCE.h: ..

GCC=gcc -O -I.. -I../.. -I../../config -I/emx/include/objc

.c.o:
	$(GCC) -c $(CFLAGS) $<

.m.o:
	$(GCC) -c $(CFLAGS) -fgnu-runtime $<

mt:
	mkdir mt

st:
	mkdir st

OBJC_O = hash.o sarray.o class.o sendmsg.o init.o archive.o encoding.o \
         selector.o objects.o misc.o NXConstStr.o Object.o Protocol.o \
         nil_method.o thr.o linking.o $(THREADS)

objc.a: $(OBJC_O)
	-del objc.a
	ar r objc.a $(OBJC_O)
	ar s objc.a

runtime-info.h:
	-del tmp-runtime
	touch tmp-runtime
	cc1obj -print-objc-runtime-info tmp-runtime >runtime-info.h
	-del tmp-runtime
