/* inst.cmd */

version = '2.8.1.1'
patch = 'lwpatch'

call RxFuncAdd 'SysSearchPath', 'RexxUtil', 'SysSearchPath'

progs = 'gzip mv rm sed tar touch' patch
do i = 1 to words(progs)
  prog = word(progs, i)||'.exe'
  path = SysSearchPath('PATH', prog)
  if path == '' then
    error('Program not found: '||prog)
end
/* TODO: improve the test for OS/2's PATCH.EXE */
path = SysSearchPath('PATH', patch||'.exe')
if translate(filespec('p', path)) == '\OS2\' then
  error('Cannot use OS/2 version of PATCH.EXE')

usage = 0
parse arg cmdline

parse var cmdline first last rest

if first == '' then first = 1
if last == '' then last = 9999

if (rest \== '') | \datatype(first,'n') | \datatype(last,'n'),
   | (first > last) then do
  say 'Usage: inst [<start#> [<end#>]]'
  usage = 1
end

if \exists('patches\stdcpp\inst.cmd') then
  error('The current working directory must be \emx\gnu')

'@echo off'

if usage then say 'Values for <start#> and <end#>:'

dir = 'libstdc++-'||version

if step(1, 'Unpacking libstdc++') then do
  if exists(dir) | dir_exists(dir) then error(dir||' exists')
  'tar xzf libstdc++-'||version||'.tar.gz'
  if rc \== 0 then error('tar failed')
end

if step(2, 'Removing the read-only flag') then do
  'attrib -r '||dir||'\* /s'
  if rc \== 0 then error('attrib failed')
end

if step(3, 'Deleting unused files') then do
  'cd' dir
  'rm install-sh'
  'cd ..'
end

if step(4, 'Configuring for emx') then do
  'cd' dir
  'copy ..\patches\stdcpp\gconfig.h libio\_G_config.h >nul'
  'copy ..\patches\stdcpp\list.sed "libstdc++" >nul'
  'copy ..\patches\stdcpp\clean.cmd "libstdc++" >nul'
  'touch libio\_G_config.h'
  'sed -f ..\patches\stdcpp\makefile.sed libio\Makefile.in >libio\Makefile'
  'sed -f ..\patches\stdcpp\makefile.sed libstdc++\Makefile.in >libstdc++\Makefile'
  'ar cr libiberty\libiberty.a'
  'cd ..'
end

if step(5, 'Applying emx patches') then do
  'cd' dir
  patch '-p1 <..\patches\stdcpp\patches'
  'cd ..'
end

exit usage

/* Procedures */

exists:
  return stream(arg(1), 'c', 'query exists') \== ''

dir_exists: procedure
  cur = directory()
  new = directory(arg(1))
  call directory(cur)
  return new \= ''
  
step: procedure expose first last usage
  if usage then do
    say '  ' arg(1)||':' arg(2)
    return 0
  end
  if (first <= arg(1)) & (arg(1) <= last) then do
    say 'Step' arg(1)||':' arg(2)
    return 1
  end
  return 0

error:
  say '*** Error:' arg(1)
  exit 2
