/* ANALYZE.C */
static int diag ( int xoff , int xlim , int yoff , int ylim , int *cost );
static void compareseq ( int xoff , int xlim , int yoff , int ylim );
void discard_confusing_lines ( struct file_data filevec []);
static void shift_boundaries ( struct file_data filevec []);
static struct change *add_change ( int line0 , int line1 , int deleted , int inserted , struct change *old );
static struct change *build_reverse_script ( struct file_data filevec []);
static struct change *build_script ( struct file_data filevec []);
int diff_2_files ( struct file_data filevec [], int depth );

/* CONTEXT.C */
static void print_context_label ( const char *mark , struct file_data *inf , const char *label );
void dosname ( char *ptr );
void print_context_header ( struct file_data *inf , int unidiff_flag );
void print_context_script ( struct change *script , int unidiff_flag );
static void print_context_number_range ( struct file_data *file , int a , int b );
static void pr_context_hunk ( struct change *hunk );
static void print_unidiff_number_range ( struct file_data *file , int a , int b );
static void pr_unidiff_hunk ( struct change *hunk );
static struct change *find_hunk ( struct change *start );
static void mark_ignorable ( struct change *script );
static void find_function ( struct file_data *file , int linenum , char **linep , int *lenp );

/* DIFF.C */
static char *option_list ( char **optionvec , int count );
int main ( int argc , char *argv []);
int usage ( void );
int usage ( void );
int specify_style ( enum output_style style );
int compare_files ( char *dir0 , char *name0 , char *dir1 , char *name1 , int depth );

/* DIR.C */
static struct dirdata dir_sort ( char *dirname , int nonex );
/* if using borlandc, do not define prototype for compare_names used */
/* in qsort call in dir.c, else the compiler will belch */
#ifndef __BORLANDC__
static int compare_names ( char **file1 , char **file2 );
#endif
int diff_dirs ( char *name1 , char *name2 ,
                int (*handle_file )( char *dir0 , char *name0 ,
                                     char *dir1 , char *name1 , int depth ) ,
                int depth , int nonex1 , int nonex2 );

/* ED.C */
void print_ed_script ( struct change *script );
static void print_ed_hunk ( struct change *hunk );
void pr_forward_ed_script ( struct change *script );
static void pr_forward_ed_hunk ( struct change *hunk );
void print_rcs_script ( struct change *script );
static void print_rcs_hunk ( struct change *hunk );

/* GETOPT.C */
static void exchange ( char **argv );
int getopt ( int argc , char **argv , const char *optstring );

/* GETOPT1.C */
int getopt_long ( int argc , char **argv , const char *options , const struct option *long_options , int *opt_index );
int getopt_long_only ( int argc , char **argv , const char *options , const struct option *long_options , int *opt_index );

/* IFDEF.C */
void print_ifdef_script ( struct change *script );
static void print_ifdef_hunk ( struct change *hunk );

/* IO.C */
static int binary_file_p ( char *buf , int size );
static int slurp ( void );
void find_and_hash_each_line ( void );
static void find_identical_ends ( struct file_data filevec []);
static int find_equiv_class ( int n );
int read_files ( struct file_data filevec []);

/* MKTEMP.C */
void Mktemp ( char *file );

/* NORMAL.C */
void print_normal_script ( struct change *script );
void print_normal_hunk ( struct change *hunk );

/* PIPE.C */
static FILE *dos_popen ( char *command , char *mode );
static int dos_pclose ( FILE *current );
FILE *popen ( char *cmd , char *mode );
int pclose ( FILE *ptr );

/* REGEX.C */
static void init_syntax_once ( void );
int re_set_syntax ( int syntax );
static void store_jump ( char *from , char opcode , char *to );
static void insert_jump ( char op , char *from , char *to , char *current_end );
char *re_compile_pattern ( char *pattern , int size , struct re_pattern_buffer *bufp );
void re_compile_fastmap ( struct re_pattern_buffer *bufp );
int re_search ( struct re_pattern_buffer *pbufp , char *string , int size , int startpos , int range , struct re_registers *regs );
int re_search_2 ( struct re_pattern_buffer *pbufp , char *string1 , int size1 , char *string2 , int size2 , int startpos , int range , struct re_registers *regs , int mstop );
int re_match ( struct re_pattern_buffer *pbufp , char *string , int size , int pos , struct re_registers *regs );
int re_match_2 ( struct re_pattern_buffer *pbufp , char *string1_arg , int size1 , char *string2_arg , int size2 , int pos , struct re_registers *regs , int mstop );
static int bcmp_translate ( unsigned char *s1 , unsigned char *s2 , int len , unsigned char *translate );
char *re_comp ( char *s );
int re_exec ( char *s );

/* UTIL.C */
void perror_with_name ( char *text );
void pfatal_with_name ( char *text );
/* void error ( char *format , ... ); */
void fatal ( char *message );
/* void message ( char *format , ... ); */
void print_message_queue ( void );
void setup_output ( char *name0 , char *name1 , int depth );
void finish_output ( void );
int line_cmp ( struct line_def *s1 , struct line_def *s2 );
struct change *find_change ( struct change *start );
struct change *find_reverse_change ( struct change *start );
void print_script ( struct change *script , struct change *(*hunkfun )(), void (*printfun )());
void print_1_line ( char *line_flag , struct line_def *line );
int change_letter ( int inserts , int deletes );
int translate_line_number ( struct file_data *file , int lnum );
void translate_range ( struct file_data *file , int a , int b , int *aptr , int *bptr );
void print_number_range ( char sepchar , struct file_data *file , int a , int b );
void analyze_hunk ( struct change *hunk , int *first0 , int *last0 , int *first1 , int *last1 , int *deletes , int *inserts );
VOID *xmalloc ( unsigned size );
VOID *xrealloc ( VOID *old , unsigned int size );
char *concat ( char *s1 , char *s2 , char *s3 );
int debug_script ( struct change *sp );
