:userdoc. 
:h1 res=205.Extended help for Yatzee
:i1 id=generel.Extended help for Yatzee
This program is a computer-version of a game of dice called Yatzee.
:p.To get an overview of the game and its possibilities, select 
:hp1.Contents:ehp1. in the menu :hp1.Options:ehp1. in the action bar, or 
press Ctrl+C.
:p.To get an overview of the rules of Yatzee, choose
:link reftype=hd res=1002.rules:elink..
:h2.The game sheet
:i2 refid=generel.Game sheet
Each player gets his own :hp1.game sheet:ehp1., which not only shows the
players dices and score, but also all the other players dices and score. 
:p.The game sheet opens by starting the program YATZYNET.EXE. When this 
program is executed, it is important, that current directory is the one where
the system was installed. This is also true if you put the game in a 
group-menu. Don't forget to mention the right directory in the 
"Working directory" entryfield.
:p.The game sheet is a vindow, that contains several child windows. Each of
these child windows shows a participating players 
:link reftype=hd res=1004.dices:elink. and
:link reftype=fn refid=pointtavle.score-board:elink.. The child windows are
self contained and can be freely manipulated, i.e. minimized. Except from 
your own window, you are not allowed to use them for playing.
:p.You play the game on your own child window, which as a default is placed
to the left on the game sheet. Normally you will manipulate the dices with
the mouse, but you can also use the keyboard. Take a look on the 
:link reftype=hd res=206.Keys help:elink. for a description of the meaning
of the keys. The description of how to select and deselect the dices and
how you throw the dices is found in
:link reftype=hd res=1004.dices:elink..
:p.At the same time as you are playing, others can play too. There is no
notion of your &odq.turn&cdq., unless the players all agree upon it.
As soon as a player does something in his child window, this is immediately
reflected on the other players game sheets. Everybody are therefore always
informed of the progressing game.
:p.It is not necessary, that all participants commence on the same time. A
player is able to begin playing after some or all the others have finished.
:p.The game is over when all the players has placed a score in all the 
score categories. A new game can begin when the 
:link reftype=hd res=1001.server-program:elink. has terminated and is 
restarted.
:h2.Playing on one computer
:i2 refid=generel.Playing on one computer
The game is aimed at one game sheet on each players computer, but it is 
possible to create all game sheets on a single computer. If you do that,
you must also execute the
:link reftype=hd res=1001.server-program:elink. on this computer too, and 
not on the 
:link reftype=hd res=1003.LAN:elink.-server. Also, you should 
:hp2.not:ehp2. enter a :link reftype=hd res=643.servername:elink. in the 
dialogbox :hp1.Insert player:ehp1..
:h2.Language support
:i2 refid=generel.Language support
Normally the program will start in the language that OS/2 has been told to 
use for this computer. If the language is not supported, english is used.
:p.You can ask the program to use another language than the default by 
entering the country code when you start the program. For example will
the following command make the program run in danish, even on an american
computer:
:xmp. 
YATZYNET 45
:exmp.
:p.The different country codes normally equels the countrys international
dial-numbers. Here are some examples:
:dl tsize=16 compact.
:dthd.Country
:ddhd.Country code
:dt.Belgium
:dd.32 
:dt.Denmark
:dd.45 
:dt.France  
:dd.33
:dt.Germany
:dd.49 
:dt.Italy
:dd.39 
:dt.Holland
:dd.31 
:dt.Norway
:dd.47 
:dt.Spain  
:dd.34 
:dt.Sweden
:dd.46 
:dt.Schwitzerland
:dd.41 
:edl.
:note.Only english and danish are currently supported. If anybody wants to 
translate it to other languages (or to correct my english), please contact me
on the address mentioned in 
:link reftype=hd res=1005.Acknowledgments:elink..
:h2.Limitations
:i2 refid=generel.Limitations
The game allows up to ten simultaneous players.
:p.If the program is minimized while new players are inserted, their child
windows are placed under each other on the game sheet.
:h2.Information for programmers
:i2 refid=generel.Information for programmers
The program utilizes a lot of unique OS/2-features, such as user-developed
controls, 
(:link reftype=hd res=1004.dices:elink. and sets of dices), multiple
threads (in the
:link reftype=hd res=1001.server-program:elink.),
Information Processing Facility (this help), Named
Pipes (communication between the game sheets and the server-program), Dynamic
Link Libraries (for various language-dependent resources), National 
Language Support, use of user profiles (for storage of the player- and
servername), Common User Access Multiple Document Interface, 
an undo-facility, and so on.
:p.It was developed using the IBM :hp1.Programming Tools and 
Information:ehp1.
version 1.2 and the IBM C/2 version 1.1. The editor used was the IBM Live
Parsing Editor. The development process was 
undertaken on an IBM Portable P70-061 with 4MB memory. The operating system
was IBM OS/2 Standard Edition 1.2. Note that this program, which is aimed at 
a LAN-environment, is developed on a stand-alone PC without any 
LAN-facilities.
:p.Since so many unique OS/2-facilities have been used, the program is a 
good illustration of the potentials of OS/2. The program can, besides the
Yatzee-game, be used as an example of OS/2's broad capabilities.
:p.Any questions, comments or error reports should be directed to the address
mentioned in 
:link reftype=hd res=1005.Acknowledgments:elink..
:h1 res=206.Keys help for Yatzee
:i1 id=taster.Keys help for Yatzee
The following keys can be used during the game:
:dl. 
:dthd.Key
:ddhd.Function
:dt.Ctrl+I
:dd.:link reftype=hd res=101.Insert player:elink.
:dt.Ctrl+T       
:dd.:link reftype=hd res=102.Transfer throw:elink.
:dt.Ctrl+R          
:dd.:link reftype=hd res=103.Reset dices:elink.
:dt.Ctrl+D
:dd.:link reftype=hd res=1004.Dices:elink.
:dt.F10                           
:dd.Transfer the focus to the actionbar
:edl.
:p.Keys for throwing and selection of dices:
:dl break=fit.
:dthd.Key
:ddhd.Function
:dt.Spacebar
:dd.Toggles the dice with focus between selected and not selected
:dt.Arrow keys
:dd.Move focus between the dices
:dt.Enter
:dd.Thow the dices which p.t. is selected. Note that the dice which has the
focus always is selected and participates in the throw, even though it on the
time for the throw is not selected.
:edl.
:p.Other keys:
:dl.
:dthd.Key
:ddhd.Function
:dt.Alt+                          
:dd.Provide categories in the dialogbox  
:link reftype=hd res=258.Transfer throw:elink.
:edl.
:p.Besides the above mentioned keys, OS/2's normal keys can be used - i.e.
F1 for help.
:h1.Help for actionbar
:i1 id=menuer.Help for actionbar
In this item, there is help for the different menu-choices.
:h2 res=100.Options
:i2 refid=menuer.Options
Here you select between a row of choices, which controls the game.
:p.Look at the the help for the individual items to get a description.
:h3 res=101.Insert player
:i2 refid=menuer.Insert player
When you select this item, you can insert a player by entering his or hers
name. If you are playing in a 
:link reftype=hd res=1003.LAN:elink.-environment, the name of the computer 
on which the
:link reftype=hd res=1001.server-program:elink. runs must also be entered.
:p.It is only possible to insert one player per game sheet. When this has
happened, the item turns grey and cannot be selected again.
:h3 res=102.Transfer throw 
:i2 refid=menuer.Transfer throw
When you select this item, you transfer your throw to the
:link refid=pointtavle reftype=fn.score-board:elink.. The item cannot be 
selected until you have thrown the 
:link reftype=hd res=1004.dices:elink. at least once since the last 
transfer to the score-board.
:h3 res=108.Undo transfer
:i2 refid=menuer.Undo transfer
When you select this item, you undo the last transfer of a throw to the
:link refid=pointtavle reftype=fn.score-board:elink.. After the selection of
this item, you are in the same situation as just before the transfer took 
place. This means, that if you had one or two throws left, you are now able
to make them.
:note.This item can only be selected just after a transfer of a throw to the
:link refid=pointtavle reftype=fn.score-board:elink.. If you for example have
made a :link reftype=hd res=103.Reset dices:elink. in the meantime, the 
:hp1.Undo transfer:ehp1. is not applicable.
:h3 res=103.Reset dices
:i2 refid=menuer.Reset dices
When you select this item, you removes any selections of dices and they are
all reset to aces. This item can only be selected just after that a throw
has been transferred to the 
:link refid=pointtavle reftype=fn.score-board:elink..
:h2 res=104.Window 
:i2 refid=menuer.Window
When you select this item, you can select between your own child window with
dices and the other players child windows.
:p.This item makes the program independent of a mouse.
:h3 res=105.Dices 
:i2 refid=menuer.Dices
When you select this item, you give your own 
:link reftype=hd res=1004.dices:elink. focus.
:p.This item makes the program independent of a mouse.
:h3 res=107.About
:i2 refid=menuer.About
When you select this item, you show the programs About-dialogbox.
:h1.Dialogboxes 
Help to the dialogboxes in the game.
:h2.Insert player     
:i1 id=indst.Insert player
Help to the entryfields of the dialogbox :hp1.Insert player:ehp1..
:h3 res=642.Name of player 
:i2 refid=indst.Name of player
In this entryfield you enter the name of the player. The name helps the other
players identifying each other. It is possible for two or more players to 
have the same name, but it is recommended to use unique names. 
:p.The entryfield can contain a maximum of 39 characters, which will be 
remembered between games.
:h3 res=643.Name of server 
:i2 refid=indst.Name of server
When you play in a :link reftype=hd res=1003.LAN:elink.-environment, the 
:link reftype=hd res=1001.server-program:elink. must be started on the 
LAN-server. The machine-identification of the server must be entered in this
entryfield. 
:p.If you are in doubt about which servers you have access to, you can use 
the NET VIEW-command. If you want further information, see your local 
network-administrator or consult the handbook 
:hp1.OS/2 LAN Server Network Administrators Guide:ehp1.. 
:p.The entryfield can contain a maximum of 8 characters, which will be 
remembered between games.
:h2 res=258.Transfer throw
:i1.Transfer throw
In this dialogbox, you specify where to place your throw. It is only possible 
to choose between categories not chosen before. The program makes a 
suggestion, but if you want to make another choice, you can select between
the available options. Either click on the down-arrow or press Alt+ on the 
keyboard. 
:p.It is possible to undo the transfer by selecting 
:link reftype=hd res=108.Undo transfer:elink..               
:h1 res=1001.The server-program 
:i1.Server-program
This program is the center of communication between the game sheets, whether 
the game takes place on one or more computers. When more computers are 
involved, the server-program must be executed on the server in the 
:link reftype=hd res=1003.local area network:elink.. 
The name of the server-program is YASERVER.EXE. The server-program must be 
started before the first player can be inserted. When the server-program has
been started, it waits for the first insertion. If it does not receive an 
insertion within two minutes, it will bring itself to an end. When the last 
player has terminated and closed the game sheet, it will also bring itself to
an end. When at least one player has an open game sheet, the server-program
allows fifteen minutes of inactivity before it brings itself to an end.
:p.It is possible to start the server-program from any computer in the 
network via the NET RUN-command. The current drive must be the
network-drive upon which the server-program is placed. If you 
want further information, see your local network-administrator or 
consult the handbook 
:hp1.OS/2 LAN Server Network Administrators Guide:ehp1.. 
:p.During playtime, the server-program writes to its window whenever a 
player is inserted and terminated. If you want more exhaustive information,
you can pass any parameter to the program, when it is started. For example
the following command causes full information written to the window about the 
various messages, which the server-program processes:
:xmp.
YASERVER 1
:exmp.
:h1 res=1002.Rules for Yatzee 
:i1.Rules for Yatzee
The game of Yatzee is played with five dices, and is won by the player with 
the highest score when the game is over. 
:p.The game consists of fifteen rounds per player. For each round, the 
player can make up to three throws. After each throw, the player can 
optionally deselect any number of dices or none at all. After the first or
second throw, the player may transfer the throw to the score-board. After 
the third throw, the throw :hp5.must:ehp5. be transferred. It is possible for
a dice to participate in a throw even though it earlier in the same round 
was deselected.
:p.There is fifteen score-categories, and each round results in one of them
being filled, possibly by nil. It is only possible to transfer once to a 
score-category. However, under certain circumstances, it is possible to 
undo the last transfer. For further information, see    
:link reftype=hd res=108.Undo transfer:elink.. 
As a generel rule, the score in a category is equal to the number of pips on 
the dices which is a part of the name of the score-category. Only the
:hp2.Yatzee:ehp2. score-category is an exception from this. 
:p.The upper six categories on the score-board are called :hp2.Aces, Twos,
Threes, Fours, Fives and Sixes:ehp2.. For each, only the dices belonging 
to the name counts when the score is calculated. If for example a throw 
consisting of one ace, two threes, one fiver, and one sixer is transferred 
to the category :hp2.Threes:ehp2., 2 times 3 equals 6 points are reached. If 
the throw one ace, two threes, and two sixes are transferred to the category 
:hp2.Sixes:ehp2., 12 points are reached. For these six upper categories, it 
is possible to get a special :hp1.bonus:ehp1. of 50 points, when the sum of 
their scores is greater than 62. This equals an average of three dices in 
each category. Until a throw has been transferred to all these six 
categories, the bonus-category keeps a record with a possible surplus or 
deficit. When all the categories have received a score, the bonus-category 
contains the sum of the scores inclusive any bonus.
:p.The next four score-categories is called :hp2.One pair, Two pairs, 
Three alike:ehp2. and :hp2.Four alike:ehp2.. When a throw is transferred 
to these categories, the score is given according to the name of the 
category. For example a throw of two threes, one fiver and to sixes 
transferred to :hp2.One pair:ehp2. yields 
2 time 6 equals 12 points, because the highest of the two possible pairs are
selected. The same throw yields 18 points (the sum of 2 times 3 and 2 times 
6) when transferred to :hp2.Two pairs:ehp2.. 
:note.When a throw containing four alike is transferred to :hp2.Two 
pairs:ehp2., it yields nil.
:p.The next to score-categories are respectively :hp2.Small:ehp2. and
:hp2.Large:ehp2.. :hp2.Small:ehp2. yields 15 points, if the five dices
show 1, 2, 3, 4 and 5 in any order. :hp2.Large:ehp2. yields 20 points
when the ace in the just mentioned throw is replaced with a sixer. 
The category :hp2.Full house:ehp2. demands, that the transferred throw 
consists of two of one kind and three of another kind. As an example a throw
that consists of three aces and two fives yields the sum of 3 times 1 and 2
times 5 equals 13 point.
:note.When a throw containing five alike is transferred to :hp2.Full 
house:ehp2., it yields nil.
:p.The following score-category is called :hp2.Chance:ehp2., and yields the 
sum of the dices transferred. When as an example a throw containing 1, 2, 3, 
4 and 6 is transferred, it yields 16 points. Any throw transferred to 
:hp2.Chance:ehp2. results in some points.
:p.The last score-category is the one naming the game: :hp2.Yatzee:ehp2..
When five dices of the same kind are transferred, it yields 50 points, no
matter what the dices show.
:h1 res=1003.Local area network 
:i1.Local area network
LAN is an acronym for :hp5.L:ehp5.ocal :hp5.A:ehp5.rea :hp5.N:ehp5.etwork.
This stands for a number of stand-alone computers (:hp1.clients:ehp1.)
connected to a host-computer (:hp1.server:ehp1.) via high-speed connections. 
:p.The
:link reftype=hd res=1001.server-program:elink. of the Yatzee-game 
YASERVER.EXE) must be executed on the server-computer in the local area 
network, and the name of this computer must be entered when the 
client-program of the Yatzee-game (YATZYNET.EXE) is executed on the 
clients in the network.
:h1 res=1004.The dices 
:i1.Dices
The game of Yatzee is played with five dices. Check 
:link reftype=hd res=1002.rules:elink. for a more exhaustive explanation of 
their meaning.
:p.You are able to select or deselect a dice by clicking on it with 
mousebutton 1 (normally the left button). When a dice is deselected, it does 
not participate in the next throw. A deselected dice is marked with two 
crossing lines.
:p.You throw the dices by doubleclicking with mousebutton 1 on any dice. 
:note.The dice you doubleclicks is :hp1.always:ehp1. selected and 
participates in the throw. 
:p.Under certain circumstances the game does not allow that you manipulate
the dices - for example when all three throws have been made. They are then
greyed. Under other circumstances - when you have transferred a throw or 
reset the dices - you are not allowed to deselect dices. 
:p.If you want to use the keyboard instead of the mouse for manipulating the 
dices, you can do that. See how in 
:link reftype=hd res=206.Keys help:elink..
:h1 res=1005.Acknowledgments
:i1.Acknowledgments
This program is a result of work undertaken in the period of October to 
December 1990 by Peder Madsen.
:p.Different people have more or less contributed to the program and deserves
to be mentioned:
:p.The
:link reftype=hd res=1001.server-program:elink.
is based on an article in the IBM magazine
:hp1.Personal Systems Developer:ehp1. from winter 1990 entitled 
&odq.A Multi-User Server Using Named Pipes&cdq.. This article was written by
Bryan Jackson from the company XcelleNet, Inc., Atlanta, USA.
:p.The development of the dices are inspired by an article from IBM Systems
Journal vol. 29, No. 1, 1990 entitled &odq.Effective application development
for Presentation Manager programs&cdq. by Susan Franklin and Tony Peters.
:p.Inspiration has also come from a DOS-based version of the Yatzee-game
written by Bjrn Krogh.
:p.Thanks also to my wife Mette and my two daughters Vibe and Helene, who has
spent many lonely nights, while I worked on this program.
:p.If you use this game, please send 20 USdollars to:
:xmp.
         Peder Madsen
         Dalgas Have 68, st. t.v.
         DK-2000 Frederiksberg
         Denmark, Europe
:exmp.
:p.You will then get the possibility of new versions or offerings of other
programs that I make.
:p.Please direct comments and error reports to the above address.
:p.The program is free of charge (except as mentioned above) and you may copy
the program freely. The program may not be sold or distributed commercially
or otherwise for profit. I reserve all rights and priviligies to this program. 
:p.Installation and use of this program is on your own responsibility. The 
author disclaims responsibility for any damage to your computer and its data.
:p.Please note, that I have done the translation from danish to english 
myself, and that it therefore might contain some errors. I will welcome any
corrections.
:p.Copyright (c) 1990 by Peder Madsen.
:fn id=pointtavle.
The score-board is the right part of a players child window. It constantly 
monitors the players score in each score-category. At the bottom there is a 
total, which at all times contains the sum of the players points. In this 
total, any bonus-points are included. 
:p.The line with the bonus-category (the seventh from the top) can be in two
different modes: When throws have been transferred to all the six upper 
categories, the bonus-line denotes any bonus. When not all the categories 
have received a throw, the bonus-line denotes the current status. A negative 
number means, that if bonus were to be settled now, none would be given. Zero
or a positive number means, that bonus would be given.
:p.For futher information concerning the rules for getting bonus, check 
:link reftype=hd res=1002.rules:elink..
:efn.
:euserdoc.
