/* msq5.c by K.Muroi 2004.09.30 */
#include <stdio.h>
#include <stdlib.h>

#define Ver "1.7.7"

void dispVer(void)
{
	printf("msq5 version %s\n",Ver);
	printf("Copyright (C)2004 Netstaff Co.,Inc.\n");
}

void dispUsage(void)
{
	printf("Usage   : msq5 [-aqvh] Start value (1 to 13) End value (1 to 13)\n");
	printf("                -a      (Show all magic squares)\n");
	printf("                -q      (Show quarter magic squares)\n");
	printf("                -v      (Show program version)\n");
	printf("                -h      (Show this help)\n");
	printf("example : msq5 -q 1 3\n");
}

int main(int argc, char *argv[])
{
  int N,N1,N2,nS,nE;
  int a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,sn,nOut;
  int ca,cc,ce,cg,ch,ci,cq,cr,cs,cu,cw,cy;
  int a0,a1,c0,n0,n1,n2,n3,n4,nSum0,mn,nn,n00,nn1,nMin,nMin0,nMin1,nMinS,nMax,nMax0,nMax1,nMaxS;
  int nSet[303][5],nSet4[7249][5],nLpS,nLpE,nLp4[50][2],nRes[14];
  unsigned long nBit[303],nBit4[7249],nChk,nChk0,nChk1,nChk2,nN;
  N=0;
  nOut=3;

if(argc>=2 && argc<=4 && argv[1][0]=='-'){
  if(argc>=2 && argc<=4){
    switch(argv[1][1]){  
      case 'a' :
	if(argc==2 || argc==3){
	  dispUsage();
	  exit(1);
	}
	nOut=12;
	break;
      case 'q' :
	if(argc==2 || argc==3){
	  dispUsage();
	  exit(1);
	}
	nOut=3;
	break;
      case 'v' :
	dispVer();
	exit(1);
      case 'h' :
	dispUsage();
	exit(1);
      default :
	dispVer();
	dispUsage();
	exit(1);
    }
  } else {
      dispVer();
      dispUsage();
      exit(1);
  }
} else {
      dispVer();
      dispUsage();
      exit(1);
}

if(argc==2 && argv[1][0]=='-' && argv[1][1]=='-'&& argv[1][2]=='v' && argv[1][3]=='e' && argv[1][4]=='r' && argv[1][5]=='s' && argv[1][6]=='i' && argv[1][7]=='o' && argv[1][8]=='n'){
  dispUsage();
  exit(1);
}

nS = atoi(argv[2]); /* nS:the start number of the center of 5x5 matrix given by Arg's */
nE = atoi(argv[3]); /* nE:the end number of the center of 5x5 matrix given by Arg's */
if(nS<1 || nS>13 || nE>13 || nS>nE){
  dispUsage();
  exit(1);
}

/* S̐[vŉ */
/* The iteration loop for the center */
for(N=nS;N<=nE;N++){

/* 5̘̐a65ƂȂg(tB[hŃ\[g3636g) */

/* [vJn^IJE^̏ */
/* Initialization of loop counters of start and end */
nLpS=0;
nLpE=0;
N1=0;
n0=N;
nN=1UL<<n0;

/* Making the set of five number combinations whose total is 65.(There are 7242 elements in the set sorted by the 1st field.) */
/* Making the elements that is sorted by 1st field for the 1st and 2nd loop */
  for(n1=1;n1<=25;n1++){
    for(n2=1;n2<=25;n2++){
      for(n3=1;n3<=25;n3++){
	for(n4=1;n4<=25;n4++){
	  if((n0+n1+n2+n3+n4==65) && (n0!=n1) && (n0!=n2) && (n0!=n3) && (n0!=n4) && (n1<n2) && (n2<n3) && (n3<n4)){
	    N1++;
	    nSet[N1][0]=n0;
	    nSet[N1][1]=n1;
	    nSet[N1][2]=n2;
	    nSet[N1][3]=n3;
	    nSet[N1][4]=n4;
	    if(nLpS==0){
	      nLpS=N1;
	    } else {
	      nLpE=N1;
	    }

	    nBit[N1]= nN | (1UL<<n1) | (1UL<<n2) | (1UL<<n3) | (1UL<<n4); /* 5̐1ɂ܂Ƃ߂  Five numbers are packed in a bit array. */
	  }
	}
      }
    }
  }
  
/* S[vipj2̘aŃ\[gg(vl349܂21816g) */
/* [vJn^IJE^̏ */
/* The set sorted by the sum of two numbers are made for the 4th loop. */
/* (There are 21816 elements that sum of two numbers varies from 3 to 49.) */ 
/*  Initialization of 4th loop counter */
for(nn=1;nn<=7249;nn++){
  nBit4[nn]=0;
}
for(nn1=1;nn1<=49;nn1++){
  nLp4[nn1][0]=0;
  nLp4[nn1][1]=0;
}

/* Making the elements that is sorted by the sum of 1st field and 2nd field for the 4th loop */
N1=0;
n0=N;
for(n00=3;n00<=49;n00++){
  for(n1=1;n1<=25;n1++){
    for(n2=1;n2<=25;n2++){
      for(n3=1;n3<=25;n3++){
	for(n4=1;n4<=25;n4++){
	  if((n1+n2==n00) && (n0+n1+n2+n3+n4==65) && (n0!=n1) && (n0!=n2) && (n0!=n3) && (n0!=n4) && (n1!=n2) && (n1!=n3) && (n1!=n4) && (n2!=n3) && (n2!=n4) && (n3!=n4)){
	    N1++;
	    nSet4[N1][0]=n0;
	    nSet4[N1][1]=n1;
	    nSet4[N1][2]=n2;
	    nSet4[N1][3]=n3;
	    nSet4[N1][4]=n4;
	    if(nLp4[n00][0]==0){
	      nLp4[n00][0]=N1;
	    } else {
	      nLp4[n00][1]=N1;
	    }

	    nBit4[N1]= nN | (1UL<<n1) | (1UL<<n2) | (1UL<<n3) | (1UL<<n4); /* 5̐rbgŕۑ Five numbers are packed in a bit array. */
	  }
	}
      }
    }
  }
}

/* { */
/* EΊp-->Ίp-->c-->̏4gZbg */
/* Main loop */
/* 1)left top --> right bottom , 2)right top --> left bottom , 3)vertical , 4)horizontal order of directions for loops. */
/* */
/*      5x5 matrix */
/*      a=[1].v0 b=[1].v1 c=[1].v2 d=[1].v3 e=[1].v4 */
/*      f=[2].v0 g=[2].v1 h=[2].v2 i=[2].v3 j=[2].v4 */
/*      k=[3].v0 l=[3].v1 m=[3].v2 n=[3].v3 o=[3].v4 */
/*      p=[4].v0 q=[4].v1 r=[4].v2 s=[4].v3 t=[4].v4 */
/*      u=[5].v0 v=[5].v1 w=[5].v2 x=[5].v3 y=[5].v4 */

N2=0; /* JE^NA Clear the main counter. */
m=N;  /* ̐N THe number of central element (above 'm') is set to N. */
  for(n0=nLpS;n0<=nLpE;n0++){ /* EΊp̒m=NȂOa,g,s,yZbg The number of center of lower right diagonal is m=N. And also a, g, s, and y are set. */
    ca=nSet[n0][1];
    cg=nSet[n0][2];
    cs=nSet[n0][3];
    cy=nSet[n0][4];

  for(n1=nLpS;n1<=nLpE;n1++){ /* Ίp̒S(e,i,q,u)Zbg The number of center of lower left diagonal is m=N. And also e, i, q, and u are set. */
    if(((nBit[n0] & nBit[n1])==nN) && (n1 < n0)){
      ce=nSet[n1][1];
      ci=nSet[n1][2];
      cq=nSet[n1][3];
      cu=nSet[n1][4];

    for(n2=nLpE;n2>=nLpS;n2--){ /* c̒S(c,h,r,w)Zbg The number of center of central vertical is m=N. And also c, h, r, and w are set. */
      if(((nBit[n0] & nBit[n2])==nN) && ((nBit[n1] & nBit[n2])==nN)){
	cc=nSet[n2][1];
	ch=nSet[n2][2];
	cr=nSet[n2][3];
	cw=nSet[n2][4];

/* 2{̑Ίpƒc܂̂ŁA܂Ŋm肵13̐1ɂ܂Ƃ߂ */
/* The 13 numbers determined with two diagonal lines and central vertical line are packed in a bit array. */
nChk0 = nBit[n0] | nBit[n1] | nBit[n2];

/* c̐̍ŏlAŏl̎ɏlAőlƍől̎ɑ傫l߂ */
/* The minimum value, the 2nd minimum value, the maximum value, and the 2nd maximum value are searched out of the remained 8 numbers. */
nChk = nChk0 ^ 0x3FFFFFE;
nMin0 = 0;
nMax0 = 0;
nMin1 = 0;
nMax1 = 0;
for(mn=1;mn<=25;mn++){
  nChk = nChk >> 1;
  if(nChk & 1UL){
    if(nMin0==0 && nMin1==0){
      nMin0 = mn;
    } else if(nMin0!=0 && nMin1==0){
	nMin1 = mn;
    }
    nMax1 = nMax0;
    nMax0 = mn;
  }
}

/* c̐̓A2̘̐ał傫lƏl߂ */
/* 65炻3̘̐a̍ő̒lƍŏ̒l܂ */
/* The sum of two numbers calculates the largest value and a smallest value among the remaining numbers. */
/* The maximum and minimum limits of the sum of 3 numbers are calculated with subtraction of 65 from the above sums. */
nMinS = nMin0+nMin1;
nMaxS = nMax0+nMax1;
nMin = 65 - nMaxS;
nMax = 65 - nMinS;

a=ca;
g=cg;
s=cs;
y=cy; 
/* EΊp̏Ԃς(m:ŒAa0<3Ȃ4̂PAa0<12ȂSo) */
/* Rearrangement of the elements on the lower right diagonal.(m:fixed if a0<3, the quarter of all combinations is counted. if a0<12 the whole combinations is counted.) */
	for(a0=0 ;a0<nOut ;a0++){
	  switch(a0){
	    case 0 :
	      break;
	    case 1 :
	      sn=s;
	      s=y;
	      y=sn;
	      break;
	    case 2 :
	      sn=g;
	      g=y;
	      y=sn;
	      break;
	    case 3 :
	      sn=s;
	      s=y;
	      y=sn;
	      break;
	    case 4 :
	      sn=g;
	      g=y;
	      y=sn;
	      break;
	    case 5 :
	      sn=s;
	      s=y;
	      y=sn;
	      break;
	    case 6 :
	      sn=a;
	      a=g;
	      g=sn;
	      break;
	    case 7 :
	      sn=s;
	      s=y;
	      y=sn;
	      break;
	    case 8 :
	      sn=a;
	      a=y;
	      y=sn;
	      break;
	    case 9 :
	      sn=s;
	      s=y;
	      y=sn;
	      break;
	    case 10 :
	      sn=a;
	      a=y;
	      y=sn;
	      break;
	    case 11 :
	      sn=s;
	      s=y;
	      y=sn;
	      break;
	    }

e=ce;
i=ci;
q=cq;
u=cu;
/* Ίp̏Ԃς(mFŒj */
/* Rearrangement of the elements on the lower left diagonal.(m:fixed, 12 patterns) */
	 for(a1=0;a1<12;a1++){
	   switch(a1){
	     case 0 :
	       break;
	     case 1 :
	       sn=q;
	       q=u;
	       u=sn;
	       break;
	     case 2 :
	       sn=i;
	       i=u;
	       u=sn;
	       break;
	     case 3 :
	       sn=q;
	       q=u;
	       u=sn;
	       break;
	     case 4 :
	       sn=i;
	       i=u;
	       u=sn;
	       break;
	     case 5 :
	       sn=q;
	       q=u;
	       u=sn;
	       break;
	     case 6 :
	       sn=e;
	       e=i;
	       i=sn;
	       break;
	     case 7 :
	       sn=q;
	       q=u;
	       u=sn;
	       break;
	     case 8 :
	       sn=e;
	       e=u;
	       u=sn;
	       break;
	     case 9 :
	       sn=q;
	       q=u;
	       u=sn;
	       break;
	     case 10 :
	       sn=e;
	       e=u;
	       u=sn;
	       break;
	     case 11 :
	       sn=q;
	       q=u;
	       u=sn;
	       break;
	     }

c=cc;
h=ch;
r=cr;
w=cw;
/* c̏Ԃς(mFŒj */
/* Rearrangement of the elements on the central vertical direction.(m:fixed, 24 patterns) */
	 for(c0=0;c0<24;c0++){
	   switch(c0){
	     case 0 :
	       if((a+c+e < nMin) || (a+c+e > nMax) || (u+w+y < nMin) || (u+w+y > nMax) || (g+h+i < nMin) || (g+h+i > nMax) || (q+r+s < nMin) || (q+r+s > nMax)){continue;}
	       break;
	     case 1 :
	       sn=r;
	       r=w;
	       w=sn;
	       if((u+w+y < nMin) || (u+w+y > nMax) || (q+r+s < nMin) || (q+r+s > nMax)){continue;}
	       break;
	     case 2 :
	       sn=h;
	       h=w;
	       w=sn;
	       if((g+h+i < nMin) || (g+h+i > nMax) || (u+w+y < nMin) || (u+w+y > nMax)){continue;}
	       break;
	     case 3 :
	       sn=r;
	       r=w;
	       w=sn;
	       if((u+w+y < nMin) || (u+w+y > nMax) || (q+r+s < nMin) || (q+r+s > nMax)){continue;}
	       break;
	     case 4 :
	       sn=h;
	       h=w;
	       w=sn;
	       if((g+h+i < nMin) || (g+h+i > nMax) || (u+w+y < nMin) || (u+w+y > nMax)){continue;}
	       break;
	     case 5 :
	       sn=r;
	       r=w;
	       w=sn;
	       if((u+w+y < nMin) || (u+w+y > nMax) || (q+r+s < nMin) || (q+r+s > nMax)){continue;}
	       break;
	     case 6 :
	       sn=c;
	       c=h;
	       h=sn;
	       if((a+c+e < nMin) || (a+c+e > nMax) || (g+h+i < nMin) || (g+h+i > nMax)){continue;}
	       break;
	     case 7 :
	       sn=r;
	       r=w;
	       w=sn;
	       if((u+w+y < nMin) || (u+w+y > nMax) || (q+r+s < nMin) || (q+r+s > nMax)){continue;}
	       break;
	     case 8 :
	       sn=c;
	       c=w;
	       w=sn;
	       if((a+c+e < nMin) || (a+c+e > nMax) || (u+w+y < nMin) || (u+w+y > nMax)){continue;}
	       break;
	     case 9 :
	       sn=r;
	       r=w;
	       w=sn;
	       if((u+w+y < nMin) || (u+w+y > nMax) || (q+r+s < nMin) || (q+r+s > nMax)){continue;}
	       break;
	     case 10 :
	       sn=c;
	       c=w;
	       w=sn;
	       if((a+c+e < nMin) || (a+c+e > nMax) || (u+w+y < nMin) || (u+w+y > nMax)){continue;}
	       break;
	     case 11 :
	       sn=r;
	       r=w;
	       w=sn;
	       if((u+w+y < nMin) || (u+w+y > nMax) || (q+r+s < nMin) || (q+r+s > nMax)){continue;}
	       break;
	     case 12 :
	       sn=h;
	       h=w;
	       w=sn;
	       if((g+h+i < nMin) || (g+h+i > nMax) || (u+w+y < nMin) || (u+w+y > nMax)){continue;}
	       break;
	     case 13 :
	       sn=r;
	       r=w;
	       w=sn;
	       if((u+w+y < nMin) || (u+w+y > nMax) || (q+r+s < nMin) || (q+r+s > nMax)){continue;}
	       break;
	     case 14 :
	       sn=h;
	       h=w;
	       w=sn;
	       if((g+h+i < nMin) || (g+h+i > nMax) || (u+w+y < nMin) || (u+w+y > nMax)){continue;}
	       break;
	     case 15 :
	       sn=r;
	       r=w;
	       w=sn;
	       if((u+w+y < nMin) || (u+w+y > nMax) || (q+r+s < nMin) || (q+r+s > nMax)){continue;}
	       break;
	     case 16 :
	       sn=c;
	       c=r;
	       r=sn;
	       if((a+c+e < nMin) || (a+c+e > nMax) || (q+r+s < nMin) || (q+r+s > nMax)){continue;}
	       break;
	     case 17 :
	       sn=r;
	       r=w;
	       w=sn;
	       if((u+w+y < nMin) || (u+w+y > nMax) || (q+r+s < nMin) || (q+r+s > nMax)){continue;}
	       break;
	     case 18 :
	       sn=h;
	       h=w;
	       w=sn;
	       if((g+h+i < nMin) || (g+h+i > nMax) || (u+w+y < nMin) || (u+w+y > nMax)){continue;}
	       break;
	     case 19 :
	       sn=r;
	       r=w;
	       w=sn;
	       if((u+w+y < nMin) || (u+w+y > nMax) || (q+r+s < nMin) || (q+r+s > nMax)){continue;}
	       break;
	     case 20 :
	       sn=c;
	       c=r;
	       r=sn;
	       if((a+c+e < nMin) || (a+c+e > nMax) || (q+r+s < nMin) || (q+r+s > nMax)){continue;}
	       break;
	     case 21 :
	       sn=r;
	       r=w;
	       w=sn;
	       if((u+w+y < nMin) || (u+w+y > nMax) || (q+r+s < nMin) || (q+r+s > nMax)){continue;}
	       break;
	     case 22 :
	       sn=h;
	       h=w;
	       w=sn;
	       if((g+h+i < nMin) || (g+h+i > nMax) || (u+w+y < nMin) || (u+w+y > nMax)){continue;}
	       break;
	     case 23 :
	       sn=r;
	       r=w;
	       w=sn;
	       if((u+w+y < nMin) || (u+w+y > nMax) || (q+r+s < nMin) || (q+r+s > nMax)){continue;}
	       break;
	     }

/* 9̐̂Aml,n̘aPvZ */
/* 2̘aȂ̂nMinSȏAnMaxSȉł */
/* The sum of undecided 'l' and 'n' is calculated from the identity out of central nine numbers. */
/* < a + e + u + y + 65 = g + h + i + l + m + n + q + r + s > */
/* It must be no more than nMaxS and no less than nMinS. */
    nSum0= 65+a+e+u+y-g-h-i-m-q-r-s;
	if((nSum0 < nMinS) || (nSum0 > nMaxS)){continue;}

/* l,n̘a̒lŒɓg̃[v͈͂iŁAɍvgTAS(k,l,n,o)Zbg */
/* nSum0 determines the sum of 'l' and 'n'. And that it narrows down the range of the sets, nSet4 , using the index value nLp4. */
/* hrough the above range, the sets for the central horizontal direction are searched. */
/* ote that nSum0 is equal to the sum of  'l' and 'n', and nLp4 points the start and end of nSet4, that is sorted by that sum. */
      for(n4=nLp4[nSum0][0];n4<=nLp4[nSum0][1];n4++){ 
	if(((nBit4[n4] & nBit[n0])==nN) && ((nBit4[n4] & nBit[n1])==nN) && ((nBit4[n4] & nBit[n2])==nN)){
	  l=nSet4[n4][1];
	  n=nSet4[n4][2];
	  k=nSet4[n4][3];
	  o=nSet4[n4][4];

/* ܂Ŋm肵17̐ɂ܂Ƃ߂ */
/* The 17 numbers determined above are packed into a bit array. */
    nChk1 = nChk0 | nBit4[n4];

/* c̕ӂ𖄂߂ibf[vŉ񂵎c͌vZŋ߂j */
/* ܂xɏd`FbNpɃrbgɉĂ */
/* Determining the remained variables. With iteration of both 'b' and 'f', the others are calculated and checked. */
  for(b=nMin0,d=65-a-b-c-e,v=65-b-g-l-q,x=65-u-v-w-y;b<=nMax0;b++,d--,v--,x++){
    if((nChk1 & (1UL<<b)) || (nChk1 & (1UL<<d)) || (nChk1 & (1UL<<v)) || (nChk1 & (1UL<<x))){continue;}
    if((d<nMin0) || (d>nMax0) || (v<nMin0) || (v>nMax0) || (x<nMin0) || (x>nMax0)){continue;}  
    if((b==d) || (b==v) || (b==x) || (d==v) || (d==x) || (v==x)){continue;}
/* When the remained variables are turned, the sets of five numbers are set into the bit array for the duplication check. */
    nChk2 = nChk1 | (1UL<<b)  | (1UL<<d) | (1UL<<v) | (1UL<<x);

    for(f=nMax0,p=65-a-f-k-u,j=65-f-g-h-i,t=65-e-j-o-y;f>=nMin0;f--,p++,j++,t--){
      if((nChk2 & (1UL<<f)) || (nChk2 & (1UL<<p)) || (nChk2 & (1UL<<j)) || (nChk2 & (1UL<<t))){continue;}
      if((p<nMin0) || (p>nMax0) || (j<nMin0) || (j>nMax0) || (t<nMin0) || (t>nMax0)){continue;}  
      if((f==p) || (f==j) || (f==t) || (p==j) || (p==t) || (j==t)){continue;}

  N2++;

/* 1000Ƃɉʕ\ */
/* The number of the counter is shown at every 1000 combinations. */
  if(N2 % 1000 == 0){
     printf("%d\n", N2);
     printf("%2d %2d %2d %2d %2d\n",a,b,c,d,e);
     printf("%2d %2d %2d %2d %2d\n",f,g,h,i,j);
     printf("%2d %2d %2d %2d %2d\n",k,l,m,n,o);
     printf("%2d %2d %2d %2d %2d\n",p,q,r,s,t);
     printf("%2d %2d %2d %2d %2d\n",u,v,w,x,y);
     printf("\n");
  }

		       }
		     }
		   }
		 }
		}
	      }
	    }
	  }
	}
      }
    }
  }
/* JEglzɓ */
/* The count value is set into the array. */
  nRes[m]=N2;
}
  for(n0=nS;n0<=nE;n0++){ 
    printf("Found %d msqs at center = %d\n",nRes[n0],n0);
  }
     return 1;
}

