# changelog.py
#   Take a changelog and turn some section of it into HTML

# Format:
#   Changelog entries are stored in reverse order (newest at the top)
#
#   ***YYYY        change year
#   ***MMMMM DD    change month & day entry
#     ...          comment for this date
#   *...           start a new entry

import string, time, sys
from regex import match

monthnames = map( lambda m: time.strftime('%B',(1996,m+1,1,0,0,0,0,1,0)), range(12) )
monthregex = '\\(' + reduce( lambda x,y: x+'\\|'+y, monthnames ) + '\\)'

def date_to_time(y,m,d):
    return time.mktime(y,m,d,0,0,0,0,1,0)

def produce_footer():
    print '<font size=-1>[<a href="mailto:amitp@cs.stanford.edu">Comments, suggestions, gripes?</a>'
    print '  | <a href="http://www-cs-students.stanford.edu/~amitp/games.html">Back to SimBlob</a>'
    print '  | <a href="http://www-cs-students.stanford.edu/~amitp/">Amit'+"'"+'s Home Page</a> ]</font><br>'
    print '<!-- This file was generated by a utility Amit wrote; ask if you are interested -->'

def produce_table(filename,log,start,end,header,title):
    # Now print out the whole thing in table format
    print '<html>'
    print '<head>'
    print '<title>'+title+'</title>'
    print '</head>'
    print '<body background="blob_border.gif" text="#000000" bgcolor="#ffffff" link="#800000" vlink="#804040">'
    print '<table width="100%"><tr><td align=right><font face="Vendana,Helvetica,Arial" size="+3"><i>'+header+'</i></font></td></tr></table>'
    print '<table width="100%" cellspacing=0 cellpadding=0><tr><td><img src="spacer.gif"></td><td bgcolor="#f2f2ba">'
    print '<table width="100%" cellspacing=1 cellpadding=3>'
    start = apply(date_to_time,start)
    end = apply(date_to_time,end)

    for ((year,mon,day),ss) in log:
	tm = date_to_time(year,mon,day)
	if (len(ss) > 1 or len(ss[0]) > 1) and (start < tm <= end):
	    print '<tr><td bgcolor="#fefeee" colspan=2 align=center><font size="+2">',day,monthnames[mon-1],year,'</font></td></tr>'
	    if len(ss[0])>1:
		note,rest = '&nbsp;',ss[0]
		r = match('[ \r\n]*<[bB]> *Note: *</[bB]>',rest)
		if r >= 0: note,rest = rest[:r], rest[r:]
		print '<tr><td align=right valign=top bgcolor="#fefeee">'+note+'</td><td bgcolor="#ffffff">',rest,'</td></tr>'
	    counter = 0
	    for s in ss[1:]:
		counter = counter+1
		tag = `counter`+':'
		m = match('([^)]+)',s)
		if m >= 0:
		    tag,s = tag+'<br><font size=-2>'+s[:m]+'</font>', s[m:]
		print '<tr><td bgcolor="#fefeee" valign=top align=right>',tag+'</td><td bgcolor="#ffffff" valign=top>',s,'</td></tr>'
		
    print '</table>'
    print '</td></tr></table>'

    # Footer
    print '<table width="100%"><tr><td><img src="spacer.gif"></td><td>'
    print '<center>'
    print '<font size=-1>A <a href="'+filename+'_text.html">simpler version</a> is also available that uses standard HTML.</font><br>'
    produce_footer()
    print '</center>'
    print '</td></tr></table>'
    print '</body>'
    print '</html>'


def produce_text(filename,log,start,end,header,title):
    # Now print out the whole thing in text format
    print '<html>'
    print '<head>'
    print '<title>'+title+'</title>'
    print '</head>'
    print '<body>'
    print '<h1>'+header+'</h1>'
    start = apply(date_to_time,start)
    end = apply(date_to_time,end)

    for ((year,mon,day),ss) in log:
	tm = date_to_time(year,mon,day)
	if (len(ss) > 1 or len(ss[0]) > 1) and (start < tm <= end):
	    print '<h3>',day,monthnames[mon-1],year,'</h3>'
	    print ss[0]
	    print '<UL>'
	    for s in ss[1:]:
		print '  <LI>',s
	    print '</UL><P>'

    produce_footer()
    print '</body>'
    print '</html>'

   
def produce_log(infile,outfile,start,end,header,title):
    (year,mon,day) = time.localtime(time.time())[0:3]
    f = open(infile,'r')
    lines = f.readlines()

    # log is a list of (date,list of strings)
    log = [ ((year,mon,day),['']) ]

    for s in lines:
	m = match('\*\*\*'+monthregex+' +',s)
	if match('\*\*\*[0-9]+',s) >= 0:
	    # Extract the year
	    year = string.atoi(s[3:])

	elif m >= 0:
	    # Extract the month
	    monname = string.strip(s[3:m])
	    for i in range(12):
		if monname == monthnames[i]:  mon = 1+i
		
	    # Extract the day
	    day = string.atoi(s[m:])

	    # Add new major entry to the log
	    log.append( ((year,mon,day),['']) )

	elif match('\*[^*]',s) >= 0:
	    # Start a new minor item
	    log[-1][1].append(s[1:])

	else:
	    # Append to current minor item
	    log[-1][1][-1] = log[-1][1][-1] + s

    oldout = sys.stdout
    sys.stdout = open(outfile+'.html','w')
    produce_table(outfile,log,start,end,header,title)
    sys.stdout = open(outfile+'_text.html','w')
    produce_text(outfile,log,start,end,header,title)
    sys.stdout = oldout

def back_time(t,months):
    while months > 0:
	if t[1] == 1:
	    t = (t[0]-1,12,t[2])
	else:
	    t = (t[0],t[1]-1,t[2])
	months = months-1
    return t

a = time.localtime(time.time())[0:3]
b = back_time(a,1)
c = back_time(b,3)
d = (1995,1,1)

produce_log('changes.txt','whats_new',b,a,"What's New with SimBlob","SimBlob: What's New")
produce_log('changes.txt','changes',c,b,"List of Recent Changes","SimBlob: List of Recent Changes")
produce_log('changes.txt','old_changes',d,c,"List of Older Changes","SimBlob: List of Older Changes")

