//=======================================================================
//@V@:Note: This file generated by vgen V1.02 (04:22:44 PM 04 Feb 1997).
//	wlncmdw.cpp:	Source for wlnCmdWindow class
//=======================================================================

////////////////////////////////////////////////////////////////////////////
// This file is a module in the program Zero Point, a video game program  //
// for Linux X11 and Windows.                                             //
//                                                                        //
// Copyright (C) 1996, 1997, 1998 by Enumerate Inc.                       //
//                                                                        //
// Enumerate Inc. can be contacted at enumerate@rocketmail.com            //
//                                                                        //
// This file is licensed within the terms of the GNU General Public       //
// License version 2 or later. This source code may freely redistributed  //
// or modified within the terms of that license, as described in the file //
// 'COPYING' which should be included with any redistribution of this     //
// file. If the file COPYING is not available, a copy of the General      //
// Public License can be obtained from the Free Software Foundation, Inc. //
// 675 Mass Ave., Cambridge, MA 02139.                                    //
//                                                                        //
// THIS PROGRAM IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER  //
// EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED       //
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.    //
// THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS    //
// WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF  //
// ALL NECESSARY SERVICING, REPAIR OR CORRECTION.                         //
//////////////////////////////////////////////////////////////////////////// 


#include <v/vnotice.h>	// for vNoticeDialog
//#include <v/vynreply.h> // for vYNReplyDialog
#include <v/vkeys.h>	// to map keys

#include "wlnapp.h"
#include "wlnynmdg.h"   //wlnYNDialog
#include "wlncmdw.h"	// our header
#include "wlndefs.h"    // handy def's
#include "wlhimdlg.h"

//@V@:BeginPulldownMenu FileMenu
static vMenu FileMenu[] =
{
  {"&New", M_New, isSens, notChk, noKeyLbl, noKey, noSub},
  {"&Open...", M_Open, isSens, notChk, noKeyLbl, noKey, noSub},
  {"&Save", M_Save, isSens, notChk, noKeyLbl, noKey, noSub},
  {"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
  {"E&xit", M_Exit, isSens, notChk, noKeyLbl, noKey, noSub},
  {NULL}
};
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu EditMenu
static vMenu GameMenu[] =
{
  //  {"Restart at level &10 ", WLN_NewGame10, isSens, notChk, "Ctrl-N", 'N'-'@', noSub},
  {"&Restart this level ", WLN_RestartLevel, isSens, notChk, "Ctrl-R", 'R'-'@', noSub},
  {"Start &Demo", btnDemo, isSens, notChk, "Ctrl-D", 'D'-'@', noSub},
  {"P&ractice Mode", mnuPractice, isSens, notChk, noKeyLbl, noKey, noSub},
  {"&Pause", mnuPause, isSens, notChk, "P", noKey, noSub},
  {"Show &High Scores", mnuHigh, isSens, notChk, noKeyLbl, noKey, noSub},
  {NULL}
};
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu TestDialog
static vMenu OptionsMenu[] =
{
  {"Set &Options", mnuSetOptions, isSens, notChk, noKeyLbl, noKey, noSub},
  {"&Save Options", mnuSaveOpts, isSens, notChk, noKeyLbl, noKey, noSub},
  {NULL}
};
//@V@:EndPulldownMenu

// static vMenu DemoMenu[] =
// {
//   {"&Run Demo", btnStartDemo, isSens, notChk, noKeyLbl, noKey, noSub},
//   {NULL}
// };

//@V@:BeginMenu StandardMenu
static vMenu StandardMenu[] =
{
  {"&File", M_File, isSens, notUsed, notUsed, noKey, &FileMenu[0]},
  {"&Game", M_Game, isSens, notUsed, notUsed, noKey, &GameMenu[0]},
  {"&Options", M_Options, isSens, notUsed, notUsed, noKey, &OptionsMenu[0]},
  //  {"&Demo", M_Demo, isSens, notUsed, notUsed, noKey, &DemoMenu[0]},
  {NULL}
};
//@V@:EndMenu

//@V@:BeginStatPane StatBar
static vStatus StatBar[] =
{
  {"Level:", lblLvlStat, CA_NoBorder, isSens, 0},
  {"000", lvlStat, CA_None, isSens, 0},
  {"Total:", lblScrStat, CA_NoBorder, isSens, 0},
  {"0000000", scrStat, CA_None, isSens, 0},
  {"This level:", lblBonStat, CA_NoBorder, isSens, 0},
  {"00000", bonStat, CA_None, isSens, 0},
  {"Lives:", lblLivStat, CA_NoBorder, isSens, 0},
  {"00", liveStat, CA_None, isSens, 0},
  {" Esc: quit  P: pause", lblEscStat, CA_NoBorder, isSens, 0},
  //{"0",clrStat, CA_None, isSens, 20},
  {0,0,0,0,0}
};
//@V@:EndStatPane

//====================>>> wlnCmdWindow::wlnCmdWindow <<<====================
wlnCmdWindow::wlnCmdWindow(char* name, int width, int height) :
  vCmdWindow(name, width, height)
{
  UserDebug1(Constructor,"wlnCmdWindow::wlnCmdWindow(%s) Constructor\n",name)

    // The Menu Bar
    wlnMenu = new vMenuPane(StandardMenu);
  AddPane(wlnMenu);

  // The Canvas
  wlnCanvas = new wlnCanvasPane;
  AddPane(wlnCanvas);

  // The Status Bar
  wlnStatus = new vStatusPane(StatBar);
  AddPane(wlnStatus);

  // Associated dialogs

  wlnMDlg = new wlnModalDialog(this);
  wlnShareDlg = new wlnShare(this);
  demoDlg = new wDemModalDialog(this);
  hiDlg = new wlnHiModalDialog(this);
  optDlg = new optModalDialog(this);
    
  if(!(wlnMDlg && wlnShareDlg && demoDlg && optDlg)){
    ((wlnApp*)theApp)->tellIt("Trouble allocating memory in Command Window constructor.");
    ((wlnApp*)theApp)->Exit();
  }

  // Show Window

  ShowWindow();
  ((wlnApp*)theApp)->nextLevel();
}

//====================>>> wlnCmdWindow::~wlnCmdWindow <<<====================
wlnCmdWindow::~wlnCmdWindow()
{
  UserDebug(Destructor,"wlnCmdWindow::~wlnCmdWindow() destructor\n")

    // Now put a delete for each new in the constructor.

    delete wlnMenu;
  delete wlnCanvas;
  delete wlnStatus;
  delete wlnMDlg;
  delete wlnShareDlg;
  delete demoDlg;
  delete hiDlg;
  delete optDlg;
}

//====================>>> wlnCmdWindow::KeyIn <<<====================
void wlnCmdWindow::KeyIn(vKey keysym, unsigned int shift)
{

  vCmdWindow::KeyIn(keysym, shift);
}

//====================>>> wlnCmdWindow::WindowCommand <<<====================
void wlnCmdWindow::WindowCommand(ItemVal id, ItemVal val, CmdType cType)
{
  // Default: route menu and toolbar commands here
  wlnYNDialog* Really;
  int theReply, stp;
  vNoticeDialog note(this);


  UserDebug1(CmdEvents,"wlnCmdWindow:WindowCommand(%d)\n",id)

    switch (id)
      {

	//@V@:Case M_Exit
//       case M_Exit:
// 	{
// 	  theApp->Exit();
// 	  break;
// 	}	//@V@:EndCase
	
       case mnuSetOptions:
	stp = ((wlnApp*)theApp)->stepQ();
	if(stp) ((wlnApp*)theApp)->pause(true);
	//SetValueAll(mnuPause, true, Checked);
	optDlg->optAction("Set Options");
	if(stp)((wlnApp*)theApp)->pause(false);
	break;
      case mnuSaveOpts:
	stp = ((wlnApp*)theApp)->stepQ();
	if(stp) ((wlnApp*)theApp)->stepOff();
	if(((wlnApp*)theApp)->practicing()){
	  note.Notice("Can't save options while practicing.");
	} else {
	  if(((wlnApp*)theApp)->writerc()){  //returns 1 on failure
	    note.Notice("File problem: Options not saved");
	  } else {
	    note.Notice("Options saved");
	  }
	}
	if(stp)((wlnApp*)theApp)->stepOn();
	break;
      default:		// route unhandled commands up
	{
	  vCmdWindow::WindowCommand(id, val, cType);
	  break;
	}
      }
}

int wlnCmdWindow::showHi(){
  wlnHiModalDialog* hiStuff = new wlnHiModalDialog(this);
  hiStuff->wlnHiAction("High Scores");
  delete hiStuff;
}

void wlnCmdWindow::runTheDemo(){ 
  demoDlg->wDemAction("ZeroPoint Demo Dialog");
}
