/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/
/*
 * ed_map.c - Xened
 */

#include "xened.h"

/*************************************************************************/

extern PSZ         *rgpsz;
extern GADGET      rggad[];
extern PTILEBOX    ptboxFont;
extern CHAR        g_pszErr[];

/*************************************************************************/

PTILEBOX ptboxMap;

VOID EditSectorMap (PGADGETLIST pgadlist, PSZ pszPath, USHORT usSector)
{
    CHAR     pszFilename[256], dstring[31];
    SHORT    kcode, y_pos = YS_MAP-WIN_YS, old_y = y_pos+1;
    SHORT    action, mpress[2];
    USHORT   rgusMap[YS_MAP][XS_MAP];
    USHORT   cx = 0, cy = YS_MAP-1, tile_num = 0, old_tn = tile_num+1;
    USHORT   x, y;
    FILE     *pfile;
#ifdef _MOUSE_
    SHORT    mx[2], my[2];
#endif
    BYTE     rgb[YS_TILE*XS_TILE];

    mpress[0] = mpress[1] = 0;

    /*** Load map ***/
    sprintf (pszFilename, "%s%cs%1d%c%s", pszPath,DIR_SEPERATOR_CHAR,
             usSector+1, DIR_SEPERATOR_CHAR, MAPFILE_N);
#ifdef _DEBUG_
    message ("Loading map ...", MAGENTA, MSG_X, MSG_Y);
#endif
    if (! load_xenon_map (pszFilename, rgusMap))
        return;
#ifdef _DEBUG_
    message ("Done map.", MAGENTA, MSG_X, MSG_Y);
#endif

    sprintf (pszFilename, "%s%cs%1d%c%s", pszPath, DIR_SEPERATOR_CHAR,
             usSector+1, DIR_SEPERATOR_CHAR, TILEFILE_N);
#ifdef _DEBUG_
    message ("Loading map-tiles ...", MAGENTA, MSG_X, MSG_Y);
#endif
    /*** Load map-tiles ***/
    if (! (ptboxMap = LoadMapTiles (pszFilename, &pfile)))
        return;
#ifdef _DEBUG_
    message ("Done tiles.", MAGENTA, MSG_X, MSG_Y);
#endif

    /*** Draw stuff ***/
    draw_stone (0, 160, 319, 199, LIGHTGRAY, WHITE, DARKGRAY);
    GFX_BOX (rggad[3].x1, rggad[3].y1, rggad[3].x2, rggad[3].y2, BLACK);
    draw_stone (194, 163, 243, 197, BLACK, WHITE, DARKGRAY);

    gadlist_draw (pgadlist);

    sprintf (dstring, "Sector %d", usSector+1);
    show_string (ptboxFont, dstring, 197, 166, 45);
    sprintf (dstring, rgpsz[TXT_Y_COOR]);
    show_string (ptboxFont, dstring, 197, 174, 45);
    
    do
    {
        /*** Shift map? ***/
        if (y_pos != old_y)
        {
            if (cy < y_pos)
                cy = y_pos;
            if (cy > y_pos+WIN_YS-1)
                cy = y_pos+WIN_YS-1;

            display_xenon_map (rgusMap, 0,y_pos, 0,0, WIN_XS,WIN_YS, pfile,
                               cx,cy, TRUE);
            old_y = y_pos;
        }
        else
            display_xenon_map (rgusMap, cx,cy, cx*XS_TILE, (cy-y_pos)*YS_TILE,
                               1,1, pfile, cx,cy, TRUE);

        /*** Show cursor-y-coordinate ***/
        sprintf (dstring, "%03d/%03d", cy+1, YS_MAP);
        show_string (ptboxFont, dstring, 197, 180, 45);
        
        /*** Redisplay tile-palette ***/
        if (tile_num != old_tn)
        {
            USHORT   tile_start = (tile_num/(XC_TILES*2))*(XC_TILES*2);
            USHORT   cur_tile = tile_start;
            
            for (y = 0; y < YC_TILES; y++)
                for (x = 0; x < XC_TILES; x++)
                {
                    if (cur_tile < ptboxMap->cTiles)
                    {
#ifdef _PRELOAD_TILES_
                        if (ptboxMap)
                            show_tile (ptboxMap, cur_tile, 23+x*(XS_TILE+1),
                                       164+y*(YS_TILE+1));
                        else
#endif
                        {
                            fseek (pfile, cur_tile*SIZEOF_MAPTILE, SEEK_SET);
                            read_xenon_tile (pfile, rgb);
                            show_tile_raw (rgb, XS_TILE,YS_TILE, 23+x*17,
                                           164+y*17);
                        }
                        
                        /** Draw 'cursor' ***/
                        if (cur_tile == tile_num)
                            GFX_RECT (24+x*(XS_TILE+1), 165+y*(YS_TILE+1),
                                      24+x*(XS_TILE+1)+13, 165+y*(YS_TILE+1)+13,
                                      LIGHTGREEN);
                    }
                    else
                    {
                        GFX_BOX (23+x*(XS_TILE+1), 164+y*(YS_TILE+1),
                                 23+x*(XS_TILE+1)+15, 164+y*(YS_TILE+1)+15,
                                 DARKGRAY);
                    }
                    cur_tile ++;
                }
            
            old_tn = tile_num;
        }

#ifdef _MOUSE_
        ShowMCursor ();
        mpress[0] = mpress[1] = 0;
#endif
        kcode = -1;
        do
        {
            /*** Check for any user activities (keyboard,mouse) ***/
            kcode = _read_kbd (0, 0, 0);
            if (kcode == 0)
                kcode = _read_kbd (0, 0, 0);

            do_stars (0, 160, 319, 199);
            
#ifdef _MOUSE_ /*fold00*/
            else
            {
                mpress[0] = GetMBPresses (0,&mx[0],&my[0]);
                mpress[1] = GetMBPresses (1,&mx[1],&my[1]);
            }
#endif /*FOLD00*/
        }
        while ((kcode == -1) && (mpress[0] == 0) && (mpress[1] == 0));
#ifdef _MOUSE_
        HideMCursor ();
#endif
        action = -1;
        
        /*** Clear gadget-0-cursor ***/
        display_xenon_map (rgusMap, cx,cy, cx*XS_TILE, (cy-y_pos)*YS_TILE,
                           1,1, pfile, cx,cy, FALSE);

        /*** Check what action user wants ***/
        if (kcode != -1)
        {
            switch (kcode)
            {
            case C_UP:
                if (pgadlist->pgad == &rggad[3])
                    action = ACT_TILES_UP;
                else
                    action = ACT_CURSOR_UP;
                break;

            case C_DOWN:
                if (pgadlist->pgad == &rggad[3])
                    action = ACT_TILES_DOWN;
                else
                    action = ACT_CURSOR_DOWN;
                break;

            case C_LEFT:
                if (pgadlist->pgad == &rggad[3])
                    action = ACT_TILES_PREV;
                else
                    action = ACT_CURSOR_LEFT;
                break;

            case C_RIGHT:
                if (pgadlist->pgad == &rggad[3])
                    action = ACT_TILES_NEXT;
                else
                    action = ACT_CURSOR_RIGHT;
                break;

            case PAGE_UP:    action = ACT_MAP_PAGE_UP;     break;
            case PAGE_DOWN:  action = ACT_MAP_PAGE_DOWN;   break;
            case C_HOME:     action = ACT_MAP_HOME;        break;
            case C_END:      action = ACT_MAP_END;         break;
            case 27:         action = ACT_QUIT;            break;
            case 's':        action = ACT_SAVE_MAP;        break;
            case ' ':        action = ACT_MAP_SET_FIELD;   break;
            case '+':        action = ACT_TILES_NEXT;      break;
            case '-':        action = ACT_TILES_PREV;      break;
            case 9:          action = ACT_GADGET_NEXT;     break;
            case K_BACKTAB:  action = ACT_GADGET_PREV;     break;
            case K_DEL:      action = ACT_MAP_CLEAR_FIELD; break;
            
            case 13:
                if (pgadlist->pgad == &rggad[0])
                    action = ACT_MAP_SET_FIELD;
                else
                    action = ACT_GADGET_SHOOT;
                break;
            }
        }
#ifdef _MOUSE_ /*fold00*/
        else
        {
            /*** Left mb hit ***/
            if (mpress[0] != 0)
            {
                mx[0] = mx[0]/2;
                if (my[0] < 160)
                {
                    rgusMap[y_pos+my[0]/YS_TILE][mx[0]/XS_TILE] = cur_tile*64;
                    display_xenon_map (rgusMap,mx[0]/XS_TILE,y_pos+my[0]/YS_TILE
                                                        ,mx[0]/XS_TILE*XS_TILE,my[0]/YS_TILE*YS_TILE,1,1,vga_file);
                    DoSound (100,5);
                }
                else
                {
                    for (i = 0; i < a_gadgets; i++)
                        if ((mx[0] >= gadgets[i][0]) && (mx[0] <= gadgets[i][2]) &&
                                (my[0] >= gadgets[i][1]) && (my[0] <= gadgets[i][3]))
                            break;

                    if (i < a_gadgets)
                    {
                        HideMCursor ();
                        ShadowRect (gadgets[i][0],gadgets[i][1],gadgets[i][2],gadgets[i][3]
                                             ,DARKGRAY,WHITE);
                        delay (100);
                        ShadowRect (gadgets[i][0],gadgets[i][1],gadgets[i][2],gadgets[i][3]
                                             ,WHITE,DARKGRAY);
                        ShowMCursor ();
                    }

                    switch (i)
                    {
                    case 10:
                        // FIXME  cur_tile <-> tile_num
                        cur_tile = tile_num;
                        cur_tile += (my[0]-gadgets[10][1])/17*13 + (mx[0]-gadgets[10][0])/17;

                        if (cur_tile >= ptboxMap->cTiles)
                            cur_tile = 0;
                        break;

                    case 9:
                        kcode = ESC;
                        break;

                    case 8:
                        strcpy (file_n,argv[2]);
                        save_xenon_map (file_n,map);
                        break;

                    case 6:
                        y_pos = 0;
                        break;

                    case 7:
                        y_pos = YS_MAP-WIN_YS;
                        break;

                    case 4:
                        if (y_pos >= WIN_YS)
                            y_pos -= WIN_YS;
                        break;

                    case 5:
                        if (y_pos < YS_MAP-WIN_YS-WIN_YS+1)
                            y_pos += WIN_YS;
                        break;

                    case 2:
                        if (y_pos > 0)
                            y_pos--;
                        break;

                    case 3:
                        if (y_pos < YS_MAP-WIN_YS)
                                y_pos++;
                        break;

                    case 1:
                        if (tile_num+26 < ptboxMap->cTiles)
                            tile_num += 26;
                        break;

                    case 0:
                        if (tile_num >= 26)
                            tile_num -= 26;
                        break;

                    default:
                        break;
                    }
                }
            }
            else if (mpress[1] != 0)
            {
                mx[1] = mx[1]/2;
                if (my[1] < 160)
                {
                    rgusMap[y_pos+my[1]/YS_TILE][mx[1]/XS_TILE] = 0;
                    display_xenon_map (rgusMap,mx[1]/XS_TILE,y_pos+my[1]/YS_TILE
                                       ,mx[1]/XS_TILE*XS_TILE,my[1]/YS_TILE*YS_TILE,1,1,vga_file);
                    DoSound (100,5);
                }
            }
        }
#endif /*FOLD00*/

        /*** Anything to do with the gadgets? ***/
        switch (action)
        {
        case ACT_GADGET_NEXT:
            gadlist_next (pgadlist);
            break;
 
        case ACT_GADGET_PREV:
            gadlist_prev (pgadlist);
            break;

        case ACT_GADGET_SHOOT:
            action = gadlist_shoot (pgadlist);
            break;
        }

        /*** Make action ***/
        switch (action)
        {
        case ACT_MAP_SET_FIELD:
            rgusMap[cy][cx] = tile_num*64;
            display_xenon_map (rgusMap, cx,cy, cx*XS_TILE, (cy-y_pos)*YS_TILE,
                               1,1, pfile, cx,cy, TRUE);
            break;
            
        case ACT_TILES_PAGE_UP:
            if (tile_num >= XC_TILES*YC_TILES)
                tile_num -= XC_TILES*YC_TILES;
            break;

        case ACT_TILES_PAGE_DOWN:
            if (tile_num+XC_TILES*YC_TILES < ptboxMap->cTiles)
                tile_num += XC_TILES*YC_TILES;
            break;
            
        case ACT_MAP_UP:
            if (y_pos > 0)
            {
                y_pos --;
                cy--;
            }
            break;

        case ACT_MAP_DOWN:
            if (y_pos < YS_MAP-WIN_YS)
            {
                y_pos ++;
                cy ++;
            }
            break;

        case ACT_MAP_PAGE_UP:
            if (y_pos >= WIN_YS)
            {
                y_pos -= WIN_YS;
                cy -= WIN_YS;
            }
            break;

        case ACT_MAP_PAGE_DOWN:
            if (y_pos < YS_MAP-WIN_YS-WIN_YS+1)
            {
                y_pos += WIN_YS;
                cy += WIN_YS;
            }
            break;

        case ACT_MAP_HOME:
            y_pos = 0;
            cy = y_pos;
            break;

        case ACT_MAP_END:
            y_pos = YS_MAP-WIN_YS;
            cy = y_pos;
            break;

        case ACT_SAVE_MAP:
            if (save_xenon_map (pszFilename, rgusMap))
            {
                sprintf (pszFilename, "%s%cs%1d%c%s", pszPath,
                         DIR_SEPERATOR_CHAR, usSector+1, DIR_SEPERATOR_CHAR,
                         MAPFILE_N);
                sprintf (g_pszErr, rgpsz[TXT_WROTE_MAP_TO_FILE_X], pszFilename);
                message (g_pszErr, GREEN, MSG_X, MSG_Y);
            }
            break;

        case ACT_QUIT:
            kcode = ESC;
            break;

        case ACT_MAP_CLEAR_FIELD:
            rgusMap[cy][cx] = 0;
            display_xenon_map (rgusMap, cx,cy, cx*XS_TILE, (cy-y_pos)*YS_TILE,
                               1,1, pfile, cx,cy, TRUE);
            break;

        case ACT_TILES_NEXT:
            if (tile_num < ptboxMap->cTiles-1)
                tile_num ++;
            break;

        case ACT_TILES_PREV:
            if (tile_num > 0)
                tile_num --;
            break;
            
        case ACT_TILES_UP:
            if (tile_num >= XC_TILES)
                tile_num -= XC_TILES;
            break;

        case ACT_TILES_DOWN:
            if (tile_num < ptboxMap->cTiles-XC_TILES)
                tile_num += XC_TILES;
            break;

        case ACT_CURSOR_UP:
            if (cy > 0)
                cy --;
            if (cy < y_pos)
                y_pos = cy;
            break;

        case ACT_CURSOR_DOWN:
            if (cy < YS_MAP-1)
                cy ++;
            if (cy >= y_pos+WIN_YS)
                y_pos = cy-WIN_YS+1;
            break;

        case ACT_CURSOR_LEFT:
            if (cx > 0)
                cx --;
            break;

        case ACT_CURSOR_RIGHT:
            if (cx < XS_MAP-1)
                cx ++;
            break;
        }
    }
    while (kcode != ESC);

    if (pfile)
        fclose (pfile);

#ifdef _PRELOAD_TILES_
    if (ptboxMap)
        delete_tilebox  (ptboxMap);
#endif
}
/*************************************************************************/

PTILEBOX LoadMapTiles (PSZ pszFilename, FILE **ppfile)
{
    FILE       *pfile;
    USHORT     cTiles;
#ifdef _PRELOAD_TILES_
    USHORT     i;
    PVOID      pv;
#endif
    PTILEBOX   ptbox = NULL;

    *ppfile = NULL;
#ifdef _DEBUG_
    message ("Into L.M.T.", MAGENTA, MSG_X, MSG_Y);
#endif
    
    /*** Open tiledata-file ***/
    if (! (pfile = fopen (pszFilename, "rb")))
    {
        sprintf (g_pszErr, rgpsz[TXT_COULD_NOT_OPEN_FILE_X], pszFilename);
        message (g_pszErr, RED, MSG_X, MSG_Y);
        return (NULL);
    }
#ifdef _DEBUG_
    message ("Opened file.", MAGENTA, MSG_X, MSG_Y);
#endif

    /*** Get number of tiles ***/
    fseek (pfile, 0L, SEEK_END);
    cTiles = (USHORT) (ftell (pfile) / SIZEOF_MAPTILE);
#ifdef _DEBUG_
    sprintf (g_pszErr, "To be loaded: %d tiles\n", cTiles);
    message (g_pszErr, MAGENTA, MSG_X, MSG_Y);
#endif

#ifdef _PRELOAD_TILES_    
    if (! (ptbox = create_tilebox (cTiles, XS_TILE, YS_TILE)))
        return (NULL);

#ifdef _DEBUG_
    message ("Tilebox created.", MAGENTA, MSG_X, MSG_Y);
#endif
    rewind (pfile);
    pv = ptbox->pv;
    for (i = 0; i < cTiles; i++)
    {
#ifdef _DEBUG_
    sprintf (g_pszErr, "Loaded tile %d\n", i);
    message (g_pszErr, MAGENTA, MSG_X, MSG_Y);
#endif

        read_xenon_tile (pfile, pv);
        (PBYTE) pv += ptbox->xs * ptbox->ys;
    }
#else
    /* FIXME ? */
    if (! (ptbox = (PTILEBOX) malloc (sizeof (TILEBOX))))
    {
        message (rgpsz[TXT_COULD_NOT_ALLOCATE_TILEBOX], RED, MSG_X, MSG_Y);
        return (NULL);
    }

    ptbox->xs = XS_TILE;
    ptbox->ys = YS_TILE;
    ptbox->cTiles = cTiles;
    ptbox->pv = NULL;
#endif

#ifdef _DEBUG_
    sprintf (g_pszErr, "Loaded %d tiles\n", cTiles);
    message (g_pszErr, MAGENTA, MSG_X, MSG_Y);
#endif
    
    *ppfile = pfile;
    return (ptbox);
}
/*************************************************************************/
