/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/

#include "version.h"
#include "xened.h"

/*************************************************************************/

CHAR g_pszErr[256], g_pszDir[256];
BYTE g_bLanguage;
PSZ *rgpsz = NULL;

CHAR *pszDummy = "Internal MRA-testing: CRC check ok.";
CHAR *pszDummy2 = "External MRA-testing: CRC check ok.";
CHAR *pszDummy3 = "MRA readout rate at %d\%";
CHAR *pszDummy4 = "MRA efficiency count %ld";

extern FILE *g_pfile;

#ifndef _LOADGIF_
LONG g_lPos;
#endif

/*************************************************************************/

#ifdef __LINUX__

/*int scan2x[] =
{
    27, '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '=', 8,
    15, 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', '(', ')', 13,
    ' ','a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', ';', '\'',' ', ' ',
    ' ','z', 'x', 'c', 'v', 'b', 'n', 'm', ',', '.', '/', ' ', ' ', ' ',
    ' ',' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    '7',' ', '8', ' ', '9', ' ', '-', '4', C_LEFT, '5', '6', C_RIGHT, '+', '1',
    ' ','2', C_UP, '3', ' ', '0', '.', '<', ' ', ' ', 13, ' ', ' ', '/',
    ' ',' ', ' ', ' ', ' ', C_HOME, ' ', PAGE_UP, C_LEFT, C_RIGHT, C_END,
    C_DOWN, PAGE_DOWN, ' ', K_DEL,
};*/
    
SHORT _read_kbd (int echo, int wait, int sig)
{
    int  kcode = getchar ();
    
    switch (kcode)
    {
    case SCANCODE_ENTER:  return (13);   break;
    case SCANCODE_BACKSPACE: return (8); break;
    case SCANCODE_TAB:    return (9);    break;
    case SCANCODE_ESCAPE: return (27);   break;
    case SCANCODE_A: return ('a'); break;
    case SCANCODE_B: return ('b'); break;
    case SCANCODE_C: return ('c'); break;
    case SCANCODE_D: return ('d'); break;
    case SCANCODE_E: return ('e'); break;
    case SCANCODE_F: return ('f'); break;
    case SCANCODE_G: return ('g'); break;
    case SCANCODE_H: return ('h'); break;
    case SCANCODE_I: return ('i'); break;
    case SCANCODE_J: return ('j'); break;
    case SCANCODE_K: return ('k'); break;
    case SCANCODE_L: return ('l'); break;
    case SCANCODE_M: return ('m'); break;
    case SCANCODE_N: return ('n'); break;
    case SCANCODE_O: return ('o'); break;
    case SCANCODE_P: return ('p'); break;
    case SCANCODE_Q: return ('q'); break;
    case SCANCODE_R: return ('r'); break;
    case SCANCODE_S: return ('s'); break;
    case SCANCODE_T: return ('t'); break;
    case SCANCODE_U: return ('u'); break;
    case SCANCODE_V: return ('v'); break;
    case SCANCODE_W: return ('w'); break;
    case SCANCODE_X: return ('x'); break;
    case SCANCODE_Y: return ('y'); break;
    case SCANCODE_Z: return ('z'); break;
    }

    return (kcode);

/*    if (kcode > 8*14)
        return (-1);
    
    return (scan2x[kcode]);*/
}

void my_set (int x, int y, int c)
{
    vga_setcolor (c);
    vga_drawpixel (x,y);
}

void my_line (int x1, int y1, int x2, int y2, int c)
{
    vga_setcolor (c);
    vga_drawline (x1, y1, x2, y2);
}

void my_rect (int x1, int y1, int x2, int y2, int c)
{
    vga_setcolor (c);
    vga_drawline (x1, y1, x2, y1);
    vga_drawline (x2, y1, x2, y2);
    vga_drawline (x2, y2, x1, y2);
    vga_drawline (x1, y2, x1, y1);
}

void my_box (int x1, int y1, int x2, int y2, int c)
{
    int i;
    
    vga_setcolor (c);

    for (i = y1; i <= y2; i++)
        vga_drawline (x1, i, x2, i);
}

#endif

#ifdef __TURBOC__
#include "std.h"
INT get_byte (void);
INT out_line (BYTE pixels[], INT linelen);

#ifdef _USE_CLOCK_
#include "timer.c"
#endif

#include "config.c"
#include "ed_event.c"
#include "ed_map.c"
#include "ed_weaps.c"
#include "gadgets.c"
#include "mainmenu.c"
#include "misc.c"
#include "text.c"
#include "tiles.c"
#include "viewer.c"
#include "xen_map.c"
#include "xen_tile.c"
#include "gif.c"

#endif

/*************************************************************************/

#ifdef _DRAWPIX_
#ifndef _NEWPALETTE_
USHORT col_tab[] =
{
    BLACK,      DARKGRAY,  LIGHTRED,   BROWN,      LIGHTBLUE,
    LIGHTGRAY,  CYAN,      WHITE,      LIGHTCYAN,  BLUE,
    0,          BLACK,     DARKGRAY,   RED,        YELLOW,
    RED,
};
#else
USHORT col_tab[] =
{
    BLACK,      DARKGRAY,  LIGHTRED,   BROWN,      LIGHTBLUE,
    LIGHTGRAY,  CYAN,      WHITE,      LIGHTCYAN,  BLUE,
    0,          BLACK,     DARKGRAY,   RED,        YELLOW,
    RED,
};
#endif
#endif

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

GADGET rggad[] =
{
/* 0 - Edit maps */
    {   0,  0,320,160, &rggad[11],&rggad[1], FALSE, NO_TILE, ACT_MAP_SET_FIELD },
    {   3,163, 19,179, &rggad[ 0],&rggad[2], TRUE,  6, ACT_TILES_PAGE_UP },
    {   3,181, 19,197, &rggad[ 1],&rggad[3], TRUE,  7, ACT_TILES_PAGE_DOWN },
    {  22,163,192,197, &rggad[ 2],&rggad[4], TRUE,  NO_TILE, -1 },
/*    {  22,163,158,197, &rggad[ 2],&rggad[4], TRUE,  NO_TILE, -1 },*/
    { 245,163,261,179, &rggad[ 3],&rggad[5], TRUE,  0, ACT_MAP_UP },
    { 245,181,261,197, &rggad[ 4],&rggad[6], TRUE,  1, ACT_MAP_DOWN },
    { 263,163,279,179, &rggad[ 5],&rggad[7], TRUE,  2, ACT_MAP_PAGE_UP },
    { 263,181,279,197, &rggad[ 6],&rggad[8], TRUE,  3, ACT_MAP_PAGE_DOWN },
    { 281,163,297,179, &rggad[ 7],&rggad[9], TRUE,  4, ACT_MAP_HOME },
    { 281,181,297,197, &rggad[ 8],&rggad[10], TRUE, 5, ACT_MAP_END },
    { 299,163,315,179, &rggad[ 9],&rggad[11], TRUE, 9, ACT_SAVE_MAP },
    { 299,181,315,197, &rggad[10],&rggad[0], TRUE,  8, ACT_QUIT },
/* 12 - Edit weapon prices */
    {  48,  8, 64, 24, &rggad[19],&rggad[13], TRUE,  6, ACT_WEAPON_PREV },
    {  48, 26, 64, 42, &rggad[12],&rggad[14], TRUE,  7, ACT_WEAPON_NEXT },
    { 111,  8,127, 24, &rggad[13],&rggad[15], TRUE,  0, ACT_WEAPON_10_MORE },
    { 111, 26,127, 42, &rggad[14],&rggad[16], TRUE,  1, ACT_WEAPON_10_LESS },
    { 129,  8,145, 24, &rggad[15],&rggad[17], TRUE,  2, ACT_WEAPON_100_MORE },
    { 129, 26,145, 42, &rggad[16],&rggad[18], TRUE,  3, ACT_WEAPON_100_LESS },
    { 152,  8,208, 24, &rggad[17],&rggad[19], TRUE,  9, ACT_WEAPONS_SAVE },
    { 152, 26,208, 42, &rggad[18],&rggad[12], TRUE,  8, ACT_WEAPONS_OK },
/* 20 - Text viewer */
    { 207,  8,223, 24, &rggad[22],&rggad[21], TRUE,  6, ACT_VIEW_PREV },
    { 207, 26,223, 42, &rggad[20],&rggad[22], TRUE,  7, ACT_VIEW_NEXT },
    { 207, 82,223, 98, &rggad[21],&rggad[20], TRUE,  8, ACT_VIEW_OK },
/* 23 - Edit sector events */
    {   8,  8,172, 81, &rggad[31],&rggad[24], TRUE,  NO_TILE, -1 },
    { 176,  8,192, 24, &rggad[23],&rggad[25], TRUE,  6, ACT_SECTOR_PREV },
    { 176, 26,192, 42, &rggad[24],&rggad[26], TRUE,  7, ACT_SECTOR_NEXT },
    { 202,  8,218, 24, &rggad[25],&rggad[27], TRUE,  0, ACT_SECTOR_1_MORE },
    { 202, 26,218, 42, &rggad[26],&rggad[28], TRUE,  1, ACT_SECTOR_1_LESS },
    { 220,  8,236, 24, &rggad[27],&rggad[29], TRUE,  2, ACT_SECTOR_10_MORE },
    { 220, 26,236, 42, &rggad[28],&rggad[30], TRUE,  3, ACT_SECTOR_10_LESS },
    { 176, 47,236, 63, &rggad[29],&rggad[31], TRUE,  9, ACT_SECTOR_SAVE },
    { 176, 65,236, 81, &rggad[30],&rggad[23], TRUE,  8, ACT_SECTOR_OK },
/* 32 - Configuration */
    {  0,  0,  0,  0, &rggad[33],&rggad[33], TRUE,  0, 0 },
    {  0,  0,  0,  0, &rggad[32],&rggad[32], TRUE,  0, 0 },
/* 34 - Edit sector events II */
/*    {   8,  8,132, 81, &rggad[31],&rggad[24], TRUE,  NO_TILE, -1 },
    { 136,  8,152, 24, &rggad[23],&rggad[25], TRUE,  6, ACT_SECTOR_PREV },
    { 136, 26,152, 42, &rggad[24],&rggad[26], TRUE,  7, ACT_SECTOR_NEXT },
    { 162,  8,178, 24, &rggad[25],&rggad[27], TRUE,  0, ACT_SECTOR_1_MORE },
    { 162, 26,178, 42, &rggad[26],&rggad[28], TRUE,  1, ACT_SECTOR_1_LESS },
    { 180,  8,196, 24, &rggad[27],&rggad[29], TRUE,  2, ACT_SECTOR_10_MORE },
    { 180, 26,196, 42, &rggad[28],&rggad[30], TRUE,  3, ACT_SECTOR_10_LESS },
    { 136, 47,196, 63, &rggad[29],&rggad[31], TRUE,  9, ACT_SECTOR_SAVE },
    { 136, 65,196, 81, &rggad[30],&rggad[23], TRUE,  8, ACT_SECTOR_OK },*/
};

GADGETLIST gadlist  = { 0, 0, &rggad[0],  &rggad[0],  NULL };
GADGETLIST gadlist2 = { 0, 0, &rggad[12], &rggad[12], NULL };
GADGETLIST gadlist3 = { 0, 0, &rggad[20], &rggad[20], NULL };
GADGETLIST gadlist4 = { 0, 0, &rggad[23], &rggad[23], NULL };
GADGETLIST gadlist5 = { 0, 0, &rggad[32], &rggad[32], NULL };

PTILEBOX ptbox, ptboxFont, ptboxWeaps, ptboxFlags;

SHORT   rgsValues[MAX_SECTORS][7];
BOOL    fTestVGA = TRUE;

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

int main (int argc, char *argv[])
{
    BOOL    fRedraw = TRUE, fConfig = FALSE;
    SHORT   sChoice;

#ifdef _DEBUG_
    printf ("Here we go ...\n");
    getchar ();    
#endif
    
    g_pszDir[0] = '\0';
    if (! CheckArgs (argc, argv))
        exit (ERROR);
#ifdef _DEBUG_
    printf ("Checked args ...\n");
    getchar ();    
#endif

    if (! LoadConfig (CONFIGFILE_N))
        fConfig = TRUE;
#ifdef _DEBUG_
    printf ("Loaded config ...\n");
    getchar ();    
#endif

    if (! DoMessageLoad ())
        exit (ERROR);
#ifdef _DEBUG_
    printf ("Loaded msgs ...\n");
    getchar ();    
#endif

#ifdef __TURBOC__
    if (fTestVGA)
        if (! IsVGA ())
        {
            fputs (rgpsz[TXT_NO_VGA_VIDEOCARD], stderr);
            exit (ERROR);
        }
    GFX_INIT (G_MODE_VGA_L);
#else
    {
        INT   iCheck = GFX_INIT (G_MODE_VGA_L);

#ifndef __LINUX__
        if (fTestVGA)
            if (! iCheck)
            {
                /* FIXME other message? */
                fputs (rgpsz[TXT_NO_VGA_VIDEOCARD], stderr);
                exit (ERROR);
            }
#endif

#ifdef __EMX__
#ifdef _NEWPALETTE_
        {
            static char  pal[16][3] =
            {
                { 2,2,2 },
                { 146,146,178 },
                { 178,182,218 },
                { 106,110,148 },
                { 34,38,74 },
                { 74,74,106 },
                { 2,2,34 },
                { 146,38,2 },
                { 178,74,34 },
                { 74,2,2 },
                { 250,182,2 },
                { 250,218,250 },
                { 106,2,2 },
                { 218,110,34 },
                { 0,0,0 },
                { 0,0,0 },
            };
            INT i;

            for (i = 0; i < 16; i++)
            {
                pal[i][0] /= 4;
                pal[i][1] /= 4;
                pal[i][2] /= 4;
            }
            g_vgapal (pal[0],16,16,0);
        }
#endif
#endif
    }
#endif

#ifdef _USE_CLOCK_
#ifdef __TURBOC__
    initializetimer();
#endif
#endif

#ifdef _MOUSE_
    ResetMouse ();
#endif

    if (! LoadTiles ())
        exit (ERROR);

#ifdef __LINUX__
    keyboard_init ();
#endif
    
    do
    {
        if (fRedraw)
        {
            GFX_CLEAR (BLACK);
            load_gif ("xened.gif", 62, 25);
            fRedraw = FALSE;
        }

        if (fConfig)
        {
            QueryConfig (&gadlist5, 0, 90);
            DoMessageLoad ();
            fConfig = FALSE;
        }
        
        switch (sChoice = MainMenu (76,43+27))
            {
            case 0:
                Viewer (&gadlist3, (320-232)/2+1, 75);
                break;

            case 1:
                EditWeapons (&gadlist2, g_pszDir, 51, 80);
                break;

            case 2:
            case 4:
            case 6:
            case 8:
            case 10:
                show_string (ptboxFont, rgpsz[TXT_PLEASE_WAIT],
                             (320-strlen (rgpsz[TXT_PLEASE_WAIT])*
                              (ptboxFont->xs+1))/2+1, 110, 100);
                EditSectorMap (&gadlist, g_pszDir, sChoice/2-1);
                fRedraw = TRUE;
                break;

            case 3:
            case 5:
            case 7:
            case 9:
            case 11:
                EditSectorEvents (&gadlist4, g_pszDir, (sChoice-1)/2-1,
                                  (320-244)/2+1, 75);
                break;

            case 12:
                fConfig = TRUE;
                break;
                
            case 13:
                SaveConfig (CONFIGFILE_N);
                break;

            default:
                message (rgpsz[TXT_NOT_YET_IMPLEMENTED], RED, MSG_X, MSG_Y);
                break;
            }
    }
    while (sChoice != 13);

#ifdef __LINUX__
    keyboard_close ();
#endif

#ifdef _USE_CLOCK_
#ifdef __TURBOC__
    restoretimer();
#endif
#endif
    
    GFX_CLOSE ();
    return (0);
}
/*************************************************************************/

BOOL LoadTiles (VOID)
{
    FILE   *pfile;

    if (! (pfile = fopen (DATFILE_N, "rb")))
    {
        sprintf (g_pszErr, rgpsz[TXT_COULD_NOT_OPEN_TILE_FILE], DATFILE_N);
        message (g_pszErr, RED, MSG_X, MSG_Y);
        return (FALSE);
    }

    if ((ptboxFont = load_tilebox_raw (pfile)) != NULL)
    {
#ifdef _DEBUG_
        sprintf (g_pszErr, "%d font-tiles loaded from\n\"%s\".",
                 ptboxFont->cTiles, DATFILE_N);
        message (g_pszErr, MAGENTA, MSG_X, MSG_Y);
#endif
        if ((ptbox = load_tilebox_raw (pfile)) != NULL)
        {
#ifdef _DEBUG_
            sprintf (g_pszErr, "%d tiles loaded from\n\"%s\".", ptbox->cTiles,
                     DATFILE_N);
            message (g_pszErr, MAGENTA, MSG_X, MSG_Y);
#endif
            if ((ptboxWeaps = load_tilebox_raw (pfile)) != NULL)
            {
#ifdef _DEBUG_
                sprintf (g_pszErr, "%d weapon-tiles loaded from\n\"%s\".",
                         ptboxWeaps->cTiles, DATFILE_N);
                message (g_pszErr, MAGENTA, MSG_X, MSG_Y);
#endif
                if ((ptboxFlags = load_tilebox_raw (pfile)) != NULL)
                {
#ifdef _DEBUG_
                    sprintf (g_pszErr, "%d flag-tiles loaded from\n\"%s\".",
                             ptboxFlags->cTiles, DATFILE_N);
                    message (g_pszErr, MAGENTA, MSG_X, MSG_Y);
#endif
                    gadlist.ptbox = ptbox;
                    gadlist2.ptbox = ptbox;
                    gadlist3.ptbox = ptbox;
                    gadlist4.ptbox = ptbox;
                    gadlist5.ptbox = ptboxFlags;
#ifndef _LOADGIF_
                    g_pfile = pfile;
                    g_lPos = ftell (pfile);
#else
                    fclose (pfile);
#endif
                    return (TRUE);
                }
                delete_tilebox (ptboxWeaps);
            }
            delete_tilebox (ptboxFont);
        }
        delete_tilebox (ptbox);
    }

    return (FALSE);
}
/*************************************************************************/

BOOL LoadMessages (PSZ pszFilename)
{
    PSZ        psz;
    long int   i, count = 0L, size = 0L;
    FILE       *pfile;

    if (! (pfile = fopen (pszFilename, "rb")))
    {
        switch (g_bLanguage)
            {
            case LANG_GERMAN:
                fprintf (stderr, "FEHLER: Konnte Meldungen-Datei \"%s\" nicht"
                         "ffnen.\n", pszFilename);
                break;

            case LANG_ENGLISH:
            default:
                fprintf (stderr, "ERROR: Could not open message-file \"%s\".\n",
                         pszFilename);
                break;
            }

        getchar ();
        return (FALSE);
    }

    fread (&count, 1, 2, pfile);
    fread (&size, 1, 2, pfile);

#ifdef _DEBUG_
    printf ("Count = %ld, Size = %ld\n", count, size);
    getchar ();
#endif

    if (! (rgpsz = malloc ((size_t)count * sizeof (PSZ))))
    {
        fclose (pfile);
        return (FALSE);
    }

#ifdef _DEBUG_
    printf ("Malloced rgpsz ...\n");
    getchar ();    
#endif

    if (! (rgpsz[0] = malloc ((size_t)size)))
    {
        free (rgpsz);
        fclose (pfile);
        return (FALSE);
    }

#ifdef _DEBUG_
    printf ("Malloced rgpsz[0] ...\n");
    getchar ();    
#endif

    fread (rgpsz[0], 1, (size_t)size, pfile);

#ifdef _DEBUG_
    printf ("Read stuff ...\n");
    getchar ();    
#endif

    psz = rgpsz[0];
    for (i = 0; i < count; i++)
    {
        rgpsz[(int)i] = psz;
        psz += strlen (psz)+1;
    }

#ifdef _DEBUG_
    printf ("Assigned string-ptrs ...\n");
    getchar ();    
#endif

    fclose (pfile);
    return (TRUE);
}
/*************************************************************************/

BOOL DoMessageLoad (VOID)
{
    BOOL   f;
    
    /*** Clear old message-buffer ***/
    if (rgpsz)
    {
        if (rgpsz[0])
            free (rgpsz[0]);
        free (rgpsz);
    }
    
    switch (g_bLanguage)
        {
        case LANG_GERMAN:
            f = LoadMessages ("german.msg");
            break;

        case LANG_ENGLISH:
        default:
            f = LoadMessages ("english.msg");
            break;
        }

    return (f);
}
/*************************************************************************/

BOOL CheckArgs (SHORT argc, STRPTR argv[])
{
    BOOL    fSyntax = FALSE;
    SHORT   usUnknown = 0;

    while (argc > 1)
    {
        argc--;
        
        if (stricmp (argv[argc], "-le") == 0)
            g_bLanguage = LANG_ENGLISH;
        else if (stricmp (argv[argc], "-lg") == 0)
            g_bLanguage = LANG_GERMAN;
        else if (stricmp (argv[argc], "-vga") == 0)
            fTestVGA = FALSE;
        else if ((strcmp (argv[argc], "?") == 0) ||
                 (strcmp (argv[argc], "-?") == 0) ||
                 (strcmp (argv[argc], "/?") == 0) ||
                 (strcmp (argv[argc], "-h") == 0))
            fSyntax = TRUE;
        else
        {
            if (stricmp (argv[argc-1], "-d") == 0)
            {
                strcpy (g_pszDir, argv[argc]);
                argc --;
            }
            else
            {
                fSyntax = TRUE;
                usUnknown = argc;
            }
        }
    }

    if (usUnknown)
    {
        switch (g_bLanguage)
            {
            case LANG_GERMAN:
                fprintf (stderr, "\nFEHLER: Unbekanntes Argument \"%s\".\n\n",
                         argv[usUnknown]);
                break;

            case LANG_ENGLISH:
            default:
                fprintf (stderr, "\nERROR: Unknown argument \"%s\".\n\n",
                         argv[usUnknown]);
                break;
            }
    }

    if (fSyntax)
    {
        switch (g_bLanguage)
            {
            case LANG_GERMAN:
                fprintf (stderr,
                         "XENED "VERSION_STR" - Der Xenon II Editor\n"
                         "Copyright (c) 1995-2001 Th. Thielen\n"
                         "-----------------------------------------\n"
                         "Aufruf: xened [-d xenon2-dir] [-le|-lg] [?|-?|/?|-h]\n"
                         "\n"
                         "-l?\tSprache whlen:\n"
                         "\t-le\tEnglisch\n"
                         "\t-lg\tDeutsch\n"
                         "-vga\tNicht auf Vorhandensein einer VGA-\n"
                         "\tGraphikkarte testen\n"
                         "? oder -? oder /? oder -h\tDiese Hilfe zeigen\n"
                         "-----------------------------------------\n"                         
                         );
                break;
                
            case LANG_ENGLISH:
            default:
                fprintf (stderr,
                         "XENED "VERSION_STR" - The Xenon II editor\n"
                         "Copyright (c) 1995-2001 Th. Thielen\n"
                         "-----------------------------------------\n"
                         "Syntax: xened [-d xenon2-dir] [-le|-lg] [?|-?|/?|-h]\n"
                         "\n"
                         "-l?\tSelect language:\n"
                         "\t-le\tEnglish\n"
                         "\t-lg\tGerman\n"
                         "-vga\tSkip test for VGA-videocard\n"
                         "? or -? or /? or -h\tShow this help\n"
                         "-----------------------------------------\n"                         
                         );
                break;
            }
        return (FALSE);
    }

    return (TRUE);
}
/*************************************************************************/

BOOL IsVGA (VOID)
{
#ifdef __TURBOC__
    union REGS   regs;

    regs.h.ah = 0x1a;
    regs.h.al = 0x00;
    int86 (0x10, &regs, &regs);

    if (regs.h.al != 0x1a)
        return FALSE;
#endif

    /* FIXME ? */
    return TRUE;
}
/*************************************************************************/
