/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/
/*
 * xen_tile.c - Xened
 */

#include "xened.h"

/*************************************************************************/

#ifdef _DRAWPIX_
extern USHORT col_tab[];
#endif

/*************************************************************************/

BOOL read_xenon_tile (FILE *pfile, PVOID pv)
{
#if (SIZEOF_MAPTILE != 16*8)
#error read_xenon_tile(): please enlarge buffer!
#endif
    
    UBYTE   buffer[16][8];
    PBYTE   pb = (PBYTE) pv;
    SHORT   x, y, z;

    if (! pfile || ! pb)
        return (FALSE);

    fread (buffer, 1, SIZEOF_MAPTILE, pfile);
    memset (pb, 0x00, YS_TILE*XS_TILE);

    for (y = 0; y < YS_TILE; y++)
        for (z = 0; z < 4; z++)
        {
            for (x = 8; x < XS_TILE; x++)
                if (BIT_SET (buffer[y], z*XS_TILE+x))
                    SET_BIT (&pb[ y*XS_TILE+23-x ], z);
            for (x = 0; x < 8; x++)
                if (BIT_SET (buffer[y], z*XS_TILE+x))
                    SET_BIT (&pb[ y*XS_TILE+7-x ], z);
        }

    for (z = 0; z < XS_TILE*YS_TILE; z++)
        pb[z] = col_tab[ pb[z] ];

    return (TRUE);
}
/*************************************************************************/
