/* CMDA1ON.CMD - X10 Command Control */

/*
  This is an example to show how to access the HOUSE/2, HOUSE/290 or the CM17A
  Comm Engine functions.
  This program connects to the Comm Engine pipe, turns on a module and exits.
  You can change the X10 commands below to any house, device or function code
  and rename this script accordingly. Consult the Comm Engine documentation
  for details on X10 command structure.

    Written by: Lone Peak Automation, LLC
    Date: Jan. 20, 2000
    This program requires the Comm Engines of HOUSE/2, HOUSE/290 or CM17A (FireCracker).
    See http://home.att.net/~ASchw for more information.

    Important: One of the Comm Engines must be running and be connected
               to the X10 controllers before using this script.
*/

/* Load the REXXUTIL.DLL */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Load the control pipe functions */
call RxFuncAdd 'X10MLoadFuncs', 'X10MDLL', 'X10MLoadFuncs'
call X10MLoadFuncs

/*
/* if using over network, replace CLIENT527 with your own computer's name */
pipename = '\\CLIENT527\PIPE\HOUSE2'
*/

/* Unremark pipename below for your Comm Engine */
pipename = '\PIPE\HOUSE2'    /* control pipe for HOUSE/2 (CM11A) */
/*
pipename = '\PIPE\HOUSE290'    /* control pipe for HOUSE/290 (CP290) */
pipename = '\PIPE\CM17ACE'    /* control pipe for CM17A (FireCracker) */
*/

piperr = MakePipe( pipename )   /* open control pipe */
IF piperr = 1 then
  EXIT

/*
Edit your X10 command here. Refer to Comm Engine documentation for valid commands.
Some valid commands are: A12 ON, B1 OFF, E10 DIM 30, M5 BRI 25
*/
temp = '}ID1 A1 ON'      /* X10 House, Device and Function code */

rc = CLMWritePipe(temp)  /* write command to Comm Engine */
CALL SysSleep 2          /* Delay of 2 seconds to wait for command execution */
rc = CLMReadPipe('0')    /* read confirmation */
/* next line cam be remarked out for troubleshooting */
/* SAY 'reading from pipe >' || rc || '<' */

/*
   Close pipe to free up Comm Engine.
   If pipe is not closed and the command line window
   remains open, then the Comm Engine stays tied up.
   Closing of command line window will also close the
   pipe automatically.
*/
rc = CLMClosePipe('0')

call X10MDropFuncs

EXIT


/* Open control pipe */

MakePipe: PROCEDURE

ARG pipename
piperr = 1
rc = CLMOpenPipe(pipename)

IF rc = 0 then
  DO
    rc =  CLMPeekPipe('0')
    IF Right(rc, 1) = 3 then
      DO
       SAY pipename || ' connected'
       piperr = 0
      END
    else
      DO
       SAY pipename || ' unavailable, close'
       rc = CLMClosePipe('0')
      END
  END
ELSE
  DO
   SAY pipename || ' not available'
   rc = CLMClosePipe('0')
  END
RETURN piperr
