/* OS/2 includes */
#define INCL_DOSPROCESS
#define INCL_WIN
#include <os2.h>

/* C includes */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* App includes */
#include "ows.h"
#include "pmassert.h"

/* Thread 2 entry point. Gets and dispatches object window messages */
/* _Optlink is an IBM CSet/2 modifier */
void _Optlink threadmain(void *pv)
{
    BOOL            fSuccess;
    HAB             hab;
    HMQ             hmq;
    PGLOBALS        pg;
    QMSG            qmsg;

    /* Cast and set pointer to globals */
    pg = (PGLOBALS) pv;

    /* Thread initialization */
    hab = WinInitialize(0);
    hmq = WinCreateMsgQueue(hab, 0);

    /* Prevent system from posting object window a WM_QUIT */
    /* I'll post WM_QUIT when it's time */
    fSuccess = WinCancelShutdown(hmq, TRUE);
    pmassert(hab,  fSuccess);

    fSuccess = WinRegisterClass(hab,
                    OWS_CLASS_OBJECT,
                    (PFNWP)ObjectWinProc,
                    0,
                    sizeof(PGLOBALS));
    pmassert(hab, fSuccess);

    /* *LAB* Create the object window */













    pmassert(hab, pg->hwndObject);

    /* Created OK, acknowledge client */
    WinPostMsg(pg->hwndClient, WM_USER_ACK, 0, 0);

    while(WinGetMsg(hab, &qmsg, 0, 0, 0))
        WinDispatchMsg(hab, &qmsg);

    /* Tell client window to quit */
    WinPostMsg(pg->hwndClient, WM_QUIT, 0, 0);

    /* Clean up */
    WinDestroyWindow(pg->hwndObject);
    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);
    return;
}

/* Object window procedure; mp1 is the window to acknowledge upon completion */
MRESULT EXPENTRY ObjectWinProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    PGLOBALS        pg;
    HWND            hwndToAck;

    /* Store the handle of the window to ack upon completion */
    hwndToAck = (HWND) mp1;

    switch(msg) {
        case WM_CREATE:
            /* For the create case mp1 is pointer to globals. Save it
                in the object window words */
            pg = (PGLOBALS) mp1;
            WinSetWindowULong(hwnd, QWL_USER, (ULONG)pg);
            return (MRESULT) 0;
            break;

        case WM_USER_SLEEP:
            /* Get pointer to globals from window words */
            pg = (PGLOBALS) WinQueryWindowULong(hwnd, QWL_USER);
            /* Sleep as though this were a time-consuming task */
            DosSleep(20000);
            DosBeep(500, 150);
            /* *LAB* Tell originating window that the task is complete */

            return (MRESULT) 0;
            break;

        default:
            return WinDefWindowProc(hwnd, msg, mp1, mp2);
            break;
    }
}

