#include <stdlib.h>

#define INCL_PM
#include <os2.h>

#include "MainWin.hpp"
#include "SaverRc.h"


SaverMainWin::CommandHandler::CommandHandler(SaverMainWin &mw):ICommandHandler(),main(mw){
   handleEventsFor(&main);
}

SaverMainWin::CommandHandler::~CommandHandler(){

}

Boolean SaverMainWin::CommandHandler::systemCommand(ICommandEvent &evt){
   if(evt.commandId()==SC_CLOSE){
      main.hide();
   }
return false;
}

Boolean SaverMainWin::CommandHandler::command(ICommandEvent &evt){
   switch(evt.commandId()){
      case ButTest:
         if(main.GetActiveSaver() !=NULL)
            main.GetActiveSaver()->ActivateSaver();
         break;
      case ButDrop:
      case ButAdd:
      case ButHide:
         main.minimize();
         break;         
      default: 
         return false;
   }

return true;
}



SaverMainWin::SaverMainWin():IFrameWindow(IFrameWindow::border|
                                          IFrameWindow::systemMenu|
                                          IFrameWindow::titleBar|
                                          IFrameWindow::minimizeButton ,1),
                              myclient(10,this,this),List(ListBox,&myclient),handler(*this){

   handler.handleEventsFor(&myclient);
   setClient(&myclient);

   moveSizeToClient(myclient.rect());

   somId classId = somIdFromString("TestSaver");
   SOMClass *myClass = SOMClassMgrObject->somFindClsInFile(classId,
                            1, 1,"TstSave");

   SOMFree(classId);
  
   Saver=(SaverModule *) myClass->somNew();

   List.addAsLast(Saver->GetSaverName());

   addToWindowList();
}

SaverMainWin::~SaverMainWin(){
   if(Saver)
      delete Saver;
}
