 

 /* Definitions */
 
 #define INCL_WINFRAMEMGR
 
 #define MYAPP           "MyApp"
 #define ID_MYWINDOW     42
 
 /* Includes */
 
 #include <os2.h>
 
 /* Prototypes */
 
 MRESULT EXPENTRY MyWinProc (HWND, ULONG, MPARAM, MPARAM);
 
 /* Global Variables */
 
 HAB     hab;
 HWND    hwndClient,
         hwndFrame;
 
 /* main function */
 
 void main (void)
 {
     HMQ     hmq;
     QMSG    qmsg;
     ULONG   flCreate;
 
     hab = WinInitialize (0);
     if (!hab)
         return;
 
     hmq = WinCreateMsgQueue (hab, 0);
     WinRegisterClass(
         hab,
         MYAPP,
         (PFNWP) MyWinProc,
         CS_SIZEREDRAW,
         0);
 
     flCreate =  FCF_TITLEBAR    | FCF_SYSMENU       |
                 FCF_SIZEBORDER  | FCF_MINMAX        |
                 FCF_TASKLIST    | FCF_SHELLPOSITION ;
 
     hwndFrame = WinCreateStdWindow(
         HWND_DESKTOP,
         WS_VISIBLE,
         &flCreate,
         MYAPP,
         "Sample PM App",
         0L,
         NULLHANDLE,
         ID_MYWINDOW,
         &hwndClient);
 
     while (WinGetMsg (hab,&qmsg,(HWND)NULL,0,0))
         WinDispatchMsg (hab,&qmsg);
 
     WinDestroyWindow(hwndFrame);
     WinDestroyMsgQueue(hmq);
     WinTerminate(hab);
 }
 
 /* our window procedure */
 
 MRESULT EXPENTRY MyWinProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
 {
     switch (msg)
     {
         case WM_ERASEBACKGROUND:
             return (MRESULT) TRUE;
             break;
 
         case WM_CLOSE:
             if (WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,
                               "Are you sure you want to quit?","Sample",
                               0,MB_YESNO | MB_QUERY) == MBID_YES)
                 WinPostMsg(hwnd,WM_QUIT,0L,0L);
         break;
 
         default:
             return WinDefWindowProc (hwnd, msg, mp1, mp2);
     }
     return FALSE;
 }
   

