#define INCL_GPILCIDS
#define INCL_WIN
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "rc.h"

#define CLS_CLIENT               "MenuTestClass"

MRESULT EXPENTRY wndProc(HWND hwndWnd,
                         ULONG ulMsg,
                         MPARAM mpParm1,
                         MPARAM mpParm2)
{
   switch (ulMsg) {
   case WM_COMMAND:
      switch (SHORT1FROMMP(mpParm1)) {
      case MI_CREATE:
         {
            HWND hwndMenu;
            ULONG ulCount;
            ULONG ulSzText;
            ULONG ulSzItem;
            ULONG ulSzBuf;
            LPMT pmtMenu;
            HPS hpsTemp;
            MTI *pmtiItem;
            USHORT usIndex;
            HWND hwndSubMenu;
            MENUITEM miSubMenu;
            CHAR achText[32];

            hwndMenu=WinWindowFromID(WinQueryWindow(hwndWnd,QW_PARENT),
                                     FID_MENU);

            ulCount=MI_TESTLAST-MI_TESTFIRST+1;

            //-------------------------------------------------------------
            // 13=strlen("Menu item xx")+1 for the '\0'.
            //-------------------------------------------------------------
            ulSzText=13;
            ulSzItem=sizeof(MTI)-2+ulSzText;

            //-------------------------------------------------------------
            // Remember that although MT includes a single MTI structure,
            // the MTI structure is variable length, so the
            // (ulSzItem-sizeof(MTI)) calculates the space beyond the
            // end of the first structure.
            //-------------------------------------------------------------
            ulSzBuf=sizeof(MT)+(ulSzItem-sizeof(MTI))+(ulCount-1)*ulSzItem;

            pmtMenu=calloc(1,ulSzBuf);
            if (pmtMenu==NULL) {
               WinAlarm(HWND_DESKTOP,WA_ERROR);
               return MRFROMSHORT(FALSE);
            } /* endif */

            //-------------------------------------------------------------
            // Initialize the menu template
            //-------------------------------------------------------------
            pmtMenu->len=ulSzBuf;

            hpsTemp=WinGetPS(hwndWnd);
            pmtMenu->codepage=GpiQueryCp(hpsTemp);
            WinReleasePS(hpsTemp);

            pmtMenu->reserved=0;
            pmtMenu->cMti=ulCount;

            //-------------------------------------------------------------
            // Initialize the menu template items.  Remember that the
            // MTI structures are variable-length, so we have to keep
            // track of where they begin (stored in pmtiItem).
            //-------------------------------------------------------------
            pmtiItem=&pmtMenu->rgMti[0];

            for (usIndex=0; usIndex<ulCount; usIndex++) {
               pmtiItem->afStyle=MIS_TEXT;
               pmtiItem->pad=0;
               pmtiItem->idItem=MI_TESTFIRST+usIndex;
               sprintf(pmtiItem->c,"Menu item %02d",usIndex+1);

               pmtiItem=(MTI *)(((PBYTE)pmtiItem)+ulSzItem);
            } /* endfor */

            //-------------------------------------------------------------
            // Create the submenu, specifying the menu template as
            // pCreateParms.  Since we free the template on unsuccessful
            // completion or successful completion (since the menu copies
            // the template into its internal data area), free() it before
            // checking for success.
            //-------------------------------------------------------------
            hwndSubMenu=WinCreateWindow(HWND_DESKTOP,
                                        WC_MENU,
                                        "",
                                        0,
                                        0,
                                        0,
                                        0,
                                        0,
                                        HWND_DESKTOP,
                                        HWND_TOP,
                                        M_TESTMENU,
                                        pmtMenu,
                                        NULL);
            free(pmtMenu);

            if (hwndSubMenu==NULLHANDLE) {
               WinAlarm(HWND_DESKTOP,WA_ERROR);
               return MRFROMSHORT(FALSE);
            } /* endif */

            //-------------------------------------------------------------
            // Insert the submenu in the action bar
            //-------------------------------------------------------------
            miSubMenu.iPosition=MIT_END;
            miSubMenu.afStyle=MIS_SUBMENU|MIS_TEXT;
            miSubMenu.afAttribute=0;
            miSubMenu.id=M_TESTMENU;
            miSubMenu.hwndSubMenu=hwndSubMenu;
            miSubMenu.hItem=NULLHANDLE;

            strcpy(achText,"~Test");

            WinSendMsg(hwndMenu,
                       MM_INSERTITEM,
                       MPFROMP(&miSubMenu),
                       MPFROMP(achText));

            //-------------------------------------------------------------
            // We don't want the user to be able to create yet another
            // pulldown, so disable this option.
            //-------------------------------------------------------------
            WinSendMsg(hwndMenu,
                       MM_SETITEMATTR,
                       MPFROM2SHORT(MI_CREATE,TRUE),
                       MPFROM2SHORT(MIA_DISABLED,MIA_DISABLED));
         }
         break;
      case MI_EXIT:
         WinPostMsg(hwndWnd,WM_CLOSE,0,0);
         break;
      default:
         return WinDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
      } /* endswitch */
      break;
   case WM_PAINT:
      {
         HPS hpsPaint;
         RECTL rclPaint;

         hpsPaint=WinBeginPaint(hwndWnd,NULLHANDLE,&rclPaint);
         WinFillRect(hpsPaint,&rclPaint,SYSCLR_APPWORKSPACE);
         WinEndPaint(hpsPaint);
      }
      break;
   default:
      return WinDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
   } /* endswitch */

   return MRFROMSHORT(FALSE);
}

INT main(VOID)
{
   HAB habAnchor;
   HMQ hmqQueue;
   ULONG ulCreate;
   HWND hwndFrame;
   HWND hwndClient;
   BOOL bLoop;
   QMSG qmMsg;

   habAnchor=WinInitialize(0);
   hmqQueue=WinCreateMsgQueue(habAnchor,0);

   WinRegisterClass(habAnchor,CLS_CLIENT,wndProc,0,sizeof(PVOID));

   ulCreate=FCF_SYSMENU | FCF_TITLEBAR | FCF_MINMAX | FCF_SIZEBORDER |
               FCF_MENU | FCF_ICON | FCF_SHELLPOSITION | FCF_TASKLIST;

   hwndFrame=WinCreateStdWindow(HWND_DESKTOP,
                                WS_VISIBLE,
                                &ulCreate,
                                CLS_CLIENT,
                                "Menu Test",
                                0,
                                NULLHANDLE,
                                RES_CLIENT,
                                &hwndClient);
   if (hwndFrame!=NULLHANDLE) {
      bLoop=WinGetMsg(habAnchor,&qmMsg,NULLHANDLE,0,0);
      while (bLoop) {
         WinDispatchMsg(habAnchor,&qmMsg);
         bLoop=WinGetMsg(habAnchor,&qmMsg,NULLHANDLE,0,0);
      } /* endwhile */

      WinDestroyWindow(hwndFrame);
   } /* endif */

   WinDestroyMsgQueue(hmqQueue);
   WinTerminate(habAnchor);
   return 0;
}
