/************************************************************
    playvid.cmd

    REXX procedure to play a software video at 25% speed
    usage: pmrexx playvid name.avi

    Marc E.E. van Woerkom, 1/94
 ************************************************************/

parse arg avi                                      /* fetch first argument */

if avi = '' then do
    say 'usage: pmrexx playvid name.avi'
    exit 0
end

say '(Playing a Software Video at 25% speed ...'

rc = call RxFuncAdd('mciRxInit', 'MCIAPI',,        /* register MCI REXX API */
                    'mciRxInit')
rc = call mciRxInit()                              /* and initialize it */

rc = mciRxSendString('open digitalvideo alias',  /* open player */
                     'video wait',,
                     'RetStr', '0', '0')                 

rc = mciRxSendString('info video',                 /* ask for product info */
                     'product wait',,
                     'videoinfo', '0', '0')

say '    Digital Video Device is' videoinfo

rc2 = mciRxSendString('load video' avi,,           /* play *.avi */
                     'RetStr', '0', '0')

rc = mciRxSendString('set video speed',            /* set speed in % */
                     'format percentage wait',,        
                     'RetStr', '0', '0')

rc = mciRxSendString('play video speed 25 wait',,  /* play file */
                     'RetStr', '0', '0')

rc = mciRxSendString('close video wait',,          /* close video device */
                     'RetStr', '0', '0')
if rc2 <> 0 then do
    rc = mciRxGetErrorString(rc2, 'ErrStVar')
    say '    ERROR! rc =' rc2 ', ErrStVar =' ErrStVar
    say ' ... failed!)'
    exit rc
end
else say ' ... done.)'

call mciRxExit

exit rc                                         /* exit with rc code */
