#define QH_ERROR                 (USHORT)0
#define QH_HCSPLAYGROUND         (USHORT)8
#define QH_HCSSPRITE             (USHORT)9

#define SIG_CMNSPR               (USHORT)0x1129

typedef struct _CMNHANDLE {
   ULONG ulSig;
   ULONG ulStatus;
   HMTX hsmAccess;
} CMNHANDLE, FAR *PCMNHANDLE;

#define ACCSEM_SET               0
#define ACCSEM_CLEAR             1
#define ACCSEM_ALREADYSET        2
#define ACCSEM_NOTSET            3
#define ACCSEM_ERROR             4

#define HSTATUS_INLIBRARY        0x00000001L

#define MAX_SPRITES              64

#define MAX_SPRITE_CX            128
#define MAX_SPRITE_CY            128

#define SSL_TOP                  -1L
#define SSL_BOTTOM               -2L
#define SSL_UP                   -3L
#define SSL_DOWN                 -4L

typedef LONG SPRERROR;

#define SPR_ERR_NOERROR          0x00000000L
#define SPR_ERR_ERROR            0xFFFFFFFFL
#define SPR_ERR_BADHANDLE        0x00000001L
#define SPR_ERR_BMPTOOLARGE      0x00000002L
#define SPR_ERR_RESOURCE         0x00000003L
#define SPR_ERR_NOMEMORY         0x00000004L
#define SPR_ERR_HASPLAYGROUND    0x00000005L
#define SPR_ERR_HASNOPLAYGROUND  0x00000006L
#define SPR_ERR_PLAYGROUNDFULL   0x00000007L
#define SPR_ERR_HASBACKGROUND    0x00000008L
#define SPR_ERR_BADLAYER         0x00000009L
#define SPR_ERR_NOTFOUND         0x0000000AL

#define SIG_CSPLAYGROUND         MAKEULONG(SIG_CMNSPR,0)
#define SIG_CSSPRITE             MAKEULONG(SIG_CMNSPR,1)

typedef struct _HCSSPRITE {
   ULONG ulSig;
   ULONG ulStatus;
   HMTX hsmAccess;

   HAB habAnchor;
   HBITMAP hbmBitmap;
   HBITMAP hbmMask;
   BITMAPINFOHEADER2 bmihBitmap;
   BITMAPINFOHEADER2 bmihMask;

   struct _HCSPLAYGROUND *hpgPlay;
   POINTL ptlPos;
   BOOL bVisible;
} CSSPRITE, *HCSSPRITE;
typedef HCSSPRITE *PHCSSPRITE;

typedef struct _HCSPLAYGROUND {
   ULONG ulSig;
   ULONG ulStatus;
   HMTX hsmAccess;

   HAB habAnchor;
   HDC hdcWork;
   HPS hpsWork;
   HBITMAP hbmWork;

   HBITMAP hbmBack;
   BITMAPINFOHEADER2 bmihBack;
   LONG lBackColor;

   BOOL bUpdate;

   HCSSPRITE ahsSprites[MAX_SPRITES];
   ULONG ulNumMembers;
} CSPLAYGROUND, *HCSPLAYGROUND;
typedef HCSPLAYGROUND *PHCSPLAYGROUND;

SPRERROR EXPENTRY CmnSprCreatePlayground(HAB habAnchor,
                                         PHCSPLAYGROUND phpgPlay);
SPRERROR EXPENTRY CmnSprDestroyPlayground(HCSPLAYGROUND hpgPlay);
SPRERROR EXPENTRY CmnSprAddSprite(HCSPLAYGROUND hpgPlay,HCSSPRITE hsSprite);
SPRERROR EXPENTRY CmnSprRemoveSprite(HCSPLAYGROUND hpgPlay,HCSSPRITE hsSprite);
SPRERROR EXPENTRY CmnSprSetPlaygroundBack(HCSPLAYGROUND hpgPlay,
                                          HBITMAP hbmNew,
                                          HBITMAP *phbmOld);
SPRERROR EXPENTRY CmnSprQueryPlaygroundBack(HCSPLAYGROUND hpgPlay,
                                            HBITMAP *phbmBack);
SPRERROR EXPENTRY CmnSprSetPlaygroundSize(HCSPLAYGROUND hpgPlay,
                                          PSIZEL pszlSize);
SPRERROR EXPENTRY CmnSprQueryPlaygroundSize(HCSPLAYGROUND hpgPlay,
                                            PSIZEL pszlSize);
SPRERROR EXPENTRY CmnSprSetPlaygroundColor(HCSPLAYGROUND hpgPlay,
                                           LONG lBackColor);
SPRERROR EXPENTRY CmnSprQueryPlaygroundColor(HCSPLAYGROUND hpgPlay,
                                             PLONG plBackColor);
SPRERROR EXPENTRY CmnSprSetUpdateFlag(HCSPLAYGROUND hpgPlay,BOOL bUpdate);
SPRERROR EXPENTRY CmnSprQueryUpdateFlag(HCSPLAYGROUND hpgPlay,PBOOL pbUpdate);
SPRERROR EXPENTRY CmnSprDrawPlayground(HPS hpsDraw,HCSPLAYGROUND hpgPlay);
SPRERROR EXPENTRY CmnSprCreateSprite(HAB habAnchor,
                                     HBITMAP hbmBitmap,
                                     PHCSSPRITE phsSprite);
SPRERROR EXPENTRY CmnSprDestroySprite(HCSSPRITE hsSprite);
SPRERROR EXPENTRY CmnSprSetSpritePosition(HPS hpsDraw,
                                          HCSSPRITE hsSprite,
                                          PPOINTL pptlNew);
SPRERROR EXPENTRY CmnSprQuerySpritePosition(HCSSPRITE hsSprite,
                                            PPOINTL pptlPos);
SPRERROR EXPENTRY CmnSprQuerySpriteSize(HCSSPRITE hsSprite,PSIZEL pszlSize);
SPRERROR EXPENTRY CmnSprQuerySpriteRect(HCSSPRITE hsSprite,PRECTL prclRect);
SPRERROR EXPENTRY CmnSprSetSpriteVisibility(HPS hpsDraw,
                                            HCSSPRITE hsSprite,
                                            BOOL bVisible);
SPRERROR EXPENTRY CmnSprQuerySpriteVisibility(HCSSPRITE hsSprite,
                                              PBOOL pbVisible);
SPRERROR EXPENTRY CmnSprDrawSprite(HPS hpsDraw,HCSSPRITE hsSprite);
SPRERROR EXPENTRY CmnSprSetLayering(HPS hpsDraw,HCSSPRITE hsSprite,LONG lPos);
SPRERROR EXPENTRY CmnSprQueryLayering(HCSSPRITE hsSprite,PLONG plPos);
