//-------------------------------------------------------------------------
// The following is part of the VIOWIN user-interface library source code.
// The code is copyright (c) 1994-1995 by Larry Salomon, Jr. and may not
// be used in a for-profit application without the expressed, written
// consent of Larry Salomon, Jr.  All rights reserved.
//-------------------------------------------------------------------------
#define INCL_DOSRESOURCES
#include "vwdefs.h"
#include <string.h>

BOOL EXPENTRY vwLoadString(ULONG ulId,ULONG ulSzBuf,PCHAR pchBuf)
//-------------------------------------------------------------------------
// This function loads a string from a STRINGTABLE resource.
//
// Input:  ulId - identifier of the string in the STRINGTABLE
//         ulSzBuf - size of the buffer pointed to by pchBuf
//         pchBuf - points to the buffer to hold the result
// Output:  pchBuf - holds the loaded string
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   ULONG ulSubId;
   ULONG ulSubMod;
   PVOID pvTable;
   PCHAR pchCurrent;

   *pchBuf=0;

   //----------------------------------------------------------------------
   // Calculate the STRINGTABLE's resource id and the id of the string
   // within it.
   //----------------------------------------------------------------------
   ulSubId=(ulId/16)+1;
   ulSubMod=ulId%16;

   //----------------------------------------------------------------------
   // Load the STRINGTABLE
   //----------------------------------------------------------------------
   if (DosGetResource(NULLHANDLE,RT_STRING,ulSubId,&pvTable)!=0) {
      return FALSE;
   } /* endif */

   //----------------------------------------------------------------------
   // Search for the string in the table.
   //----------------------------------------------------------------------
   pchCurrent=(PCHAR)pvTable;
   pchCurrent+=2;

   while (ulSubMod>0) {
      pchCurrent+=(*pchCurrent)+1;
      ulSubMod--;
   } /* endwhile */

   *pchBuf=0;
   strncat(pchBuf,pchCurrent+1,ulSzBuf);

   DosFreeResource(pvTable);
   return TRUE;
}
